/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.commons.exceptions.ITextException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public final class CMapCharsetEncoder {
    private final CharsetEncoder encoder;
    private final CharBuffer charBuf = CharBuffer.allocate(2);
    private final boolean bmpOnly;
    private final Charset targetCharset;

    public CMapCharsetEncoder(Charset targetCharset) {
        this(targetCharset, false);
    }

    public CMapCharsetEncoder(Charset targetCharset, boolean bmpOnly) {
        this.bmpOnly = bmpOnly;
        this.targetCharset = targetCharset;
        this.encoder = targetCharset.newEncoder();
    }

    public byte[] encodeUnicodeCodePoint(int cp) {
        ByteBuffer destBuf;
        if (!Character.isBmpCodePoint(cp) && this.bmpOnly) {
            throw new ITextException("This encoder only accepts BMP codepoints");
        }
        this.charBuf.clear();
        this.charBuf.put(Character.toChars(cp));
        this.charBuf.flip();
        this.encoder.reset();
        try {
            destBuf = this.encoder.encode(this.charBuf);
        }
        catch (CharacterCodingException e) {
            throw new ITextException(MessageFormatUtil.format((String)"Error during encoding the following code point: {0} in characterset: {1}", (Object[])new Object[]{cp, this.targetCharset.name()}), (Throwable)e);
        }
        byte[] result = new byte[destBuf.limit()];
        destBuf.get(result);
        return result;
    }
}

