/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GsubLookupType1;
import com.itextpdf.io.font.otf.GsubLookupType2;
import com.itextpdf.io.font.otf.GsubLookupType3;
import com.itextpdf.io.font.otf.GsubLookupType4;
import com.itextpdf.io.font.otf.GsubLookupType5;
import com.itextpdf.io.font.otf.GsubLookupType6;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OpenTypeGdefTableReader;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.Map;

public class GlyphSubstitutionTableReader
extends OpenTypeFontTableReader {
    public GlyphSubstitutionTableReader(RandomAccessFileOrArray rf, int gsubTableLocation, OpenTypeGdefTableReader gdef, Map<Integer, Glyph> indexGlyphMap, int unitsPerEm) throws IOException {
        super(rf, gsubTableLocation, gdef, indexGlyphMap, unitsPerEm);
        this.startReadingTable();
    }

    @Override
    protected OpenTableLookup readLookupTable(int lookupType, int lookupFlag, int[] subTableLocations) throws IOException {
        if (lookupType == 7) {
            for (int k = 0; k < subTableLocations.length; ++k) {
                int location = subTableLocations[k];
                this.rf.seek(location);
                this.rf.readUnsignedShort();
                lookupType = this.rf.readUnsignedShort();
                subTableLocations[k] = location += this.rf.readInt();
            }
        }
        switch (lookupType) {
            case 1: {
                return new GsubLookupType1(this, lookupFlag, subTableLocations);
            }
            case 2: {
                return new GsubLookupType2(this, lookupFlag, subTableLocations);
            }
            case 3: {
                return new GsubLookupType3(this, lookupFlag, subTableLocations);
            }
            case 4: {
                return new GsubLookupType4(this, lookupFlag, subTableLocations);
            }
            case 5: {
                return new GsubLookupType5(this, lookupFlag, subTableLocations);
            }
            case 6: {
                return new GsubLookupType6(this, lookupFlag, subTableLocations);
            }
        }
        return null;
    }
}

