/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.woff2;

import com.itextpdf.io.codec.brotli.dec.BrotliInputStream;
import com.itextpdf.io.font.woff2.Buffer;
import com.itextpdf.io.font.woff2.FontCompressionException;
import com.itextpdf.io.font.woff2.JavaUnsignedUtil;
import com.itextpdf.io.font.woff2.Round;
import com.itextpdf.io.font.woff2.StoreBytes;
import com.itextpdf.io.font.woff2.TableTags;
import com.itextpdf.io.font.woff2.VariableLength;
import com.itextpdf.io.font.woff2.Woff2Common;
import com.itextpdf.io.font.woff2.Woff2Out;
import com.itextpdf.io.util.MessageFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class Woff2Dec {
    private static final int kGlyfOnCurve = 1;
    private static final int kGlyfXShort = 2;
    private static final int kGlyfYShort = 4;
    private static final int kGlyfRepeat = 8;
    private static final int kGlyfThisXIsSame = 16;
    private static final int kGlyfThisYIsSame = 32;
    private static final int FLAG_ARG_1_AND_2_ARE_WORDS = 1;
    private static final int FLAG_WE_HAVE_A_SCALE = 8;
    private static final int FLAG_MORE_COMPONENTS = 32;
    private static final int FLAG_WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int FLAG_WE_HAVE_A_TWO_BY_TWO = 128;
    private static final int FLAG_WE_HAVE_INSTRUCTIONS = 256;
    private static final int kCheckSumAdjustmentOffset = 8;
    private static final int kEndPtsOfContoursOffset = 10;
    private static final int kCompositeGlyphBegin = 10;
    private static final int kDefaultGlyphBuf = 5120;
    private static final float kMaxPlausibleCompressionRatio = 100.0f;

    Woff2Dec() {
    }

    private static int withSign(int flag, int baseval) {
        return (flag & 1) != 0 ? baseval : -baseval;
    }

    private static int tripletDecode(byte[] data, int flags_in_offset, int in_offset, int in_size, int n_points, Woff2Common.Point[] result) {
        int x = 0;
        int y = 0;
        if (n_points > in_size) {
            throw new FontCompressionException("Reconstructing woff2 glyph exception");
        }
        int triplet_index = 0;
        for (int i = 0; i < n_points; ++i) {
            int b0;
            int dy;
            int dx;
            int n_data_bytes;
            boolean on_curve;
            int flag = JavaUnsignedUtil.asU8(data[i + flags_in_offset]);
            boolean bl = on_curve = flag >> 7 == 0;
            if (triplet_index + (n_data_bytes = (flag &= 0x7F) < 84 ? 1 : (flag < 120 ? 2 : (flag < 124 ? 3 : 4))) > in_size || triplet_index + n_data_bytes < triplet_index) {
                throw new FontCompressionException("Reconstructing woff2 glyph exception");
            }
            if (flag < 10) {
                dx = 0;
                dy = Woff2Dec.withSign(flag, ((flag & 0xE) << 7) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index]));
            } else if (flag < 20) {
                dx = Woff2Dec.withSign(flag, ((flag - 10 & 0xE) << 7) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index]));
                dy = 0;
            } else if (flag < 84) {
                b0 = flag - 20;
                int b1 = JavaUnsignedUtil.asU8(data[in_offset + triplet_index]);
                dx = Woff2Dec.withSign(flag, 1 + (b0 & 0x30) + (b1 >> 4));
                dy = Woff2Dec.withSign(flag >> 1, 1 + ((b0 & 0xC) << 2) + (b1 & 0xF));
            } else if (flag < 120) {
                b0 = flag - 84;
                dx = Woff2Dec.withSign(flag, 1 + (b0 / 12 << 8) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index]));
                dy = Woff2Dec.withSign(flag >> 1, 1 + (b0 % 12 >> 2 << 8) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 1]));
            } else if (flag < 124) {
                int b2 = JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 1]);
                dx = Woff2Dec.withSign(flag, (JavaUnsignedUtil.asU8(data[in_offset + triplet_index]) << 4) + (b2 >> 4));
                dy = Woff2Dec.withSign(flag >> 1, ((b2 & 0xF) << 8) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 2]));
            } else {
                dx = Woff2Dec.withSign(flag, (JavaUnsignedUtil.asU8(data[in_offset + triplet_index]) << 8) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 1]));
                dy = Woff2Dec.withSign(flag >> 1, (JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 2]) << 8) + JavaUnsignedUtil.asU8(data[in_offset + triplet_index + 3]));
            }
            triplet_index += n_data_bytes;
            result[i] = new Woff2Common.Point(x += dx, y += dy, on_curve);
        }
        return triplet_index;
    }

    private static int storePoints(int n_points, Woff2Common.Point[] points, int n_contours, int instruction_length, byte[] dst, int dst_size) {
        int xy_bytes;
        int flag_offset = 10 + 2 * n_contours + 2 + instruction_length;
        int last_flag = -1;
        int repeat_count = 0;
        int last_x = 0;
        int last_y = 0;
        int x_bytes = 0;
        int y_bytes = 0;
        for (int i = 0; i < n_points; ++i) {
            Woff2Common.Point point = points[i];
            int flag = point.on_curve ? 1 : 0;
            int dx = point.x - last_x;
            int dy = point.y - last_y;
            if (dx == 0) {
                flag |= 0x10;
            } else if (dx > -256 && dx < 256) {
                flag |= 2 | (dx > 0 ? 16 : 0);
                ++x_bytes;
            } else {
                x_bytes += 2;
            }
            if (dy == 0) {
                flag |= 0x20;
            } else if (dy > -256 && dy < 256) {
                flag |= 4 | (dy > 0 ? 32 : 0);
                ++y_bytes;
            } else {
                y_bytes += 2;
            }
            if (flag == last_flag && repeat_count != 255) {
                int n = flag_offset - 1;
                dst[n] = (byte)(dst[n] | 8);
                ++repeat_count;
            } else {
                if (repeat_count != 0) {
                    if (flag_offset >= dst_size) {
                        throw new FontCompressionException("Reconstructing woff2 glyph's point exception");
                    }
                    dst[flag_offset++] = (byte)repeat_count;
                }
                if (flag_offset >= dst_size) {
                    throw new FontCompressionException("Reconstructing woff2 glyph's point exception");
                }
                dst[flag_offset++] = (byte)flag;
                repeat_count = 0;
            }
            last_x = point.x;
            last_y = point.y;
            last_flag = flag;
        }
        if (repeat_count != 0) {
            if (flag_offset >= dst_size) {
                throw new FontCompressionException("Reconstructing woff2 glyph's point exception");
            }
            dst[flag_offset++] = (byte)repeat_count;
        }
        if ((xy_bytes = x_bytes + y_bytes) < x_bytes || flag_offset + xy_bytes < flag_offset || flag_offset + xy_bytes > dst_size) {
            throw new FontCompressionException("Reconstructing woff2 glyph's point exception");
        }
        int x_offset = flag_offset;
        int y_offset = flag_offset + x_bytes;
        last_x = 0;
        last_y = 0;
        for (int i = 0; i < n_points; ++i) {
            int dx = points[i].x - last_x;
            if (dx != 0) {
                if (dx > -256 && dx < 256) {
                    dst[x_offset++] = (byte)Math.abs(dx);
                } else {
                    x_offset = StoreBytes.storeU16(dst, x_offset, dx);
                }
            }
            last_x += dx;
            int dy = points[i].y - last_y;
            if (dy != 0) {
                if (dy > -256 && dy < 256) {
                    dst[y_offset++] = (byte)Math.abs(dy);
                } else {
                    y_offset = StoreBytes.storeU16(dst, y_offset, dy);
                }
            }
            last_y += dy;
        }
        int glyph_size = y_offset;
        return glyph_size;
    }

    private static void computeBbox(int n_points, Woff2Common.Point[] points, byte[] dst) {
        int x_min = 0;
        int y_min = 0;
        int x_max = 0;
        int y_max = 0;
        if (n_points > 0) {
            x_min = points[0].x;
            x_max = points[0].x;
            y_min = points[0].y;
            y_max = points[0].y;
        }
        for (int i = 1; i < n_points; ++i) {
            int x = points[i].x;
            int y = points[i].y;
            x_min = Math.min(x, x_min);
            x_max = Math.max(x, x_max);
            y_min = Math.min(y, y_min);
            y_max = Math.max(y, y_max);
        }
        int offset = 2;
        offset = StoreBytes.storeU16(dst, offset, x_min);
        offset = StoreBytes.storeU16(dst, offset, y_min);
        offset = StoreBytes.storeU16(dst, offset, x_max);
        offset = StoreBytes.storeU16(dst, offset, y_max);
    }

    private static CompositeGlyphInfo sizeOfComposite(Buffer composite_stream) {
        composite_stream = new Buffer(composite_stream);
        int start_offset = composite_stream.getOffset();
        boolean we_have_instructions = false;
        int flags = 32;
        while ((flags & 0x20) != 0) {
            flags = JavaUnsignedUtil.asU16(composite_stream.readShort());
            we_have_instructions |= (flags & 0x100) != 0;
            int arg_size = 2;
            arg_size = (flags & 1) != 0 ? (arg_size += 4) : (arg_size += 2);
            if ((flags & 8) != 0) {
                arg_size += 2;
            } else if ((flags & 0x40) != 0) {
                arg_size += 4;
            } else if ((flags & 0x80) != 0) {
                arg_size += 8;
            }
            composite_stream.skip(arg_size);
        }
        int size = composite_stream.getOffset() - start_offset;
        boolean have_instructions = we_have_instructions;
        return new CompositeGlyphInfo(size, have_instructions);
    }

    private static void pad4(Woff2Out out) {
        byte[] zeroes = new byte[]{0, 0, 0};
        if (out.size() + 3 < out.size()) {
            throw new FontCompressionException("woff2 padding overflow exception");
        }
        int pad_bytes = Round.round4(out.size()) - out.size();
        if (pad_bytes > 0) {
            out.write(zeroes, 0, pad_bytes);
        }
    }

    private static int storeLoca(int[] loca_values, int index_format, Woff2Out out) {
        long offset_size;
        long loca_size = loca_values.length;
        long l = offset_size = index_format != 0 ? 4L : 2L;
        if (loca_size << 2 >> 2 != loca_size) {
            throw new FontCompressionException("woff2 loca table content size overflow exception");
        }
        byte[] loca_content = new byte[(int)(loca_size * offset_size)];
        int offset = 0;
        for (int i = 0; i < loca_values.length; ++i) {
            int value = loca_values[i];
            offset = index_format != 0 ? StoreBytes.storeU32(loca_content, offset, value) : StoreBytes.storeU16(loca_content, offset, value >> 1);
        }
        int checksum = Woff2Common.computeULongSum(loca_content, 0, loca_content.length);
        out.write(loca_content, 0, loca_content.length);
        return checksum;
    }

    private static Checksums reconstructGlyf(byte[] data, int data_offset, Woff2Common.Table glyf_table, int glyph_checksum, Woff2Common.Table loca_table, int loca_checksum, Woff2FontInfo info, Woff2Out out) {
        int kNumSubStreams = 7;
        Buffer file = new Buffer(data, data_offset, glyf_table.transform_length);
        ArrayList<StreamInfo> substreams = new ArrayList<StreamInfo>(7);
        int glyf_start = out.size();
        int version = file.readInt();
        info.num_glyphs = file.readShort();
        info.index_format = file.readShort();
        int offset = 36;
        if (offset > glyf_table.transform_length) {
            throw new FontCompressionException("Reconstructing woff2 glyf table exception");
        }
        for (int i = 0; i < 7; ++i) {
            int substream_size = file.readInt();
            if (substream_size > glyf_table.transform_length - offset) {
                throw new FontCompressionException("Reconstructing woff2 glyf table exception");
            }
            substreams.add(new StreamInfo(data_offset + offset, substream_size));
            offset += substream_size;
        }
        Buffer n_contour_stream = new Buffer(data, ((StreamInfo)substreams.get((int)0)).offset, ((StreamInfo)substreams.get((int)0)).length);
        Buffer n_points_stream = new Buffer(data, ((StreamInfo)substreams.get((int)1)).offset, ((StreamInfo)substreams.get((int)1)).length);
        Buffer flag_stream = new Buffer(data, ((StreamInfo)substreams.get((int)2)).offset, ((StreamInfo)substreams.get((int)2)).length);
        Buffer glyph_stream = new Buffer(data, ((StreamInfo)substreams.get((int)3)).offset, ((StreamInfo)substreams.get((int)3)).length);
        Buffer composite_stream = new Buffer(data, ((StreamInfo)substreams.get((int)4)).offset, ((StreamInfo)substreams.get((int)4)).length);
        Buffer bbox_stream = new Buffer(data, ((StreamInfo)substreams.get((int)5)).offset, ((StreamInfo)substreams.get((int)5)).length);
        Buffer instruction_stream = new Buffer(data, ((StreamInfo)substreams.get((int)6)).offset, ((StreamInfo)substreams.get((int)6)).length);
        int[] loca_values = new int[JavaUnsignedUtil.asU16(info.num_glyphs) + 1];
        ArrayList<Integer> n_points_vec = new ArrayList<Integer>();
        Woff2Common.Point[] points = new Woff2Common.Point[]{};
        int points_size = 0;
        int bbox_bitmap_offset = bbox_stream.getInitialOffset();
        int bitmap_length = JavaUnsignedUtil.asU16(info.num_glyphs) + 31 >> 5 << 2;
        bbox_stream.skip(bitmap_length);
        int glyph_buf_size = 5120;
        byte[] glyph_buf = new byte[glyph_buf_size];
        info.x_mins = new short[JavaUnsignedUtil.asU16(info.num_glyphs)];
        for (int i = 0; i < JavaUnsignedUtil.asU16(info.num_glyphs); ++i) {
            int glyph_size = 0;
            int n_contours = 0;
            boolean have_bbox = false;
            byte[] bitmap = new byte[bitmap_length];
            System.arraycopy(data, bbox_bitmap_offset, bitmap, 0, bitmap_length);
            if ((data[bbox_bitmap_offset + (i >> 3)] & 128 >> (i & 7)) != 0) {
                have_bbox = true;
            }
            if ((n_contours = JavaUnsignedUtil.asU16(n_contour_stream.readShort())) == 65535) {
                int size_needed;
                boolean have_instructions = false;
                int instruction_size = 0;
                if (!have_bbox) {
                    throw new FontCompressionException("Reconstructing woff2 glyf table exception");
                }
                CompositeGlyphInfo compositeGlyphInfo = Woff2Dec.sizeOfComposite(composite_stream);
                have_instructions = compositeGlyphInfo.have_instructions;
                int composite_size = compositeGlyphInfo.size;
                if (have_instructions) {
                    instruction_size = VariableLength.read255UShort(glyph_stream);
                }
                if (glyph_buf_size < (size_needed = 12 + composite_size + instruction_size)) {
                    glyph_buf = new byte[size_needed];
                    glyph_buf_size = size_needed;
                }
                glyph_size = StoreBytes.storeU16(glyph_buf, glyph_size, n_contours);
                bbox_stream.read(glyph_buf, glyph_size, 8);
                composite_stream.read(glyph_buf, glyph_size += 8, composite_size);
                glyph_size += composite_size;
                if (have_instructions) {
                    glyph_size = StoreBytes.storeU16(glyph_buf, glyph_size, instruction_size);
                    instruction_stream.read(glyph_buf, glyph_size, instruction_size);
                    glyph_size += instruction_size;
                }
            } else if (n_contours > 0) {
                n_points_vec.clear();
                int total_n_points = 0;
                for (int j = 0; j < n_contours; ++j) {
                    int n_points_contour = VariableLength.read255UShort(n_points_stream);
                    n_points_vec.add(n_points_contour);
                    if (total_n_points + n_points_contour < total_n_points) {
                        throw new FontCompressionException("Reconstructing woff2 glyf table exception");
                    }
                    total_n_points += n_points_contour;
                }
                int flag_size = total_n_points;
                if (flag_size > flag_stream.getLength() - flag_stream.getOffset()) {
                    throw new FontCompressionException("Reconstructing woff2 glyf table exception");
                }
                int flags_buf_offset = flag_stream.getInitialOffset() + flag_stream.getOffset();
                int triplet_buf_offset = glyph_stream.getInitialOffset() + glyph_stream.getOffset();
                int triplet_size = glyph_stream.getLength() - glyph_stream.getOffset();
                int triplet_bytes_consumed = 0;
                if (points_size < total_n_points) {
                    points_size = total_n_points;
                    points = new Woff2Common.Point[points_size];
                }
                triplet_bytes_consumed = Woff2Dec.tripletDecode(data, flags_buf_offset, triplet_buf_offset, triplet_size, total_n_points, points);
                flag_stream.skip(flag_size);
                glyph_stream.skip(triplet_bytes_consumed);
                int instruction_size = VariableLength.read255UShort(glyph_stream);
                if (total_n_points >= 0x8000000 || instruction_size >= 0x40000000) {
                    throw new FontCompressionException("Reconstructing woff2 glyf table exception");
                }
                int size_needed = 12 + 2 * n_contours + 5 * total_n_points + instruction_size;
                if (glyph_buf_size < size_needed) {
                    glyph_buf = new byte[size_needed];
                    glyph_buf_size = size_needed;
                }
                glyph_size = StoreBytes.storeU16(glyph_buf, glyph_size, n_contours);
                if (have_bbox) {
                    bbox_stream.read(glyph_buf, glyph_size, 8);
                } else {
                    Woff2Dec.computeBbox(total_n_points, points, glyph_buf);
                }
                glyph_size = 10;
                int end_point = -1;
                for (int contour_ix = 0; contour_ix < n_contours; ++contour_ix) {
                    if ((end_point += ((Integer)n_points_vec.get(contour_ix)).intValue()) >= 65536) {
                        throw new FontCompressionException("Reconstructing woff2 glyf table exception");
                    }
                    glyph_size = StoreBytes.storeU16(glyph_buf, glyph_size, end_point);
                }
                glyph_size = StoreBytes.storeU16(glyph_buf, glyph_size, instruction_size);
                instruction_stream.read(glyph_buf, glyph_size, instruction_size);
                glyph_size += instruction_size;
                glyph_size = Woff2Dec.storePoints(total_n_points, points, n_contours, instruction_size, glyph_buf, glyph_buf_size);
            }
            loca_values[i] = out.size() - glyf_start;
            out.write(glyph_buf, 0, glyph_size);
            Woff2Dec.pad4(out);
            glyph_checksum += Woff2Common.computeULongSum(glyph_buf, 0, glyph_size);
            if (n_contours <= 0) continue;
            Buffer x_min_buf = new Buffer(glyph_buf, 2, 2);
            info.x_mins[i] = x_min_buf.readShort();
        }
        glyf_table.dst_length = out.size() - glyf_table.dst_offset;
        loca_table.dst_offset = out.size();
        loca_values[JavaUnsignedUtil.asU16((short)info.num_glyphs)] = glyf_table.dst_length;
        loca_checksum = Woff2Dec.storeLoca(loca_values, info.index_format, out);
        loca_table.dst_length = out.size() - loca_table.dst_offset;
        return new Checksums(loca_checksum, glyph_checksum);
    }

    private static Woff2Common.Table findTable(ArrayList<Woff2Common.Table> tables, int tag) {
        for (Woff2Common.Table table : tables) {
            if (table.tag != tag) continue;
            return table;
        }
        return null;
    }

    private static short readNumHMetrics(byte[] data, int offset, int data_length) {
        Buffer buffer = new Buffer(data, offset, data_length);
        buffer.skip(34);
        short result = buffer.readShort();
        return result;
    }

    private static int reconstructTransformedHmtx(byte[] transformed_buf, int transformed_offset, int transformed_size, int num_glyphs, int num_hmetrics, short[] x_mins, Woff2Out out) {
        short lsb;
        int i;
        boolean has_monospace_lsbs;
        Buffer hmtx_buff_in = new Buffer(transformed_buf, transformed_offset, transformed_size);
        int hmtx_flags = JavaUnsignedUtil.asU8(hmtx_buff_in.readByte());
        boolean has_proportional_lsbs = (hmtx_flags & 1) == 0;
        boolean bl = has_monospace_lsbs = (hmtx_flags & 2) == 0;
        if (has_proportional_lsbs && has_monospace_lsbs) {
            throw new FontCompressionException("Reconstructing woff2 hmtx table exception");
        }
        if (x_mins == null || x_mins.length != num_glyphs) {
            throw new FontCompressionException("Reconstructing woff2 hmtx table exception");
        }
        if (num_hmetrics > num_glyphs) {
            throw new FontCompressionException("Reconstructing woff2 hmtx table exception");
        }
        if (num_hmetrics < 1) {
            throw new FontCompressionException("Reconstructing woff2 hmtx table exception");
        }
        short[] advance_widths = new short[num_hmetrics];
        for (i = 0; i < num_hmetrics; ++i) {
            short advance_width;
            advance_widths[i] = advance_width = hmtx_buff_in.readShort();
        }
        short[] lsbs = new short[num_glyphs];
        for (i = 0; i < num_hmetrics; ++i) {
            lsb = has_proportional_lsbs ? hmtx_buff_in.readShort() : x_mins[i];
            lsbs[i] = lsb;
        }
        for (i = num_hmetrics; i < num_glyphs; ++i) {
            lsb = has_monospace_lsbs ? hmtx_buff_in.readShort() : x_mins[i];
            lsbs[i] = lsb;
        }
        int hmtx_output_size = 2 * num_glyphs + 2 * num_hmetrics;
        byte[] hmtx_table = new byte[hmtx_output_size];
        int dst_offset = 0;
        for (int i2 = 0; i2 < num_glyphs; ++i2) {
            if (i2 < num_hmetrics) {
                dst_offset = StoreBytes.storeU16(hmtx_table, dst_offset, advance_widths[i2]);
            }
            dst_offset = StoreBytes.storeU16(hmtx_table, dst_offset, lsbs[i2]);
        }
        int checksum = Woff2Common.computeULongSum(hmtx_table, 0, hmtx_output_size);
        out.write(hmtx_table, 0, hmtx_output_size);
        return checksum;
    }

    private static void woff2Uncompress(byte[] dst_buf, int dst_offset, int dst_length, byte[] src_buf, int src_offset, int src_length) {
        int remain;
        try {
            int read;
            BrotliInputStream stream = new BrotliInputStream(new ByteArrayInputStream(src_buf, src_offset, src_length));
            for (remain = dst_length; remain > 0; remain -= read) {
                read = stream.read(dst_buf, dst_offset, dst_length);
                if (read >= 0) continue;
                throw new FontCompressionException("Woff2 brotli decoding exception");
            }
            if (stream.read() != -1) {
                throw new FontCompressionException("Woff2 brotli decoding exception");
            }
        }
        catch (IOException any) {
            throw new FontCompressionException("Woff2 brotli decoding exception");
        }
        if (remain != 0) {
            throw new FontCompressionException("Woff2 brotli decoding exception");
        }
    }

    private static void readTableDirectory(Buffer file, Woff2Common.Table[] tables, int num_tables) {
        int src_offset = 0;
        for (int i = 0; i < num_tables; ++i) {
            int dst_length;
            Woff2Common.Table table;
            tables[i] = table = new Woff2Common.Table();
            int flag_byte = JavaUnsignedUtil.asU8(file.readByte());
            int tag = (flag_byte & 0x3F) == 63 ? file.readInt() : TableTags.kKnownTags[flag_byte & 0x3F];
            int flags = 0;
            int xform_version = flag_byte >> 6 & 3;
            if (tag == 1735162214 || tag == 1819239265) {
                if (xform_version == 0) {
                    flags |= 0x100;
                }
            } else if (xform_version != 0) {
                flags |= 0x100;
            }
            int transform_length = dst_length = VariableLength.readBase128(file);
            if (((flags |= xform_version) & 0x100) != 0) {
                transform_length = VariableLength.readBase128(file);
                if (tag == 1819239265 && transform_length != 0) {
                    throw new FontCompressionException("Reading woff2 tables directory exception");
                }
            }
            if (src_offset + transform_length < src_offset) {
                throw new FontCompressionException("Reading woff2 tables directory exception");
            }
            table.src_offset = src_offset;
            table.src_length = transform_length;
            src_offset += transform_length;
            table.tag = tag;
            table.flags = flags;
            table.transform_length = transform_length;
            table.dst_length = dst_length;
        }
    }

    private static int storeOffsetTable(byte[] result, int offset, int flavor, int num_tables) {
        offset = StoreBytes.storeU32(result, offset, flavor);
        offset = StoreBytes.storeU16(result, offset, num_tables);
        int max_pow2 = 0;
        while (1 << max_pow2 + 1 <= num_tables) {
            ++max_pow2;
        }
        int output_search_range = 1 << max_pow2 << 4;
        offset = StoreBytes.storeU16(result, offset, output_search_range);
        offset = StoreBytes.storeU16(result, offset, max_pow2);
        offset = StoreBytes.storeU16(result, offset, (num_tables << 4) - output_search_range);
        return offset;
    }

    private static int storeTableEntry(byte[] result, int offset, int tag) {
        offset = StoreBytes.storeU32(result, offset, tag);
        offset = StoreBytes.storeU32(result, offset, 0);
        offset = StoreBytes.storeU32(result, offset, 0);
        offset = StoreBytes.storeU32(result, offset, 0);
        return offset;
    }

    private static long computeOffsetToFirstTable(Woff2Header hdr) {
        long offset = 12 + 16 * hdr.num_tables;
        if (hdr.header_version != 0) {
            offset = Woff2Common.collectionHeaderSize(hdr.header_version, hdr.ttc_fonts.length) + 12 * hdr.ttc_fonts.length;
            for (TtcFont ttc_font : hdr.ttc_fonts) {
                offset += (long)(16 * ttc_font.table_indices.length);
            }
        }
        return offset;
    }

    private static ArrayList<Woff2Common.Table> tables(Woff2Header hdr, int font_index) {
        ArrayList<Woff2Common.Table> tables = new ArrayList<Woff2Common.Table>();
        if (hdr.header_version != 0) {
            for (short index : hdr.ttc_fonts[font_index].table_indices) {
                tables.add(hdr.tables[JavaUnsignedUtil.asU16(index)]);
            }
        } else {
            for (Woff2Common.Table table : hdr.tables) {
                tables.add(table);
            }
        }
        return tables;
    }

    private static void reconstructFont(byte[] transformed_buf, int transformed_buf_offset, int transformed_buf_size, RebuildMetadata metadata, Woff2Header hdr, int font_index, Woff2Out out) {
        int dest_offset = out.size();
        byte[] table_entry = new byte[12];
        Woff2FontInfo info = metadata.font_infos[font_index];
        ArrayList<Woff2Common.Table> tables = Woff2Dec.tables(hdr, font_index);
        if (Woff2Dec.findTable(tables, 1735162214) != null != (Woff2Dec.findTable(tables, 1819239265) != null)) {
            throw new FontCompressionException("Reconstructing woff2 table directory exception");
        }
        int font_checksum = metadata.header_checksum;
        if (hdr.header_version != 0) {
            font_checksum = hdr.ttc_fonts[font_index].header_checksum;
        }
        int loca_checksum = 0;
        for (int i = 0; i < tables.size(); ++i) {
            Woff2Common.Table table = tables.get(i);
            TableChecksumInfo checksum_key = new TableChecksumInfo(table.tag, table.src_offset);
            boolean reused = metadata.checksums.containsKey(checksum_key);
            if (font_index == 0 && reused) {
                throw new FontCompressionException("Reconstructing woff2 table directory exception");
            }
            if ((long)table.src_offset + (long)table.src_length > (long)transformed_buf_size) {
                throw new FontCompressionException("Reconstructing woff2 table directory exception");
            }
            if (table.tag == 1751672161) {
                info.num_hmetrics = Woff2Dec.readNumHMetrics(transformed_buf, transformed_buf_offset + table.src_offset, table.src_length);
            }
            int checksum = 0;
            if (!reused) {
                if ((table.flags & 0x100) != 256) {
                    if (table.tag == 1751474532) {
                        if (table.src_length < 12) {
                            throw new FontCompressionException("Reconstructing woff2 table directory exception");
                        }
                        StoreBytes.storeU32(transformed_buf, transformed_buf_offset + table.src_offset + 8, 0);
                    }
                    table.dst_offset = dest_offset;
                    checksum = Woff2Common.computeULongSum(transformed_buf, transformed_buf_offset + table.src_offset, table.src_length);
                    out.write(transformed_buf, transformed_buf_offset + table.src_offset, table.src_length);
                } else if (table.tag == 1735162214) {
                    table.dst_offset = dest_offset;
                    Woff2Common.Table loca_table = Woff2Dec.findTable(tables, 1819239265);
                    Checksums resultChecksum = Woff2Dec.reconstructGlyf(transformed_buf, transformed_buf_offset + table.src_offset, table, checksum, loca_table, loca_checksum, info, out);
                    checksum = resultChecksum.glyph_checksum;
                    loca_checksum = resultChecksum.loca_checksum;
                } else if (table.tag == 1819239265) {
                    checksum = loca_checksum;
                } else if (table.tag == 1752003704) {
                    table.dst_offset = dest_offset;
                    checksum = Woff2Dec.reconstructTransformedHmtx(transformed_buf, transformed_buf_offset + table.src_offset, table.src_length, JavaUnsignedUtil.asU16(info.num_glyphs), JavaUnsignedUtil.asU16(info.num_hmetrics), info.x_mins, out);
                } else {
                    throw new FontCompressionException("Reconstructing woff2 table directory exception");
                }
                metadata.checksums.put(checksum_key, checksum);
            } else {
                checksum = metadata.checksums.get(checksum_key);
            }
            font_checksum += checksum;
            StoreBytes.storeU32(table_entry, 0, checksum);
            StoreBytes.storeU32(table_entry, 4, table.dst_offset);
            StoreBytes.storeU32(table_entry, 8, table.dst_length);
            out.write(table_entry, 0, info.table_entry_by_tag.get(table.tag) + 4, 12);
            font_checksum += Woff2Common.computeULongSum(table_entry, 0, 12);
            Woff2Dec.pad4(out);
            if ((long)table.dst_offset + (long)table.dst_length > (long)out.size()) {
                throw new FontCompressionException("Reconstructing woff2 table directory exception");
            }
            dest_offset = out.size();
        }
        Woff2Common.Table head_table = Woff2Dec.findTable(tables, 1751474532);
        if (head_table != null) {
            if (head_table.dst_length < 12) {
                throw new FontCompressionException("Reconstructing woff2 table directory exception");
            }
            byte[] checksum_adjustment = new byte[4];
            StoreBytes.storeU32(checksum_adjustment, 0, -1313820742 - font_checksum);
            out.write(checksum_adjustment, 0, head_table.dst_offset + 8, 4);
        }
    }

    private static void readWoff2Header(byte[] data, int length, Woff2Header hdr) {
        Buffer file = new Buffer(data, 0, length);
        int signature = file.readInt();
        if (signature != 2001684018) {
            throw new FontCompressionException("Incorrect woff2 signature");
        }
        hdr.flavor = file.readInt();
        int reported_length = file.readInt();
        assert (reported_length > 0);
        if (length != reported_length) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        hdr.num_tables = file.readShort();
        if (hdr.num_tables == 0) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        file.skip(6);
        hdr.compressed_length = file.readInt();
        assert (hdr.compressed_length >= 0);
        file.skip(4);
        int meta_offset = file.readInt();
        assert (meta_offset >= 0);
        int meta_length = file.readInt();
        assert (meta_length >= 0);
        int meta_length_orig = file.readInt();
        assert (meta_length_orig >= 0);
        if (meta_offset != 0 && (meta_offset >= length || length - meta_offset < meta_length)) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        int priv_offset = file.readInt();
        assert (priv_offset >= 0);
        int priv_length = file.readInt();
        assert (priv_length >= 0);
        if (priv_offset != 0 && (priv_offset >= length || length - priv_offset < priv_length)) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        hdr.tables = new Woff2Common.Table[hdr.num_tables];
        Woff2Dec.readTableDirectory(file, hdr.tables, hdr.num_tables);
        Woff2Common.Table last_table = hdr.tables[hdr.tables.length - 1];
        hdr.uncompressed_size = last_table.src_offset + last_table.src_length;
        assert (hdr.uncompressed_size > 0);
        if (hdr.uncompressed_size < last_table.src_offset) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        hdr.header_version = 0;
        if (hdr.flavor == 1953784678) {
            hdr.header_version = file.readInt();
            if (hdr.header_version != 65536 && hdr.header_version != 131072) {
                throw new FontCompressionException("Reading collection woff2 header exception");
            }
            int num_fonts = VariableLength.read255UShort(file);
            hdr.ttc_fonts = new TtcFont[num_fonts];
            for (int i = 0; i < num_fonts; ++i) {
                TtcFont ttc_font;
                hdr.ttc_fonts[i] = ttc_font = new TtcFont();
                int num_tables = VariableLength.read255UShort(file);
                ttc_font.flavor = file.readInt();
                ttc_font.table_indices = new short[num_tables];
                Woff2Common.Table glyf_table = null;
                Woff2Common.Table loca_table = null;
                for (int j = 0; j < num_tables; ++j) {
                    int table_idx = VariableLength.read255UShort(file);
                    if (table_idx >= hdr.tables.length) {
                        throw new FontCompressionException("Reading collection woff2 header exception");
                    }
                    ttc_font.table_indices[j] = (short)table_idx;
                    Woff2Common.Table table = hdr.tables[table_idx];
                    if (table.tag == 1819239265) {
                        loca_table = table;
                    }
                    if (table.tag != 1735162214) continue;
                    glyf_table = table;
                }
                if (glyf_table == null == (loca_table == null)) continue;
                throw new FontCompressionException("Reading collection woff2 header exception");
            }
        }
        long first_table_offset = Woff2Dec.computeOffsetToFirstTable(hdr);
        hdr.compressed_offset = file.getOffset();
        if (hdr.compressed_offset > Integer.MAX_VALUE) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        long src_offset = Round.round4(hdr.compressed_offset + (long)hdr.compressed_length);
        long dst_offset = first_table_offset;
        if (src_offset > (long)length) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
        if (meta_offset != 0) {
            if (src_offset != (long)meta_offset) {
                throw new FontCompressionException("Reading woff2 header exception");
            }
            src_offset = Round.round4(meta_offset + meta_length);
            if (src_offset > Integer.MAX_VALUE) {
                throw new FontCompressionException("Reading woff2 header exception");
            }
        }
        if (priv_offset != 0) {
            if (src_offset != (long)priv_offset) {
                throw new FontCompressionException("Reading woff2 header exception");
            }
            src_offset = Round.round4(priv_offset + priv_length);
            if (src_offset > Integer.MAX_VALUE) {
                throw new FontCompressionException("Reading woff2 header exception");
            }
        }
        if (src_offset != (long)Round.round4(length)) {
            throw new FontCompressionException("Reading woff2 header exception");
        }
    }

    private static void writeHeaders(byte[] data, int length, RebuildMetadata metadata, Woff2Header hdr, Woff2Out out) {
        long firstTableOffset = Woff2Dec.computeOffsetToFirstTable(hdr);
        assert (firstTableOffset <= Integer.MAX_VALUE);
        byte[] output = new byte[(int)firstTableOffset];
        List<Woff2Common.Table> sorted_tables = Arrays.asList(hdr.tables);
        if (hdr.header_version != 0) {
            for (TtcFont ttc_font : hdr.ttc_fonts) {
                TreeMap<Integer, Short> sorted_index_by_tag = new TreeMap<Integer, Short>();
                short[] sArray = ttc_font.table_indices;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    short table_index = sArray[i];
                    sorted_index_by_tag.put(hdr.tables[table_index].tag, table_index);
                }
                int index = 0;
                for (Map.Entry i : sorted_index_by_tag.entrySet()) {
                    int n2 = index;
                    index = (short)(index + 1);
                    ttc_font.table_indices[n2] = (Short)i.getValue();
                }
            }
        } else {
            Collections.sort(sorted_tables);
        }
        byte[] result = output;
        int offset = 0;
        if (hdr.header_version != 0) {
            int i;
            offset = StoreBytes.storeU32(result, offset, hdr.flavor);
            offset = StoreBytes.storeU32(result, offset, hdr.header_version);
            int offset_table = offset = StoreBytes.storeU32(result, offset, hdr.ttc_fonts.length);
            for (i = 0; i < hdr.ttc_fonts.length; ++i) {
                offset = StoreBytes.storeU32(result, offset, 0);
            }
            if (hdr.header_version == 131072) {
                offset = StoreBytes.storeU32(result, offset, 0);
                offset = StoreBytes.storeU32(result, offset, 0);
                offset = StoreBytes.storeU32(result, offset, 0);
            }
            metadata.font_infos = new Woff2FontInfo[hdr.ttc_fonts.length];
            for (i = 0; i < hdr.ttc_fonts.length; ++i) {
                TtcFont ttc_font = hdr.ttc_fonts[i];
                offset_table = StoreBytes.storeU32(result, offset_table, offset);
                ttc_font.dst_offset = offset;
                offset = Woff2Dec.storeOffsetTable(result, offset, ttc_font.flavor, ttc_font.table_indices.length);
                metadata.font_infos[i] = new Woff2FontInfo();
                for (short table_index : ttc_font.table_indices) {
                    int tag = hdr.tables[table_index].tag;
                    metadata.font_infos[i].table_entry_by_tag.put(tag, offset);
                    offset = Woff2Dec.storeTableEntry(result, offset, tag);
                }
                ttc_font.header_checksum = Woff2Common.computeULongSum(output, ttc_font.dst_offset, offset - ttc_font.dst_offset);
            }
        } else {
            metadata.font_infos = new Woff2FontInfo[1];
            offset = Woff2Dec.storeOffsetTable(result, offset, hdr.flavor, hdr.num_tables);
            metadata.font_infos[0] = new Woff2FontInfo();
            for (int i = 0; i < hdr.num_tables; ++i) {
                metadata.font_infos[0].table_entry_by_tag.put(sorted_tables.get((int)i).tag, offset);
                offset = Woff2Dec.storeTableEntry(result, offset, sorted_tables.get((int)i).tag);
            }
        }
        out.write(output, 0, output.length);
        metadata.header_checksum = Woff2Common.computeULongSum(output, 0, output.length);
    }

    public static int computeWoff2FinalSize(byte[] data, int length) {
        Buffer file = new Buffer(data, 0, length);
        file.skip(16);
        return file.readInt();
    }

    public static void convertWoff2ToTtf(byte[] data, int length, Woff2Out out) {
        RebuildMetadata metadata = new RebuildMetadata();
        Woff2Header hdr = new Woff2Header();
        Woff2Dec.readWoff2Header(data, length, hdr);
        Woff2Dec.writeHeaders(data, length, metadata, hdr, out);
        float compression_ratio = (float)hdr.uncompressed_size / (float)length;
        if (compression_ratio > 100.0f) {
            throw new FontCompressionException(MessageFormatUtil.format("Implausible compression ratio {0}", Float.valueOf(compression_ratio)));
        }
        byte[] uncompressed_buf = new byte[hdr.uncompressed_size];
        Woff2Dec.woff2Uncompress(uncompressed_buf, 0, hdr.uncompressed_size, data, (int)hdr.compressed_offset, hdr.compressed_length);
        for (int i = 0; i < metadata.font_infos.length; ++i) {
            Woff2Dec.reconstructFont(uncompressed_buf, 0, hdr.uncompressed_size, metadata, hdr, i, out);
        }
    }

    private static class StreamInfo {
        public int offset;
        public int length;

        public StreamInfo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }

    private static class Checksums {
        public int loca_checksum;
        public int glyph_checksum;

        public Checksums(int loca_checksum, int glyph_checksum) {
            this.loca_checksum = loca_checksum;
            this.glyph_checksum = glyph_checksum;
        }
    }

    private static class CompositeGlyphInfo {
        public int size;
        public boolean have_instructions;

        public CompositeGlyphInfo(int size, boolean have_instructions) {
            this.size = size;
            this.have_instructions = have_instructions;
        }
    }

    private static class TableChecksumInfo {
        public int tag;
        public int offset;

        public TableChecksumInfo(int tag, int offset) {
            this.tag = tag;
            this.offset = offset;
        }

        public int hashCode() {
            return new Integer(this.tag).hashCode() * 13 + new Integer(this.offset).hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TableChecksumInfo) {
                TableChecksumInfo info = (TableChecksumInfo)o;
                return this.tag == info.tag && this.offset == info.offset;
            }
            return false;
        }
    }

    private static class RebuildMetadata {
        int header_checksum;
        Woff2FontInfo[] font_infos;
        Map<TableChecksumInfo, Integer> checksums = new HashMap<TableChecksumInfo, Integer>();

        private RebuildMetadata() {
        }
    }

    private static class Woff2FontInfo {
        public short num_glyphs;
        public short index_format;
        public short num_hmetrics;
        public short[] x_mins;
        public Map<Integer, Integer> table_entry_by_tag = new HashMap<Integer, Integer>();

        private Woff2FontInfo() {
        }
    }

    private static class Woff2Header {
        public int flavor;
        public int header_version;
        public short num_tables;
        public long compressed_offset;
        public int compressed_length;
        public int uncompressed_size;
        public Woff2Common.Table[] tables;
        public TtcFont[] ttc_fonts;

        private Woff2Header() {
        }
    }

    private static class TtcFont {
        public int flavor;
        public int dst_offset;
        public int header_checksum;
        public short[] table_indices;

        private TtcFont() {
        }
    }
}

