/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.font.cmap.CMapObject;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AbstractCMap
implements Serializable {
    private static final long serialVersionUID = -9057458889624600915L;
    private String cmapName;
    private String registry;
    private String ordering;
    private int supplement;

    public String getName() {
        return this.cmapName;
    }

    void setName(String cmapName) {
        this.cmapName = cmapName;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String registry) {
        this.registry = registry;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    abstract void addChar(String var1, CMapObject var2);

    void addCodeSpaceRange(byte[] low, byte[] high) {
    }

    void addRange(String from, String to, CMapObject code) {
        byte[] a2;
        byte[] a1 = AbstractCMap.decodeStringToByte(from);
        if (a1.length != (a2 = AbstractCMap.decodeStringToByte(to)).length || a1.length == 0) {
            throw new IllegalArgumentException("Invalid map.");
        }
        byte[] sout = null;
        if (code.isString()) {
            sout = AbstractCMap.decodeStringToByte(code.toString());
        }
        int start = AbstractCMap.byteArrayToInt(a1);
        int end = AbstractCMap.byteArrayToInt(a2);
        for (int k = start; k <= end; ++k) {
            AbstractCMap.intToByteArray(k, a1);
            String mark = PdfEncodings.convertToString(a1, null);
            if (code.isArray()) {
                ArrayList codes = (ArrayList)code.getValue();
                this.addChar(mark, (CMapObject)codes.get(k - start));
                continue;
            }
            if (code.isNumber()) {
                int nn = (Integer)code.getValue() + k - start;
                this.addChar(mark, new CMapObject(4, nn));
                continue;
            }
            if (!code.isString()) continue;
            CMapObject s1 = new CMapObject(2, sout);
            this.addChar(mark, s1);
            assert (sout != null);
            AbstractCMap.intToByteArray(AbstractCMap.byteArrayToInt(sout) + 1, sout);
        }
    }

    public static byte[] decodeStringToByte(String range) {
        byte[] bytes = new byte[range.length()];
        for (int i = 0; i < range.length(); ++i) {
            bytes[i] = (byte)range.charAt(i);
        }
        return bytes;
    }

    protected String toUnicodeString(String value, boolean isHexWriting) {
        byte[] bytes = AbstractCMap.decodeStringToByte(value);
        if (isHexWriting) {
            return PdfEncodings.convertToString(bytes, "UnicodeBigUnmarked");
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return PdfEncodings.convertToString(bytes, "UnicodeBig");
        }
        return PdfEncodings.convertToString(bytes, "PDF");
    }

    private static void intToByteArray(int n, byte[] b) {
        for (int k = b.length - 1; k >= 0; --k) {
            b[k] = (byte)n;
            n >>>= 8;
        }
    }

    private static int byteArrayToInt(byte[] b) {
        int n = 0;
        for (int k = 0; k < b.length; ++k) {
            n <<= 8;
            n |= b[k] & 0xFF;
        }
        return n;
    }
}

