/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.IOException;
import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.PngImageData;
import com.itextpdf.io.image.RawImageData;
import com.itextpdf.io.image.RawImageHelper;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.util.FilterUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

class PngImageHelper {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String gAMA = "gAMA";
    public static final String cHRM = "cHRM";
    public static final String sRGB = "sRGB";
    public static final String iCCP = "iCCP";
    private static final int TRANSFERSIZE = 4096;
    private static final int PNG_FILTER_NONE = 0;
    private static final int PNG_FILTER_SUB = 1;
    private static final int PNG_FILTER_UP = 2;
    private static final int PNG_FILTER_AVERAGE = 3;
    private static final int PNG_FILTER_PAETH = 4;
    private static final String[] intents = new String[]{"/Perceptual", "/RelativeColorimetric", "/Saturation", "/AbsoluteColorimetric"};

    PngImageHelper() {
    }

    public static void processImage(ImageData image) {
        PngParameters png;
        if (image.getOriginalType() != ImageType.PNG) {
            throw new IllegalArgumentException("PNG image expected");
        }
        InputStream pngStream = null;
        try {
            if (image.getData() == null) {
                image.loadData();
            }
            pngStream = new ByteArrayInputStream(image.getData());
            image.imageSize = image.getData().length;
            png = new PngParameters((PngImageData)image);
            PngImageHelper.processPng(pngStream, png);
        }
        catch (java.io.IOException e) {
            throw new IOException("PNG image exception.", e);
        }
        finally {
            if (pngStream != null) {
                try {
                    pngStream.close();
                }
                catch (java.io.IOException iOException) {}
            }
        }
        RawImageHelper.updateImageAttributes(png.image, png.additional);
    }

    private static void processPng(InputStream pngStream, PngParameters png) throws java.io.IOException {
        PngImageHelper.readPng(pngStream, png);
        if (png.iccProfile != null && png.iccProfile.getNumComponents() != PngImageHelper.getExpectedNumberOfColorComponents(png)) {
            LoggerFactory.getLogger(PngImageHelper.class).warn("Png image has color profile with incompatible number of color components.");
        }
        try {
            RawImageData im2;
            int bpc;
            int pal0 = 0;
            int palIdx = 0;
            png.palShades = false;
            if (png.trans != null) {
                for (int k = 0; k < png.trans.length; ++k) {
                    int n = png.trans[k] & 0xFF;
                    if (n == 0) {
                        ++pal0;
                        palIdx = k;
                    }
                    if (n == 0 || n == 255) continue;
                    png.palShades = true;
                    break;
                }
            }
            if ((png.colorType & 4) != 0) {
                png.palShades = true;
            }
            boolean bl = png.genBWMask = !png.palShades && (pal0 > 1 || png.transRedGray >= 0);
            if (!png.palShades && !png.genBWMask && pal0 == 1) {
                png.additional.put("Mask", MessageFormatUtil.format("[{0} {1}]", palIdx, palIdx));
            }
            boolean needDecode = png.interlaceMethod == 1 || png.bitDepth == 16 || (png.colorType & 4) != 0 || png.palShades || png.genBWMask;
            switch (png.colorType) {
                case 0: {
                    png.inputBands = 1;
                    break;
                }
                case 2: {
                    png.inputBands = 3;
                    break;
                }
                case 3: {
                    png.inputBands = 1;
                    break;
                }
                case 4: {
                    png.inputBands = 2;
                    break;
                }
                case 6: {
                    png.inputBands = 4;
                }
            }
            if (needDecode) {
                PngImageHelper.decodeIdat(png);
            }
            int components = png.inputBands;
            if ((png.colorType & 4) != 0) {
                --components;
            }
            if ((bpc = png.bitDepth) == 16) {
                bpc = 8;
            }
            if (png.imageData != null) {
                if (png.colorType == 3) {
                    RawImageHelper.updateRawImageParameters(png.image, png.width, png.height, components, bpc, png.imageData);
                } else {
                    RawImageHelper.updateRawImageParameters(png.image, png.width, png.height, components, bpc, png.imageData, null);
                }
            } else {
                RawImageHelper.updateRawImageParameters(png.image, png.width, png.height, components, bpc, png.idat.toByteArray());
                png.image.setDeflated(true);
                HashMap<String, Integer> decodeparms = new HashMap<String, Integer>();
                decodeparms.put("BitsPerComponent", png.bitDepth);
                decodeparms.put("Predictor", 15);
                decodeparms.put("Columns", png.width);
                decodeparms.put("Colors", png.colorType == 3 || (png.colorType & 2) == 0 ? 1 : 3);
                png.image.decodeParms = decodeparms;
            }
            if (png.additional.get("ColorSpace") == null) {
                png.additional.put("ColorSpace", PngImageHelper.getColorspace(png));
            }
            if (png.intent != null) {
                png.additional.put("Intent", png.intent);
            }
            if (png.iccProfile != null) {
                png.image.setProfile(png.iccProfile);
            }
            if (png.palShades) {
                im2 = (RawImageData)ImageDataFactory.createRawImage(null);
                RawImageHelper.updateRawImageParameters(im2, png.width, png.height, 1, 8, png.smask);
                im2.makeMask();
                png.image.setImageMask(im2);
            }
            if (png.genBWMask) {
                im2 = (RawImageData)ImageDataFactory.createRawImage(null);
                RawImageHelper.updateRawImageParameters(im2, png.width, png.height, 1, 1, png.smask);
                im2.makeMask();
                png.image.setImageMask(im2);
            }
            png.image.setDpi(png.dpiX, png.dpiY);
            png.image.setXYRatio(png.XYRatio);
        }
        catch (Exception e) {
            throw new IOException("PNG image exception.", e);
        }
    }

    private static Object getColorspace(PngParameters png) {
        if (png.iccProfile != null) {
            if ((png.colorType & 2) == 0) {
                return "/DeviceGray";
            }
            return "/DeviceRGB";
        }
        if (png.gamma == 1.0f && !png.hasCHRM) {
            if ((png.colorType & 2) == 0) {
                return "/DeviceGray";
            }
            return "/DeviceRGB";
        }
        Object[] array = new Object[2];
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ((png.colorType & 2) == 0) {
            if (png.gamma == 1.0f) {
                return "/DeviceGray";
            }
            array[0] = "/CalGray";
            map.put("Gamma", Float.valueOf(png.gamma));
            map.put("WhitePoint", new int[]{1, 1, 1});
            array[1] = map;
        } else {
            float[] wp = new float[]{1.0f, 1.0f, 1.0f};
            array[0] = "/CalRGB";
            if (png.gamma != 1.0f) {
                float[] gm = new float[]{png.gamma, png.gamma, png.gamma};
                map.put("Gamma", gm);
            }
            if (png.hasCHRM) {
                float z = png.yW * ((png.xG - png.xB) * png.yR - (png.xR - png.xB) * png.yG + (png.xR - png.xG) * png.yB);
                float YA = png.yR * ((png.xG - png.xB) * png.yW - (png.xW - png.xB) * png.yG + (png.xW - png.xG) * png.yB) / z;
                float XA = YA * png.xR / png.yR;
                float ZA = YA * ((1.0f - png.xR) / png.yR - 1.0f);
                float YB = -png.yG * ((png.xR - png.xB) * png.yW - (png.xW - png.xB) * png.yR + (png.xW - png.xR) * png.yB) / z;
                float XB = YB * png.xG / png.yG;
                float ZB = YB * ((1.0f - png.xG) / png.yG - 1.0f);
                float YC = png.yB * ((png.xR - png.xG) * png.yW - (png.xW - png.xG) * png.yW + (png.xW - png.xR) * png.yG) / z;
                float XC = YC * png.xB / png.yB;
                float ZC = YC * ((1.0f - png.xB) / png.yB - 1.0f);
                float XW = XA + XB + XC;
                float YW = 1.0f;
                float ZW = ZA + ZB + ZC;
                float[] wpa = new float[]{XW, YW, ZW};
                wp = wpa;
                float[] matrix = new float[]{XA, YA, ZA, XB, YB, ZB, XC, YC, ZC};
                map.put("Matrix", matrix);
            }
            map.put("WhitePoint", wp);
            array[1] = map;
        }
        return array;
    }

    private static int getExpectedNumberOfColorComponents(PngParameters png) {
        return (png.colorType & 2) == 0 ? 1 : 3;
    }

    private static void readPng(InputStream pngStream, PngParameters png) throws java.io.IOException {
        for (int i = 0; i < PNGID.length; ++i) {
            if (PNGID[i] == pngStream.read()) continue;
            throw new java.io.IOException("file.is.not.a.valid.png");
        }
        byte[] buffer = new byte[4096];
        while (true) {
            int len;
            String marker = PngImageHelper.getString(pngStream);
            if (len < 0 || !PngImageHelper.checkMarker(marker)) {
                throw new java.io.IOException("corrupted.png.file");
            }
            if (IDAT.equals(marker)) {
                int size;
                for (len = PngImageHelper.getInt(pngStream); len != 0; len -= size) {
                    size = pngStream.read(buffer, 0, Math.min(len, 4096));
                    if (size < 0) {
                        return;
                    }
                    png.idat.write(buffer, 0, size);
                }
            } else if (tRNS.equals(marker)) {
                switch (png.colorType) {
                    case 0: {
                        if (len < 2) break;
                        len -= 2;
                        int gray = PngImageHelper.getWord(pngStream);
                        if (png.bitDepth == 16) {
                            png.transRedGray = gray;
                            break;
                        }
                        png.additional.put("Mask", MessageFormatUtil.format("[{0} {1}]", gray, gray));
                        break;
                    }
                    case 2: {
                        if (len < 6) break;
                        len -= 6;
                        int red = PngImageHelper.getWord(pngStream);
                        int green = PngImageHelper.getWord(pngStream);
                        int blue = PngImageHelper.getWord(pngStream);
                        if (png.bitDepth == 16) {
                            png.transRedGray = red;
                            png.transGreen = green;
                            png.transBlue = blue;
                            break;
                        }
                        png.additional.put("Mask", MessageFormatUtil.format("[{0} {1} {2} {3} {4} {5}]", red, red, green, green, blue, blue));
                        break;
                    }
                    case 3: {
                        if (len <= 0) break;
                        png.trans = new byte[len];
                        for (int k = 0; k < len; ++k) {
                            png.trans[k] = (byte)pngStream.read();
                        }
                        len = 0;
                    }
                }
                StreamUtil.skip(pngStream, len);
            } else if (IHDR.equals(marker)) {
                png.width = PngImageHelper.getInt(pngStream);
                png.height = PngImageHelper.getInt(pngStream);
                png.bitDepth = pngStream.read();
                png.colorType = pngStream.read();
                png.compressionMethod = pngStream.read();
                png.filterMethod = pngStream.read();
                png.interlaceMethod = pngStream.read();
            } else if (PLTE.equals(marker)) {
                if (png.colorType == 3) {
                    Object[] colorspace = new Object[4];
                    colorspace[0] = "/Indexed";
                    colorspace[1] = PngImageHelper.getColorspace(png);
                    colorspace[2] = len / 3 - 1;
                    ByteBuffer colorTableBuf = new ByteBuffer();
                    while (len-- > 0) {
                        colorTableBuf.append(pngStream.read());
                    }
                    png.colorTable = colorTableBuf.toByteArray();
                    colorspace[3] = PdfEncodings.convertToString(png.colorTable, null);
                    png.additional.put("ColorSpace", colorspace);
                } else {
                    StreamUtil.skip(pngStream, len);
                }
            } else if (pHYs.equals(marker)) {
                int dx = PngImageHelper.getInt(pngStream);
                int dy = PngImageHelper.getInt(pngStream);
                int unit = pngStream.read();
                if (unit == 1) {
                    png.dpiX = (int)((float)dx * 0.0254f + 0.5f);
                    png.dpiY = (int)((float)dy * 0.0254f + 0.5f);
                } else if (dy != 0) {
                    png.XYRatio = (float)dx / (float)dy;
                }
            } else if (cHRM.equals(marker)) {
                png.xW = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.yW = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.xR = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.yR = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.xG = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.yG = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.xB = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.yB = (float)PngImageHelper.getInt(pngStream) / 100000.0f;
                png.hasCHRM = !(Math.abs(png.xW) < 1.0E-4f || Math.abs(png.yW) < 1.0E-4f || Math.abs(png.xR) < 1.0E-4f || Math.abs(png.yR) < 1.0E-4f || Math.abs(png.xG) < 1.0E-4f || Math.abs(png.yG) < 1.0E-4f || Math.abs(png.xB) < 1.0E-4f || Math.abs(png.yB) < 1.0E-4f);
            } else if (sRGB.equals(marker)) {
                int ri = pngStream.read();
                png.intent = intents[ri];
                png.gamma = 2.2f;
                png.xW = 0.3127f;
                png.yW = 0.329f;
                png.xR = 0.64f;
                png.yR = 0.33f;
                png.xG = 0.3f;
                png.yG = 0.6f;
                png.xB = 0.15f;
                png.yB = 0.06f;
                png.hasCHRM = true;
            } else if (gAMA.equals(marker)) {
                int gm = PngImageHelper.getInt(pngStream);
                if (gm != 0) {
                    png.gamma = 100000.0f / (float)gm;
                    if (!png.hasCHRM) {
                        png.xW = 0.3127f;
                        png.yW = 0.329f;
                        png.xR = 0.64f;
                        png.yR = 0.33f;
                        png.xG = 0.3f;
                        png.yG = 0.6f;
                        png.xB = 0.15f;
                        png.yB = 0.06f;
                        png.hasCHRM = true;
                    }
                }
            } else if (iCCP.equals(marker)) {
                do {
                    --len;
                } while (pngStream.read() != 0);
                pngStream.read();
                byte[] icccom = new byte[--len];
                int p = 0;
                while (len > 0) {
                    int r = pngStream.read(icccom, p, len);
                    if (r < 0) {
                        throw new java.io.IOException("premature.end.of.file");
                    }
                    p += r;
                    len -= r;
                }
                byte[] iccp = FilterUtil.flateDecode(icccom, true);
                icccom = null;
                try {
                    png.iccProfile = IccProfile.getInstance(iccp);
                }
                catch (RuntimeException e) {
                    png.iccProfile = null;
                }
            } else {
                if (IEND.equals(marker)) break;
                StreamUtil.skip(pngStream, len);
            }
            StreamUtil.skip(pngStream, 4L);
        }
    }

    private static boolean checkMarker(String s) {
        if (s.length() != 4) {
            return false;
        }
        for (int k = 0; k < 4; ++k) {
            char c = s.charAt(k);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static void decodeIdat(PngParameters png) {
        int nbitDepth = png.bitDepth;
        if (nbitDepth == 16) {
            nbitDepth = 8;
        }
        int size = -1;
        png.bytesPerPixel = png.bitDepth == 16 ? 2 : 1;
        switch (png.colorType) {
            case 0: {
                size = (nbitDepth * png.width + 7) / 8 * png.height;
                break;
            }
            case 2: {
                size = png.width * 3 * png.height;
                png.bytesPerPixel *= 3;
                break;
            }
            case 3: {
                if (png.interlaceMethod == 1) {
                    size = (nbitDepth * png.width + 7) / 8 * png.height;
                }
                png.bytesPerPixel = 1;
                break;
            }
            case 4: {
                size = png.width * png.height;
                png.bytesPerPixel *= 2;
                break;
            }
            case 6: {
                size = png.width * 3 * png.height;
                png.bytesPerPixel *= 4;
            }
        }
        if (size >= 0) {
            png.imageData = new byte[size];
        }
        if (png.palShades) {
            png.smask = new byte[png.width * png.height];
        } else if (png.genBWMask) {
            png.smask = new byte[(png.width + 7) / 8 * png.height];
        }
        ByteArrayInputStream bai = new ByteArrayInputStream(png.idat.toByteArray());
        png.dataStream = FilterUtil.getInflaterInputStream(bai);
        if (png.interlaceMethod != 1) {
            PngImageHelper.decodePass(0, 0, 1, 1, png.width, png.height, png);
        } else {
            PngImageHelper.decodePass(0, 0, 8, 8, (png.width + 7) / 8, (png.height + 7) / 8, png);
            PngImageHelper.decodePass(4, 0, 8, 8, (png.width + 3) / 8, (png.height + 7) / 8, png);
            PngImageHelper.decodePass(0, 4, 4, 8, (png.width + 3) / 4, (png.height + 3) / 8, png);
            PngImageHelper.decodePass(2, 0, 4, 4, (png.width + 1) / 4, (png.height + 3) / 4, png);
            PngImageHelper.decodePass(0, 2, 2, 4, (png.width + 1) / 2, (png.height + 1) / 4, png);
            PngImageHelper.decodePass(1, 0, 2, 2, png.width / 2, (png.height + 1) / 2, png);
            PngImageHelper.decodePass(0, 1, 1, 2, png.width, png.height / 2, png);
        }
    }

    private static void decodePass(int xOffset, int yOffset, int xStep, int yStep, int passWidth, int passHeight, PngParameters png) {
        if (passWidth == 0 || passHeight == 0) {
            return;
        }
        int bytesPerRow = (png.inputBands * passWidth * png.bitDepth + 7) / 8;
        byte[] curr = new byte[bytesPerRow];
        byte[] prior = new byte[bytesPerRow];
        int srcY = 0;
        int dstY = yOffset;
        while (srcY < passHeight) {
            int filter = 0;
            try {
                filter = png.dataStream.read();
                StreamUtil.readFully(png.dataStream, curr, 0, bytesPerRow);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (filter) {
                case 0: {
                    break;
                }
                case 1: {
                    PngImageHelper.decodeSubFilter(curr, bytesPerRow, png.bytesPerPixel);
                    break;
                }
                case 2: {
                    PngImageHelper.decodeUpFilter(curr, prior, bytesPerRow);
                    break;
                }
                case 3: {
                    PngImageHelper.decodeAverageFilter(curr, prior, bytesPerRow, png.bytesPerPixel);
                    break;
                }
                case 4: {
                    PngImageHelper.decodePaethFilter(curr, prior, bytesPerRow, png.bytesPerPixel);
                    break;
                }
                default: {
                    throw new IOException("Unknown PNG filter.");
                }
            }
            PngImageHelper.processPixels(curr, xOffset, xStep, dstY, passWidth, png);
            byte[] tmp = prior;
            prior = curr;
            curr = tmp;
            ++srcY;
            dstY += yStep;
        }
    }

    private static void processPixels(byte[] curr, int xOffset, int step, int y, int width, PngParameters png) {
        int srcX;
        int yStride;
        int dstX;
        int[] outPixel = PngImageHelper.getPixel(curr, png);
        int sizes = 0;
        switch (png.colorType) {
            case 0: 
            case 3: 
            case 4: {
                sizes = 1;
                break;
            }
            case 2: 
            case 6: {
                sizes = 3;
            }
        }
        if (png.imageData != null) {
            dstX = xOffset;
            yStride = (sizes * png.width * (png.bitDepth == 16 ? 8 : png.bitDepth) + 7) / 8;
            for (srcX = 0; srcX < width; ++srcX) {
                PngImageHelper.setPixel(png.imageData, outPixel, png.inputBands * srcX, sizes, dstX, y, png.bitDepth, yStride);
                dstX += step;
            }
        }
        if (png.palShades) {
            if ((png.colorType & 4) != 0) {
                if (png.bitDepth == 16) {
                    for (int k = 0; k < width; ++k) {
                        int n = k * png.inputBands + sizes;
                        outPixel[n] = outPixel[n] >>> 8;
                    }
                }
                yStride = png.width;
                dstX = xOffset;
                for (srcX = 0; srcX < width; ++srcX) {
                    PngImageHelper.setPixel(png.smask, outPixel, png.inputBands * srcX + sizes, 1, dstX, y, 8, yStride);
                    dstX += step;
                }
            } else {
                yStride = png.width;
                int[] v = new int[1];
                dstX = xOffset;
                for (srcX = 0; srcX < width; ++srcX) {
                    int idx = outPixel[srcX];
                    v[0] = idx < png.trans.length ? png.trans[idx] : 255;
                    PngImageHelper.setPixel(png.smask, v, 0, 1, dstX, y, 8, yStride);
                    dstX += step;
                }
            }
        } else if (png.genBWMask) {
            switch (png.colorType) {
                case 3: {
                    yStride = (png.width + 7) / 8;
                    int[] v = new int[1];
                    dstX = xOffset;
                    for (srcX = 0; srcX < width; ++srcX) {
                        int idx = outPixel[srcX];
                        v[0] = idx < png.trans.length && png.trans[idx] == 0 ? 1 : 0;
                        PngImageHelper.setPixel(png.smask, v, 0, 1, dstX, y, 1, yStride);
                        dstX += step;
                    }
                    break;
                }
                case 0: {
                    yStride = (png.width + 7) / 8;
                    int[] v = new int[1];
                    dstX = xOffset;
                    for (srcX = 0; srcX < width; ++srcX) {
                        int g = outPixel[srcX];
                        v[0] = g == png.transRedGray ? 1 : 0;
                        PngImageHelper.setPixel(png.smask, v, 0, 1, dstX, y, 1, yStride);
                        dstX += step;
                    }
                    break;
                }
                case 2: {
                    yStride = (png.width + 7) / 8;
                    int[] v = new int[1];
                    dstX = xOffset;
                    for (srcX = 0; srcX < width; ++srcX) {
                        int markRed = png.inputBands * srcX;
                        v[0] = outPixel[markRed] == png.transRedGray && outPixel[markRed + 1] == png.transGreen && outPixel[markRed + 2] == png.transBlue ? 1 : 0;
                        PngImageHelper.setPixel(png.smask, v, 0, 1, dstX, y, 1, yStride);
                        dstX += step;
                    }
                    break;
                }
            }
        }
    }

    private static int getPixel(byte[] image, int x, int y, int bitDepth, int bytesPerRow) {
        if (bitDepth == 8) {
            int pos = bytesPerRow * y + x;
            return image[pos] & 0xFF;
        }
        int pos = bytesPerRow * y + x / (8 / bitDepth);
        int v = image[pos] >> 8 - bitDepth * (x % (8 / bitDepth)) - bitDepth;
        return v & (1 << bitDepth) - 1;
    }

    static void setPixel(byte[] image, int[] data, int offset, int size, int x, int y, int bitDepth, int bytesPerRow) {
        if (bitDepth == 8) {
            int pos = bytesPerRow * y + size * x;
            for (int k = 0; k < size; ++k) {
                image[pos + k] = (byte)data[k + offset];
            }
        } else if (bitDepth == 16) {
            int pos = bytesPerRow * y + size * x;
            for (int k = 0; k < size; ++k) {
                image[pos + k] = (byte)(data[k + offset] >>> 8);
            }
        } else {
            int pos = bytesPerRow * y + x / (8 / bitDepth);
            int v = data[offset] << 8 - bitDepth * (x % (8 / bitDepth)) - bitDepth;
            int n = pos;
            image[n] = (byte)(image[n] | (byte)v);
        }
    }

    private static int[] getPixel(byte[] curr, PngParameters png) {
        switch (png.bitDepth) {
            case 8: {
                int[] res = new int[curr.length];
                for (int k = 0; k < res.length; ++k) {
                    res[k] = curr[k] & 0xFF;
                }
                return res;
            }
            case 16: {
                int[] res = new int[curr.length / 2];
                for (int k = 0; k < res.length; ++k) {
                    res[k] = ((curr[k * 2] & 0xFF) << 8) + (curr[k * 2 + 1] & 0xFF);
                }
                return res;
            }
        }
        int[] res = new int[curr.length * 8 / png.bitDepth];
        int idx = 0;
        int passes = 8 / png.bitDepth;
        int mask = (1 << png.bitDepth) - 1;
        for (int k = 0; k < curr.length; ++k) {
            for (int j = passes - 1; j >= 0; --j) {
                res[idx++] = curr[k] >>> png.bitDepth * j & mask;
            }
        }
        return res;
    }

    private static void decodeSubFilter(byte[] curr, int count, int bpp) {
        for (int i = bpp; i < count; ++i) {
            int val = curr[i] & 0xFF;
            curr[i] = (byte)(val += curr[i - bpp] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] curr, byte[] prev, int count) {
        for (int i = 0; i < count; ++i) {
            int raw = curr[i] & 0xFF;
            int prior = prev[i] & 0xFF;
            curr[i] = (byte)(raw + prior);
        }
    }

    private static void decodeAverageFilter(byte[] curr, byte[] prev, int count, int bpp) {
        int priorRow;
        int raw;
        int i;
        for (i = 0; i < bpp; ++i) {
            raw = curr[i] & 0xFF;
            priorRow = prev[i] & 0xFF;
            curr[i] = (byte)(raw + priorRow / 2);
        }
        for (i = bpp; i < count; ++i) {
            raw = curr[i] & 0xFF;
            int priorPixel = curr[i - bpp] & 0xFF;
            priorRow = prev[i] & 0xFF;
            curr[i] = (byte)(raw + (priorPixel + priorRow) / 2);
        }
    }

    private static int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    private static void decodePaethFilter(byte[] curr, byte[] prev, int count, int bpp) {
        int priorRow;
        int raw;
        int i;
        for (i = 0; i < bpp; ++i) {
            raw = curr[i] & 0xFF;
            priorRow = prev[i] & 0xFF;
            curr[i] = (byte)(raw + priorRow);
        }
        for (i = bpp; i < count; ++i) {
            raw = curr[i] & 0xFF;
            int priorPixel = curr[i - bpp] & 0xFF;
            priorRow = prev[i] & 0xFF;
            int priorRowPixel = prev[i - bpp] & 0xFF;
            curr[i] = (byte)(raw + PngImageHelper.paethPredictor(priorPixel, priorRow, priorRowPixel));
        }
    }

    public static int getInt(InputStream pngStream) throws java.io.IOException {
        return (pngStream.read() << 24) + (pngStream.read() << 16) + (pngStream.read() << 8) + pngStream.read();
    }

    public static int getWord(InputStream pngStream) throws java.io.IOException {
        return (pngStream.read() << 8) + pngStream.read();
    }

    public static String getString(InputStream pngStream) throws java.io.IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            buf.append((char)pngStream.read());
        }
        return buf.toString();
    }

    private static class PngParameters {
        PngImageData image;
        InputStream dataStream;
        int width;
        int height;
        int bitDepth;
        int colorType;
        int compressionMethod;
        int filterMethod;
        int interlaceMethod;
        Map<String, Object> additional = new HashMap<String, Object>();
        byte[] imageData;
        byte[] smask;
        byte[] trans;
        ByteArrayOutputStream idat = new ByteArrayOutputStream();
        int dpiX;
        int dpiY;
        float XYRatio;
        boolean genBWMask;
        boolean palShades;
        int transRedGray = -1;
        int transGreen = -1;
        int transBlue = -1;
        int inputBands;
        int bytesPerPixel;
        byte[] colorTable;
        float gamma = 1.0f;
        boolean hasCHRM = false;
        float xW;
        float yW;
        float xR;
        float yR;
        float xG;
        float yG;
        float xB;
        float yB;
        String intent;
        IccProfile iccProfile;

        PngParameters(PngImageData image) {
            this.image = image;
        }
    }
}

