/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.IOException;
import com.itextpdf.io.codec.CCITTG4Encoder;
import com.itextpdf.io.codec.TIFFFaxDecoder;
import com.itextpdf.io.image.AwtImageDataFactory;
import com.itextpdf.io.image.BmpImageData;
import com.itextpdf.io.image.BmpImageHelper;
import com.itextpdf.io.image.GifImageData;
import com.itextpdf.io.image.GifImageHelper;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.ImageTypeDetector;
import com.itextpdf.io.image.Jbig2ImageData;
import com.itextpdf.io.image.Jbig2ImageHelper;
import com.itextpdf.io.image.Jpeg2000ImageData;
import com.itextpdf.io.image.Jpeg2000ImageHelper;
import com.itextpdf.io.image.JpegImageData;
import com.itextpdf.io.image.JpegImageHelper;
import com.itextpdf.io.image.PngImageData;
import com.itextpdf.io.image.PngImageHelper;
import com.itextpdf.io.image.RawImageData;
import com.itextpdf.io.image.TiffImageData;
import com.itextpdf.io.image.TiffImageHelper;
import com.itextpdf.io.util.UrlUtil;
import java.awt.Color;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ImageDataFactory {
    private ImageDataFactory() {
    }

    public static ImageData create(byte[] bytes, boolean recoverImage) {
        return ImageDataFactory.createImageInstance(bytes, recoverImage);
    }

    public static ImageData create(byte[] bytes) {
        return ImageDataFactory.create(bytes, false);
    }

    public static ImageData create(URL url, boolean recoverImage) {
        return ImageDataFactory.createImageInstance(url, recoverImage);
    }

    public static ImageData create(URL url) {
        return ImageDataFactory.create(url, false);
    }

    public static ImageData create(String filename, boolean recoverImage) throws MalformedURLException {
        return ImageDataFactory.create(UrlUtil.toURL(filename), recoverImage);
    }

    public static ImageData create(String filename) throws MalformedURLException {
        return ImageDataFactory.create(filename, false);
    }

    public static ImageData create(int width, int height, boolean reverseBits, int typeCCITT, int parameters, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != 2) {
            throw new IOException("Transparency length must be equal to 2 with CCITT images");
        }
        if (typeCCITT != 256 && typeCCITT != 257 && typeCCITT != 258) {
            throw new IOException("CCITT compression type must be CCITTG4, CCITTG3_1D or CCITTG3_2D.");
        }
        if (reverseBits) {
            TIFFFaxDecoder.reverseBits(data);
        }
        RawImageData image = new RawImageData(data, ImageType.RAW);
        image.setTypeCcitt(typeCCITT);
        image.height = height;
        image.width = width;
        image.colorSpace = parameters;
        image.transparency = transparency;
        return image;
    }

    public static ImageData create(int width, int height, int components, int bpc, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != components * 2) {
            throw new IOException("Transparency length must be equal to 2 with CCITT images");
        }
        if (components == 1 && bpc == 1) {
            byte[] g4 = CCITTG4Encoder.compress(data, width, height);
            return ImageDataFactory.create(width, height, false, 256, 1, g4, transparency);
        }
        RawImageData image = new RawImageData(data, ImageType.RAW);
        image.height = height;
        image.width = width;
        if (components != 1 && components != 3 && components != 4) {
            throw new IOException("Components must be 1, 3 or 4.");
        }
        if (bpc != 1 && bpc != 2 && bpc != 4 && bpc != 8) {
            throw new IOException("Bits per component must be 1, 2, 4 or 8.");
        }
        image.colorSpace = components;
        image.bpc = bpc;
        image.data = data;
        image.transparency = transparency;
        return image;
    }

    public static ImageData create(Image image, Color color) throws java.io.IOException {
        return ImageDataFactory.create(image, color, false);
    }

    public static ImageData create(Image image, Color color, boolean forceBW) throws java.io.IOException {
        return AwtImageDataFactory.create(image, color, forceBW);
    }

    public static ImageData createBmp(URL url, boolean noHeader) {
        return ImageDataFactory.createBmp(url, noHeader, 0);
    }

    @Deprecated
    public static ImageData createBmp(URL url, boolean noHeader, int size) {
        ImageDataFactory.validateImageType(url, ImageType.BMP);
        BmpImageData image = new BmpImageData(url, noHeader, size);
        BmpImageHelper.processImage(image);
        return image;
    }

    public static ImageData createBmp(byte[] bytes, boolean noHeader) {
        return ImageDataFactory.createBmp(bytes, noHeader, 0);
    }

    @Deprecated
    public static ImageData createBmp(byte[] bytes, boolean noHeader, int size) {
        if (noHeader || ImageTypeDetector.detectImageType(bytes) == ImageType.BMP) {
            BmpImageData image = new BmpImageData(bytes, noHeader, size);
            BmpImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("BMP image expected.");
    }

    public static GifImageData createGif(byte[] bytes) {
        ImageDataFactory.validateImageType(bytes, ImageType.GIF);
        GifImageData image = new GifImageData(bytes);
        GifImageHelper.processImage(image);
        return image;
    }

    public static ImageData createGifFrame(URL url, int frame) {
        return ImageDataFactory.createGifFrames(url, new int[]{frame}).get(0);
    }

    public static ImageData createGifFrame(byte[] bytes, int frame) {
        return ImageDataFactory.createGifFrames(bytes, new int[]{frame}).get(0);
    }

    public static List<ImageData> createGifFrames(byte[] bytes, int[] frameNumbers) {
        ImageDataFactory.validateImageType(bytes, ImageType.GIF);
        GifImageData image = new GifImageData(bytes);
        return ImageDataFactory.processGifImageAndExtractFrames(frameNumbers, image);
    }

    public static List<ImageData> createGifFrames(URL url, int[] frameNumbers) {
        ImageDataFactory.validateImageType(url, ImageType.GIF);
        GifImageData image = new GifImageData(url);
        return ImageDataFactory.processGifImageAndExtractFrames(frameNumbers, image);
    }

    public static List<ImageData> createGifFrames(byte[] bytes) {
        ImageDataFactory.validateImageType(bytes, ImageType.GIF);
        GifImageData image = new GifImageData(bytes);
        GifImageHelper.processImage(image);
        return image.getFrames();
    }

    public static List<ImageData> createGifFrames(URL url) {
        ImageDataFactory.validateImageType(url, ImageType.GIF);
        GifImageData image = new GifImageData(url);
        GifImageHelper.processImage(image);
        return image.getFrames();
    }

    public static ImageData createJbig2(URL url, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("The page number must be greater than 0");
        }
        ImageDataFactory.validateImageType(url, ImageType.JBIG2);
        Jbig2ImageData image = new Jbig2ImageData(url, page);
        Jbig2ImageHelper.processImage(image);
        return image;
    }

    public static ImageData createJbig2(byte[] bytes, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("The page number must be greater than 0");
        }
        ImageDataFactory.validateImageType(bytes, ImageType.JBIG2);
        Jbig2ImageData image = new Jbig2ImageData(bytes, page);
        Jbig2ImageHelper.processImage(image);
        return image;
    }

    public static ImageData createJpeg(URL url) {
        ImageDataFactory.validateImageType(url, ImageType.JPEG);
        JpegImageData image = new JpegImageData(url);
        JpegImageHelper.processImage(image);
        return image;
    }

    public static ImageData createJpeg(byte[] bytes) {
        ImageDataFactory.validateImageType(bytes, ImageType.JPEG);
        JpegImageData image = new JpegImageData(bytes);
        JpegImageHelper.processImage(image);
        return image;
    }

    public static ImageData createJpeg2000(URL url) {
        ImageDataFactory.validateImageType(url, ImageType.JPEG2000);
        Jpeg2000ImageData image = new Jpeg2000ImageData(url);
        Jpeg2000ImageHelper.processImage(image);
        return image;
    }

    public static ImageData createJpeg2000(byte[] bytes) {
        ImageDataFactory.validateImageType(bytes, ImageType.JPEG2000);
        Jpeg2000ImageData image = new Jpeg2000ImageData(bytes);
        Jpeg2000ImageHelper.processImage(image);
        return image;
    }

    public static ImageData createPng(URL url) {
        ImageDataFactory.validateImageType(url, ImageType.PNG);
        PngImageData image = new PngImageData(url);
        PngImageHelper.processImage(image);
        return image;
    }

    public static ImageData createPng(byte[] bytes) {
        ImageDataFactory.validateImageType(bytes, ImageType.PNG);
        PngImageData image = new PngImageData(bytes);
        PngImageHelper.processImage(image);
        return image;
    }

    public static ImageData createTiff(URL url, boolean recoverFromImageError, int page, boolean direct) {
        ImageDataFactory.validateImageType(url, ImageType.TIFF);
        TiffImageData image = new TiffImageData(url, recoverFromImageError, page, direct);
        TiffImageHelper.processImage(image);
        return image;
    }

    public static ImageData createTiff(byte[] bytes, boolean recoverFromImageError, int page, boolean direct) {
        ImageDataFactory.validateImageType(bytes, ImageType.TIFF);
        TiffImageData image = new TiffImageData(bytes, recoverFromImageError, page, direct);
        TiffImageHelper.processImage(image);
        return image;
    }

    public static ImageData createRawImage(byte[] bytes) {
        return new RawImageData(bytes, ImageType.RAW);
    }

    public static boolean isSupportedType(byte[] source) {
        if (source == null) {
            return false;
        }
        ImageType imageType = ImageTypeDetector.detectImageType(source);
        return ImageDataFactory.isSupportedType(imageType);
    }

    public static boolean isSupportedType(URL source) {
        if (source == null) {
            return false;
        }
        ImageType imageType = ImageTypeDetector.detectImageType(source);
        return ImageDataFactory.isSupportedType(imageType);
    }

    public static boolean isSupportedType(ImageType imageType) {
        return imageType == ImageType.GIF || imageType == ImageType.JPEG || imageType == ImageType.JPEG2000 || imageType == ImageType.PNG || imageType == ImageType.BMP || imageType == ImageType.TIFF || imageType == ImageType.JBIG2;
    }

    private static ImageData createImageInstance(URL source, boolean recoverImage) {
        ImageType imageType = ImageTypeDetector.detectImageType(source);
        switch (imageType) {
            case GIF: {
                GifImageData image = new GifImageData(source);
                GifImageHelper.processImage(image, 0);
                return image.getFrames().get(0);
            }
            case JPEG: {
                JpegImageData image = new JpegImageData(source);
                JpegImageHelper.processImage(image);
                return image;
            }
            case JPEG2000: {
                Jpeg2000ImageData image = new Jpeg2000ImageData(source);
                Jpeg2000ImageHelper.processImage(image);
                return image;
            }
            case PNG: {
                PngImageData image = new PngImageData(source);
                PngImageHelper.processImage(image);
                return image;
            }
            case BMP: {
                BmpImageData image = new BmpImageData(source, false);
                BmpImageHelper.processImage(image);
                return image;
            }
            case TIFF: {
                TiffImageData image = new TiffImageData(source, recoverImage, 1, false);
                TiffImageHelper.processImage(image);
                return image;
            }
            case JBIG2: {
                Jbig2ImageData image = new Jbig2ImageData(source, 1);
                Jbig2ImageHelper.processImage(image);
                return image;
            }
        }
        throw new IOException("Image format cannot be recognized.");
    }

    private static ImageData createImageInstance(byte[] bytes, boolean recoverImage) {
        ImageType imageType = ImageTypeDetector.detectImageType(bytes);
        switch (imageType) {
            case GIF: {
                GifImageData image = new GifImageData(bytes);
                GifImageHelper.processImage(image, 0);
                return image.getFrames().get(0);
            }
            case JPEG: {
                JpegImageData image = new JpegImageData(bytes);
                JpegImageHelper.processImage(image);
                return image;
            }
            case JPEG2000: {
                Jpeg2000ImageData image = new Jpeg2000ImageData(bytes);
                Jpeg2000ImageHelper.processImage(image);
                return image;
            }
            case PNG: {
                PngImageData image = new PngImageData(bytes);
                PngImageHelper.processImage(image);
                return image;
            }
            case BMP: {
                BmpImageData image = new BmpImageData(bytes, false);
                BmpImageHelper.processImage(image);
                return image;
            }
            case TIFF: {
                TiffImageData image = new TiffImageData(bytes, recoverImage, 1, false);
                TiffImageHelper.processImage(image);
                return image;
            }
            case JBIG2: {
                Jbig2ImageData image = new Jbig2ImageData(bytes, 1);
                Jbig2ImageHelper.processImage(image);
                return image;
            }
        }
        throw new IOException("Image format cannot be recognized.");
    }

    private static List<ImageData> processGifImageAndExtractFrames(int[] frameNumbers, GifImageData image) {
        Arrays.sort(frameNumbers);
        GifImageHelper.processImage(image, frameNumbers[frameNumbers.length - 1] - 1);
        ArrayList<ImageData> frames = new ArrayList<ImageData>();
        for (int frame : frameNumbers) {
            frames.add(image.getFrames().get(frame - 1));
        }
        return frames;
    }

    private static void validateImageType(byte[] image, ImageType expectedType) {
        ImageType detectedType = ImageTypeDetector.detectImageType(image);
        if (detectedType != expectedType) {
            throw new IllegalArgumentException(expectedType.name() + " image expected. Detected image type: " + detectedType.name());
        }
    }

    private static void validateImageType(URL imageUrl, ImageType expectedType) {
        ImageType detectedType = ImageTypeDetector.detectImageType(imageUrl);
        if (detectedType != expectedType) {
            throw new IllegalArgumentException(expectedType.name() + " image expected. Detected image type: " + detectedType.name());
        }
    }
}

