/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.io.util.CliCommandUtil;
import com.itextpdf.io.util.SystemUtil;
import java.io.IOException;

public class ImageMagickHelper {
    public static final String MAGICK_COMPARE_ENVIRONMENT_VARIABLE = "ITEXT_MAGICK_COMPARE_EXEC";
    @Deprecated
    static final String MAGICK_COMPARE_ENVIRONMENT_VARIABLE_LEGACY = "compareExec";
    static final String MAGICK_COMPARE_KEYWORD = "ImageMagick Studio LLC";
    private String compareExec;

    public ImageMagickHelper() {
        this(null);
    }

    public ImageMagickHelper(String newCompareExec) {
        this.compareExec = newCompareExec;
        if (this.compareExec == null) {
            this.compareExec = SystemUtil.getPropertyOrEnvironmentVariable(MAGICK_COMPARE_ENVIRONMENT_VARIABLE);
            if (this.compareExec == null) {
                this.compareExec = SystemUtil.getPropertyOrEnvironmentVariable(MAGICK_COMPARE_ENVIRONMENT_VARIABLE_LEGACY);
            }
        }
        if (!CliCommandUtil.isVersionCommandExecutable(this.compareExec, MAGICK_COMPARE_KEYWORD)) {
            throw new IllegalArgumentException("ImageMagick comparison command specified incorrectly. Set the ITEXT_MAGICK_COMPARE_EXEC environment variable with the CLI command which can run the ImageMagic comparison. See BUILDING.MD in the root of the repository for more details.");
        }
    }

    public String getCliExecutionCommand() {
        return this.compareExec;
    }

    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName) throws IOException, InterruptedException {
        return this.runImageMagickImageCompare(outImageFilePath, cmpImageFilePath, diffImageName, null);
    }

    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName, String fuzzValue) throws IOException, InterruptedException {
        fuzzValue = fuzzValue == null ? "" : " -metric AE -fuzz <fuzzValue>%".replace("<fuzzValue>", fuzzValue);
        StringBuilder currCompareParams = new StringBuilder();
        currCompareParams.append(fuzzValue).append(" '").append(outImageFilePath).append("' '").append(cmpImageFilePath).append("' '").append(diffImageName).append("'");
        return SystemUtil.runProcessAndWait(this.compareExec, currCompareParams.toString());
    }
}

