/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static URL toURL(String filename) throws MalformedURLException {
        URL url;
        try {
            url = new URL(filename);
        }
        catch (MalformedURLException e) {
            url = new File(filename).toURI().toURL();
        }
        return url;
    }

    public static URI toNormalizedURI(String filename) {
        return UrlUtil.toNormalizedURI(new File(filename));
    }

    public static URI toNormalizedURI(File file) {
        return file.toURI().normalize();
    }

    public static InputStream openStream(URL url) throws IOException {
        return url.openStream();
    }

    public static URL getFinalURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String location = connection.getHeaderField("location");
        while (location != null) {
            url = new URL(location);
            connection = url.openConnection();
            location = connection.getHeaderField("location");
        }
        return url;
    }
}

