/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.IRandomAccessSource;
import java.io.IOException;
import java.io.RandomAccessFile;

class RAFRandomAccessSource
implements IRandomAccessSource {
    private final RandomAccessFile raf;
    private final long length;

    public RAFRandomAccessSource(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.length = raf.length();
    }

    @Override
    public int get(long position) throws IOException {
        if (position > this.raf.length()) {
            return -1;
        }
        this.raf.seek(position);
        return this.raf.read();
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        if (position > this.length) {
            return -1;
        }
        this.raf.seek(position);
        return this.raf.read(bytes, off, len);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }
}

