/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.OtfClass;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;

public class OpenTypeGdefTableReader {
    private final int GLYPH_SKIP_BASE = 1;
    private final int GLYPH_SKIP_MARK = 2;
    private final int GLYPH_SKIP_LIGATURE = 3;
    private final int FLAG_IGNORE_BASE = 2;
    private final int FLAG_IGNORE_LIGATURE = 4;
    private final int FLAG_IGNORE_MARK = 8;
    private final int tableLocation;
    private final RandomAccessFileOrArray rf;
    private OtfClass glyphClass;
    private OtfClass markAttachmentClass;

    public OpenTypeGdefTableReader(RandomAccessFileOrArray rf, int tableLocation) {
        this.rf = rf;
        this.tableLocation = tableLocation;
    }

    public void readTable() throws IOException {
        if (this.tableLocation > 0) {
            this.rf.seek(this.tableLocation);
            this.rf.readUnsignedInt();
            int glyphClassDefOffset = this.rf.readUnsignedShort();
            this.rf.readUnsignedShort();
            this.rf.readUnsignedShort();
            int markAttachClassDefOffset = this.rf.readUnsignedShort();
            if (glyphClassDefOffset > 0) {
                this.glyphClass = new OtfClass(this.rf, glyphClassDefOffset + this.tableLocation);
            }
            if (markAttachClassDefOffset > 0) {
                this.markAttachmentClass = new OtfClass(this.rf, markAttachClassDefOffset + this.tableLocation);
            }
        }
    }

    public boolean isSkip(int glyph, int flag) {
        if (this.glyphClass != null && (flag & 0xE) != 0) {
            int cla = this.glyphClass.getOtfClass(glyph);
            if (cla == 1 && (flag & 2) != 0) {
                return true;
            }
            if (cla == 2 && (flag & 8) != 0) {
                return true;
            }
            if (cla == 3 && (flag & 4) != 0) {
                return true;
            }
        }
        if (this.markAttachmentClass != null && flag >> 8 > 0) {
            return this.markAttachmentClass.getOtfClass(glyph) != flag >> 8;
        }
        return false;
    }
}

