/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.FeatureRecord;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.TagAndLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenTypeFeature {
    private OpenTypeFontTableReader openTypeReader;
    private List<FeatureRecord> records;

    public OpenTypeFeature(OpenTypeFontTableReader openTypeReader, int locationFeatureTable) throws IOException {
        TagAndLocation[] tagsLocs;
        this.openTypeReader = openTypeReader;
        this.records = new ArrayList<FeatureRecord>();
        openTypeReader.rf.seek(locationFeatureTable);
        for (TagAndLocation tagLoc : tagsLocs = openTypeReader.readTagAndLocations(locationFeatureTable)) {
            openTypeReader.rf.seek(tagLoc.location + 2);
            int lookupCount = openTypeReader.rf.readUnsignedShort();
            FeatureRecord rec = new FeatureRecord();
            rec.tag = tagLoc.tag;
            rec.lookups = openTypeReader.readUShortArray(lookupCount);
            this.records.add(rec);
        }
    }

    public List<FeatureRecord> getRecords() {
        return this.records;
    }

    public FeatureRecord getRecord(int idx) {
        if (idx < 0 || idx >= this.records.size()) {
            return null;
        }
        return this.records.get(idx);
    }
}

