/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.FileUtil;

public class TrueTypeCollection {
    protected RandomAccessFileOrArray raf;
    String encoding;
    int TTCSize = 0;
    String ttcPath;
    byte[] ttc;
    boolean cached = false;

    public TrueTypeCollection(byte[] ttc, String encoding) throws java.io.IOException {
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ttc));
        this.ttc = ttc;
        this.encoding = encoding;
        this.initFontSize();
    }

    public TrueTypeCollection(String ttcPath, String encoding) throws java.io.IOException {
        if (!FileUtil.fileExists(ttcPath)) {
            throw new IOException("font.file {0} not.found").setMessageParams(ttcPath);
        }
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(ttcPath));
        this.ttcPath = ttcPath;
        this.encoding = encoding;
        this.initFontSize();
    }

    public FontProgram getFontByTccIndex(int ttcIndex) throws java.io.IOException {
        if (ttcIndex > this.TTCSize - 1) {
            throw new IOException("ttc.index.doesn't.exist.in.ttc.file");
        }
        if (this.ttcPath != null) {
            return FontProgramFactory.createFont(this.ttcPath, ttcIndex, this.cached);
        }
        return FontProgramFactory.createFont(this.ttc, ttcIndex, this.cached);
    }

    public int getTTCSize() {
        return this.TTCSize;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    private void initFontSize() throws java.io.IOException {
        String mainTag = this.raf.readString(4, "Cp1252");
        if (!mainTag.equals("ttcf")) {
            throw new IOException("{0} is.not.a.valid.ttc.file");
        }
        this.raf.skipBytes(4);
        this.TTCSize = this.raf.readInt();
    }
}

