/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.FontConstants;
import com.itextpdf.io.font.FontIdentification;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.util.FileUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class FontProgram
implements Serializable {
    private static final long serialVersionUID = -3488910249070253659L;
    public static final int DEFAULT_WIDTH = 1000;
    public static final int UNITS_NORMALIZATION = 1000;
    protected Map<Integer, Glyph> codeToGlyph = new HashMap<Integer, Glyph>();
    protected Map<Integer, Glyph> unicodeToGlyph = new HashMap<Integer, Glyph>();
    protected boolean isFontSpecific;
    protected FontNames fontNames = new FontNames();
    protected FontMetrics fontMetrics = new FontMetrics();
    protected FontIdentification fontIdentification = new FontIdentification();
    protected int avgWidth;
    protected String encodingScheme = "FontSpecific";
    protected String registry;

    public int countOfGlyphs() {
        return Math.max(this.codeToGlyph.size(), this.unicodeToGlyph.size());
    }

    public FontNames getFontNames() {
        return this.fontNames;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public FontIdentification getFontIdentification() {
        return this.fontIdentification;
    }

    public String getRegistry() {
        return this.registry;
    }

    public abstract int getPdfFontFlags();

    public boolean isFontSpecific() {
        return this.isFontSpecific;
    }

    public int getWidth(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getWidth() : 0;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public int[] getCharBBox(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getBbox() : null;
    }

    public Glyph getGlyph(int unicode) {
        return this.unicodeToGlyph.get(unicode);
    }

    public Glyph getGlyphByCode(int charCode) {
        return this.codeToGlyph.get(charCode);
    }

    public boolean hasKernPairs() {
        return false;
    }

    public int getKerning(int first, int second) {
        return this.getKerning(this.unicodeToGlyph.get(first), this.unicodeToGlyph.get(second));
    }

    public abstract int getKerning(Glyph var1, Glyph var2);

    protected void setRegistry(String registry) {
        this.registry = registry;
    }

    protected static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(",Bold")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.endsWith(",Italic")) {
            return name.substring(0, name.length() - 7);
        }
        if (name.endsWith(",BoldItalic")) {
            return name.substring(0, name.length() - 11);
        }
        return name;
    }

    protected void setTypoAscender(int ascender) {
        this.fontMetrics.setTypoAscender(ascender);
    }

    protected void setTypoDescender(int descender) {
        this.fontMetrics.setTypoDescender(descender);
    }

    protected void setCapHeight(int capHeight) {
        this.fontMetrics.setCapHeight(capHeight);
    }

    protected void setXHeight(int xHeight) {
        this.fontMetrics.setXHeight(xHeight);
    }

    protected void setItalicAngle(int italicAngle) {
        this.fontMetrics.setItalicAngle(italicAngle);
    }

    protected void setStemV(int stemV) {
        this.fontMetrics.setStemV(stemV);
    }

    protected void setStemH(int stemH) {
        this.fontMetrics.setStemH(stemH);
    }

    protected void setFontWeight(int fontWeight) {
        this.fontNames.setFontWeight(fontWeight);
    }

    protected void setFontWidth(String fontWidth) {
        fontWidth = fontWidth.toLowerCase();
        int fontWidthValue = 5;
        switch (fontWidth) {
            case "ultracondensed": {
                fontWidthValue = 1;
                break;
            }
            case "extracondensed": {
                fontWidthValue = 2;
                break;
            }
            case "condensed": {
                fontWidthValue = 3;
                break;
            }
            case "semicondensed": {
                fontWidthValue = 4;
                break;
            }
            case "normal": {
                fontWidthValue = 5;
                break;
            }
            case "semiexpanded": {
                fontWidthValue = 6;
                break;
            }
            case "expanded": {
                fontWidthValue = 7;
                break;
            }
            case "extraexpanded": {
                fontWidthValue = 8;
                break;
            }
            case "ultraexpanded": {
                fontWidthValue = 9;
            }
        }
        this.fontNames.setFontWidth(fontWidthValue);
    }

    protected void setFixedPitch(boolean isFixedPitch) {
        this.fontMetrics.setIsFixedPitch(isFixedPitch);
    }

    protected void setBold(boolean isBold) {
        if (isBold) {
            this.fontNames.setMacStyle(this.fontNames.getMacStyle() | 1);
        } else {
            this.fontNames.setMacStyle(this.fontNames.getMacStyle() & 0xFFFFFFFE);
        }
    }

    protected void setBbox(int[] bbox) {
        this.fontMetrics.setBbox(bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    protected void setFontFamily(String fontFamily) {
        this.fontNames.setFamilyName(fontFamily);
    }

    protected void setFontName(String psFontName) {
        this.fontNames.setFontName(psFontName);
    }

    protected void checkFilePath(String path) {
        if (path != null && !FontConstants.BUILTIN_FONTS_14.contains(path) && !FileUtil.fileExists(path)) {
            throw new IOException("font.file {0} not.found").setMessageParams(path);
        }
    }

    protected void fixSpaceIssue() {
        Glyph space = this.unicodeToGlyph.get(32);
        if (space != null) {
            this.codeToGlyph.put(space.getCode(), space);
        }
    }
}

