/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.util.ResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AdobeGlyphList {
    private static Map<Integer, String> unicode2names = new HashMap<Integer, String>();
    private static Map<String, Integer> names2unicode = new HashMap<String, Integer>();

    public static Integer nameToUnicode(String name) {
        Integer v = names2unicode.get(name);
        if (v == null && name.length() == 7 && name.toLowerCase().startsWith("uni")) {
            try {
                return Integer.valueOf(name.substring(3), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public static String unicodeToName(int num) {
        return unicode2names.get(num);
    }

    public static int getNameToUnicodeLength() {
        return names2unicode.size();
    }

    public static int getUnicodeToNameLength() {
        return unicode2names.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream resource = null;
        try {
            int size;
            resource = ResourceUtil.getResourceStream("com/itextpdf/io/font/AdobeGlyphList.txt");
            if (resource == null) {
                String msg = "AdobeGlyphList.txt not found as resource. (It must exist as resource in the package com.itextpdf.text.pdf.fonts)";
                throw new Exception(msg);
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            while ((size = resource.read(buf)) >= 0) {
                stream.write(buf, 0, size);
            }
            resource.close();
            resource = null;
            String s = PdfEncodings.convertToString(stream.toByteArray(), null);
            StringTokenizer tk = new StringTokenizer(s, "\r\n");
            while (tk.hasMoreTokens()) {
                StringTokenizer t2;
                String line = tk.nextToken();
                if (line.startsWith("#") || !(t2 = new StringTokenizer(line, " ;\r\n\t\f")).hasMoreTokens()) continue;
                String name = t2.nextToken();
                if (!t2.hasMoreTokens()) continue;
                String hex = t2.nextToken();
                if (t2.hasMoreTokens()) continue;
                Integer num = Integer.valueOf(hex, 16);
                unicode2names.put(num, name);
                names2unicode.put(name, num);
            }
        }
        catch (Exception e) {
            System.err.println("AdobeGlyphList.txt loading error: " + e.getMessage());
        }
        finally {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

