/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.ComboBoxField;
import com.itextpdf.forms.form.element.ListBoxField;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.OptGroupTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.OptionTagWorker;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTagWorker
implements ITagWorker,
IDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectTagWorker.class);
    private AbstractSelectField selectElement;
    private String display;

    public SelectTagWorker(IElementNode element, ProcessorContext context) {
        String name = context.getFormFieldNameResolver().resolveFormName(element.getAttribute("name"));
        boolean multipleAttr = element.getAttribute("multiple") != null;
        Integer sizeAttr = CssDimensionParsingUtils.parseInteger((String)element.getAttribute("size"));
        int size = this.getSelectSize(sizeAttr, multipleAttr);
        if (size > 1 || multipleAttr) {
            this.selectElement = new ListBoxField(name, size, multipleAttr);
            this.selectElement.deleteOwnProperty(48);
            this.selectElement.deleteOwnProperty(49);
            this.selectElement.deleteOwnProperty(50);
            this.selectElement.deleteOwnProperty(47);
        } else {
            this.selectElement = new ComboBoxField(name);
        }
        String lang = element.getAttribute("lang");
        this.selectElement.getAccessibilityProperties().setLanguage(lang);
        this.selectElement.setProperty(0x200001, (Object)(!context.isCreateAcroForm() ? 1 : 0));
        if (context.getConformanceLevel() != null) {
            this.selectElement.setProperty(0x20000F, (Object)context.getConformanceLevel());
        }
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return content == null || content.trim().isEmpty();
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        if ((childTagWorker instanceof OptionTagWorker || childTagWorker instanceof OptGroupTagWorker) && childTagWorker.getElementResult() instanceof IBlockElement) {
            IBlockElement blockElement = (IBlockElement)childTagWorker.getElementResult();
            String label = (String)blockElement.getProperty(0x20000A);
            SelectFieldItem item = new SelectFieldItem(label, blockElement);
            this.selectElement.addOption(item);
            Boolean isFlattenFromProperty = (Boolean)this.selectElement.getProperty(0x200001);
            if (childTagWorker instanceof OptGroupTagWorker && !Boolean.TRUE.equals(isFlattenFromProperty)) {
                LOGGER.warn("Option groups are not supported in interactive mode");
            }
            return true;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.selectElement;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private int getSelectSize(Integer size, boolean multiple) {
        if (size != null && size > 0) {
            return size;
        }
        return multiple ? 4 : 1;
    }
}

