/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormFieldRenderer
extends BlockRenderer
implements ILeafElementRenderer {
    protected IRenderer flatRenderer;

    AbstractFormFieldRenderer(IFormField modelElement) {
        super((IElement)modelElement);
    }

    public boolean isFlatten() {
        Boolean flatten = this.getPropertyAsBoolean(0x100003);
        return flatten != null ? flatten.booleanValue() : ((Boolean)this.modelElement.getDefaultProperty(0x100003)).booleanValue();
    }

    public String getDefaultValue() {
        String defaultValue = (String)this.getProperty(0x100005);
        return defaultValue != null ? defaultValue : (String)this.modelElement.getDefaultProperty(0x100005);
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        this.childRenderers.clear();
        this.flatRenderer = null;
        float parentWidth = layoutContext.getArea().getBBox().getWidth();
        float parentHeight = layoutContext.getArea().getBBox().getHeight();
        IRenderer renderer = this.createFlatRenderer();
        renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        renderer.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        this.addChild(renderer);
        Rectangle bBox = layoutContext.getArea().getBBox().clone().moveDown(1000000.0f - parentHeight).setHeight(1000000.0f);
        layoutContext.getArea().setBBox(bBox);
        LayoutResult result = super.layout(layoutContext);
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && result.getStatus() != 1) {
            FloatPropertyValue floatPropertyValue = (FloatPropertyValue)this.getProperty(99);
            if (floatPropertyValue == null || floatPropertyValue == FloatPropertyValue.NONE) {
                this.setProperty(26, true);
            } else {
                this.flatRenderer = (IRenderer)this.childRenderers.get(0);
                this.processLangAttribute();
                this.childRenderers.clear();
                this.childRenderers.add(this.flatRenderer);
                this.adjustFieldLayout(layoutContext);
                if (this.isLayoutBasedOnFlatRenderer()) {
                    Rectangle fBox = this.flatRenderer.getOccupiedArea().getBBox();
                    this.occupiedArea.getBBox().setX(fBox.getX()).setY(fBox.getY()).setWidth(fBox.getWidth()).setHeight(fBox.getHeight());
                    this.applyPaddings(this.occupiedArea.getBBox(), true);
                    this.applyBorderBox(this.occupiedArea.getBBox(), true);
                    this.applyMargins(this.occupiedArea.getBBox(), true);
                }
            }
            return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth());
        }
        if (!this.childRenderers.isEmpty()) {
            this.flatRenderer = (IRenderer)this.childRenderers.get(0);
            this.processLangAttribute();
            this.childRenderers.clear();
            this.childRenderers.add(this.flatRenderer);
            this.adjustFieldLayout(layoutContext);
            if (this.isLayoutBasedOnFlatRenderer()) {
                Rectangle fBox = this.flatRenderer.getOccupiedArea().getBBox();
                this.occupiedArea.getBBox().setX(fBox.getX()).setY(fBox.getY()).setWidth(fBox.getWidth()).setHeight(fBox.getHeight());
                this.applyPaddings(this.occupiedArea.getBBox(), true);
                this.applyBorderBox(this.occupiedArea.getBBox(), true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot layout form field field. It won't be displayed");
            this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
        }
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && !this.isRendererFit(parentWidth, parentHeight)) {
            this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
            return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth());
        }
        if (result.getStatus() != 1 || !this.isRendererFit(parentWidth, parentHeight)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Input field doesn't fit in outer object. It will be clipped");
        }
        return new MinMaxWidthLayoutResult(1, this.occupiedArea, (IRenderer)this, null).setMinMaxWidth(new MinMaxWidth(this.occupiedArea.getBBox().getWidth(), this.occupiedArea.getBBox().getWidth(), 0.0f));
    }

    public void draw(DrawContext drawContext) {
        if (this.flatRenderer != null) {
            super.draw(drawContext);
        }
    }

    public void drawChildren(DrawContext drawContext) {
        drawContext.getCanvas().saveState();
        boolean flatten = this.isFlatten();
        if (flatten) {
            drawContext.getCanvas().rectangle(this.applyBorderBox(this.occupiedArea.getBBox(), false)).clip().newPath();
            this.flatRenderer.draw(drawContext);
        } else {
            this.applyAcroField(drawContext);
        }
        drawContext.getCanvas().restoreState();
    }

    public float getAscent() {
        Float baseline = this.getLastYLineRecursively();
        return baseline != null ? this.occupiedArea.getBBox().getTop() - baseline.floatValue() : this.occupiedArea.getBBox().getHeight();
    }

    public float getDescent() {
        Float baseline = this.getLastYLineRecursively();
        return baseline != null ? this.occupiedArea.getBBox().getBottom() - baseline.floatValue() : 0.0f;
    }

    public MinMaxWidth getMinMaxWidth() {
        this.childRenderers.clear();
        this.flatRenderer = null;
        IRenderer renderer = this.createFlatRenderer();
        this.addChild(renderer);
        MinMaxWidth minMaxWidth = super.getMinMaxWidth();
        return minMaxWidth;
    }

    @Deprecated
    protected abstract void adjustFieldLayout();

    protected void adjustFieldLayout(LayoutContext layoutContext) {
        this.adjustFieldLayout();
    }

    protected abstract IRenderer createFlatRenderer();

    protected abstract void applyAcroField(DrawContext var1);

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    protected boolean isRendererFit(float availableWidth, float availableHeight) {
        if (this.occupiedArea == null) {
            return false;
        }
        return availableHeight >= this.occupiedArea.getBBox().getHeight() && availableWidth >= this.occupiedArea.getBBox().getWidth();
    }

    @Deprecated
    protected Float getContentWidth() {
        return super.retrieveWidth(0.0f);
    }

    protected String getLang() {
        return (String)this.getProperty(0x10000F);
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        UnitValue width = (UnitValue)super.getProperty(77);
        if (width != null && width.isPointValue()) {
            return this.getContentWidth();
        }
        return super.retrieveWidth(parentBoxWidth);
    }

    protected boolean isLayoutBasedOnFlatRenderer() {
        return true;
    }

    protected void writeAcroFormFieldLangAttribute(PdfDocument pdfDoc) {
        if (pdfDoc.isTagged()) {
            TagTreePointer formParentPointer = pdfDoc.getTagStructureContext().getAutoTaggingPointer();
            List kidsRoles = formParentPointer.getKidsRoles();
            int lastFormIndex = kidsRoles.lastIndexOf("Form");
            TagTreePointer formPointer = formParentPointer.moveToKid(lastFormIndex);
            if (this.getLang() != null) {
                formPointer.getProperties().setLanguage(this.getLang());
            }
            formParentPointer.moveToParent();
        }
    }

    private void processLangAttribute() {
        IPropertyContainer propertyContainer = this.flatRenderer.getModelElement();
        if (propertyContainer instanceof IAccessibleElement) {
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)propertyContainer, this.getLang());
        }
    }
}

