/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.property.BoxSizingPropertyValue;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTextFieldRenderer
extends AbstractFormFieldRenderer {
    protected PdfFont font;

    AbstractTextFieldRenderer(IFormField modelElement) {
        super(modelElement);
    }

    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.trim().isEmpty()) {
            defaultValue = "\u00a0";
        }
        Paragraph paragraph = (Paragraph)new Paragraph(defaultValue).setMargin(0.0f);
        return paragraph.createRendererSubTree();
    }

    void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, int rows) {
        if (lines.size() != rows) {
            float rowsHeight = this.getHeightRowsBased(lines, bBox, rows);
            AbstractTextFieldRenderer.adjustNumberOfContentLines(lines, bBox, rows, rowsHeight);
        }
    }

    void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, float height) {
        float averageLineHeight = bBox.getHeight() / (float)lines.size();
        int visibleLinesNumber = (int)Math.ceil(height / averageLineHeight);
        AbstractTextFieldRenderer.adjustNumberOfContentLines(lines, bBox, visibleLinesNumber, height);
    }

    void applyDefaultFieldProperties(PdfFormField inputField) {
        ((PdfWidgetAnnotation)inputField.getWidgets().get(0)).setHighlightMode(PdfAnnotation.HIGHLIGHT_NONE);
        inputField.setBorderWidth(0.0f);
        TransparentColor color = this.getPropertyAsTransparentColor(21);
        if (color != null) {
            inputField.setColor(color.getColor());
        }
    }

    float getHeightRowsBased(List<LineRenderer> lines, Rectangle bBox, int rows) {
        float averageLineHeight = bBox.getHeight() / (float)lines.size();
        return averageLineHeight * (float)rows;
    }

    void updatePdfFont(ParagraphRenderer renderer) {
        if (renderer != null) {
            Object retrievedFont;
            List lines = renderer.getLines();
            if (lines != null) {
                for (LineRenderer line : lines) {
                    for (IRenderer child : line.getChildRenderers()) {
                        retrievedFont = child.getProperty(20);
                        if (!(retrievedFont instanceof PdfFont)) continue;
                        this.font = (PdfFont)retrievedFont;
                        return;
                    }
                }
            }
            if ((retrievedFont = renderer.getProperty(20)) instanceof PdfFont) {
                this.font = (PdfFont)retrievedFont;
            }
        }
    }

    float updateHtmlColsSizeBasedWidth(float width) {
        if (BoxSizingPropertyValue.BORDER_BOX.equals(this.getProperty(105))) {
            Rectangle dummy = new Rectangle(width, 0.0f);
            this.applyBorderBox(dummy, true);
            this.applyPaddings(dummy, true);
            return dummy.getWidth();
        }
        return width;
    }

    private static void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, int linesNumber, float height) {
        bBox.moveUp(bBox.getHeight() - height);
        bBox.setHeight(height);
        if (lines.size() > linesNumber) {
            ArrayList<LineRenderer> subList = new ArrayList<LineRenderer>(lines.subList(0, linesNumber));
            lines.clear();
            lines.addAll(subList);
        }
    }
}

