/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.BackgroundApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.FontStyleApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.OutlineApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.VerticalAlignmentApplierUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMarginBoxCssApplier
implements ICssApplier {
    public static float[] parseBoxProps(Map<String, String> styles, float em, float rem, float[] defaultValues, Rectangle containingBlock, String topPropName, String rightPropName, String bottomPropName, String leftPropName) {
        String topStr = styles.get(topPropName);
        String rightStr = styles.get(rightPropName);
        String bottomStr = styles.get(bottomPropName);
        String leftStr = styles.get(leftPropName);
        Float top = PageMarginBoxCssApplier.parseBoxValue(topStr, em, rem, containingBlock.getHeight());
        Float right = PageMarginBoxCssApplier.parseBoxValue(rightStr, em, rem, containingBlock.getWidth());
        Float bottom = PageMarginBoxCssApplier.parseBoxValue(bottomStr, em, rem, containingBlock.getHeight());
        Float left = PageMarginBoxCssApplier.parseBoxValue(leftStr, em, rem, containingBlock.getWidth());
        return new float[]{top != null ? top.floatValue() : defaultValues[0], right != null ? right.floatValue() : defaultValues[1], bottom != null ? bottom.floatValue() : defaultValues[2], left != null ? left.floatValue() : defaultValues[3]};
    }

    @Override
    public void apply(ProcessorContext context, IStylesContainer stylesContainer, ITagWorker tagWorker) {
        String overflowY;
        String overflowX;
        Map boxStyles = stylesContainer.getStyles();
        IPropertyContainer marginBox = tagWorker.getElementResult();
        BackgroundApplierUtil.applyBackground(boxStyles, context, marginBox);
        FontStyleApplierUtil.applyFontStyles(boxStyles, context, stylesContainer, marginBox);
        BorderStyleApplierUtil.applyBorders(boxStyles, context, marginBox);
        VerticalAlignmentApplierUtil.applyVerticalAlignmentForCells(boxStyles, context, marginBox);
        String overflow = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow")) ? (String)boxStyles.get("overflow") : null;
        String string = overflowX = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow-x")) ? (String)boxStyles.get("overflow-x") : overflow;
        if (overflowX == null || "hidden".equals(overflowX)) {
            marginBox.setProperty(103, (Object)OverflowPropertyValue.HIDDEN);
        } else {
            marginBox.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        }
        String string2 = overflowY = CssConstants.OVERFLOW_VALUES.contains(boxStyles.get("overflow-y")) ? (String)boxStyles.get("overflow-y") : overflow;
        if (overflowY == null || "hidden".equals(overflowY)) {
            marginBox.setProperty(104, (Object)OverflowPropertyValue.HIDDEN);
        } else {
            marginBox.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        }
        OutlineApplierUtil.applyOutlines(boxStyles, context, marginBox);
        marginBox.setProperty(91, (Object)context.getFontProvider());
        marginBox.setProperty(98, (Object)context.getTempFonts());
        if (!(stylesContainer instanceof PageMarginBoxContextNode)) {
            Logger logger = LoggerFactory.getLogger(PageMarginBoxCssApplier.class);
            logger.warn("Page margin box margin, padding, height and width properties are not processed. Passed styles container shall be of PageMarginBoxContextNode type.");
            return;
        }
        PageMarginBoxContextNode pageMarginBoxContextNode = (PageMarginBoxContextNode)stylesContainer;
        float em = CssUtils.parseAbsoluteLength((String)((String)boxStyles.get("font-size")));
        float rem = context.getCssContext().getRootFontSize();
        float[] boxMargins = PageMarginBoxCssApplier.parseBoxProps(boxStyles, em, rem, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, pageMarginBoxContextNode.getContainingBlockForMarginBox(), "margin-top", "margin-right", "margin-bottom", "margin-left");
        float[] boxPaddings = PageMarginBoxCssApplier.parseBoxProps(boxStyles, em, rem, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, pageMarginBoxContextNode.getContainingBlockForMarginBox(), "padding-top", "padding-right", "padding-bottom", "padding-left");
        PageMarginBoxCssApplier.setUnitPointValueProperties(marginBox, new int[]{46, 45, 43, 44}, boxMargins);
        PageMarginBoxCssApplier.setUnitPointValueProperties(marginBox, new int[]{50, 49, 47, 48}, boxPaddings);
        float[] boxBorders = PageMarginBoxCssApplier.getBordersWidth(marginBox);
        float marginBorderPaddingWidth = boxMargins[1] + boxMargins[3] + boxBorders[1] + boxBorders[3] + boxPaddings[1] + boxPaddings[3];
        float marginBorderPaddingHeight = boxMargins[0] + boxMargins[2] + boxBorders[0] + boxBorders[2] + boxPaddings[0] + boxPaddings[2];
        float width = pageMarginBoxContextNode.getPageMarginBoxRectangle().getWidth() - marginBorderPaddingWidth;
        float height = pageMarginBoxContextNode.getPageMarginBoxRectangle().getHeight() - marginBorderPaddingHeight;
        PageMarginBoxCssApplier.setUnitPointValueProperty(marginBox, 77, width);
        PageMarginBoxCssApplier.setUnitPointValueProperty(marginBox, 27, height);
    }

    private static void setUnitPointValueProperties(IPropertyContainer container, int[] properties, float[] values) {
        for (int i = 0; i < properties.length; ++i) {
            PageMarginBoxCssApplier.setUnitPointValueProperty(container, properties[i], values[i]);
        }
    }

    private static void setUnitPointValueProperty(IPropertyContainer container, int property, float value) {
        UnitValue marginUV = UnitValue.createPointValue((float)value);
        container.setProperty(property, (Object)marginUV);
    }

    private static Float parseBoxValue(String valString, float em, float rem, float dimensionSize) {
        UnitValue marginUnitVal = CssUtils.parseLengthValueToPt((String)valString, (float)em, (float)rem);
        if (marginUnitVal != null) {
            if (marginUnitVal.isPointValue()) {
                return Float.valueOf(marginUnitVal.getValue());
            }
            if (marginUnitVal.isPercentValue()) {
                return Float.valueOf(marginUnitVal.getValue() * dimensionSize / 100.0f);
            }
        }
        return null;
    }

    private static float[] getBordersWidth(IPropertyContainer container) {
        Border border = (Border)container.getProperty(9);
        Border topBorder = (Border)container.getProperty(13);
        Border rightBorder = (Border)container.getProperty(12);
        Border bottomBorder = (Border)container.getProperty(10);
        Border leftBorder = (Border)container.getProperty(11);
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        if (!container.hasProperty(13)) {
            borders[0] = border;
        }
        if (!container.hasProperty(12)) {
            borders[1] = border;
        }
        if (!container.hasProperty(10)) {
            borders[2] = border;
        }
        if (!container.hasProperty(11)) {
            borders[3] = border;
        }
        return new float[]{borders[0] != null ? borders[0].getWidth() : 0.0f, borders[1] != null ? borders[1].getWidth() : 0.0f, borders[2] != null ? borders[2].getWidth() : 0.0f, borders[3] != null ? borders[3].getWidth() : 0.0f};
    }
}

