/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgTagWorker
implements ITagWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImgTagWorker.class);
    private Image image;
    private String display;

    public ImgTagWorker(IElementNode element, ProcessorContext context) {
        String altText;
        String src = element.getAttribute("src");
        if (src != null) {
            if (src.contains("base64") || context.getResourceResolver().isImageTypeSupportedByImageDataFactory(src)) {
                this.processAsImage(src, element, context);
            } else {
                byte[] resourceBytes = context.getResourceResolver().retrieveBytesFromResource(src);
                if (resourceBytes != null) {
                    try (InputStream resourceStream = context.getResourceResolver().retrieveResourceAsInputStream(src);){
                        try {
                            this.processAsSvg(resourceStream, context);
                        }
                        catch (SvgProcessingException spe) {
                            LOGGER.error(MessageFormatUtil.format((String)"Unable to process image found at {0} as an SVG", (Object[])new Object[]{context.getBaseUri(), src}));
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{context.getBaseUri(), src}));
                    }
                }
            }
        } else {
            LOGGER.error(MessageFormatUtil.format((String)"Unable to retrieve image with given base URI ({0}) and image source path ({1})", (Object[])new Object[]{context.getBaseUri(), src}));
        }
        String string = this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
        if (element.getStyles() != null && "absolute".equals(element.getStyles().get("position"))) {
            this.display = "block";
        }
        if ((altText = element.getAttribute("alt")) != null && this.image != null) {
            this.image.getAccessibilityProperties().setAlternateDescription(altText);
        }
    }

    private void processAsSvg(InputStream stream, ProcessorContext context) throws IOException {
        SvgProcessingUtil processingUtil = new SvgProcessingUtil();
        SvgConverterProperties svgConverterProperties = new SvgConverterProperties();
        svgConverterProperties.setBaseUri(context.getBaseUri()).setFontProvider(context.getFontProvider()).setMediaDeviceDescription(context.getDeviceDescription());
        ISvgProcessorResult res = SvgConverter.parseAndProcess((InputStream)stream, (ISvgConverterProperties)svgConverterProperties);
        if (context.getPdfDocument() != null) {
            this.image = processingUtil.createImageFromProcessingResult(res, context.getPdfDocument());
        }
    }

    private void processAsImage(String src, IElementNode element, ProcessorContext context) {
        PdfImageXObject imageXObject = context.getResourceResolver().retrieveImage(src);
        if (imageXObject != null) {
            this.image = new HtmlImage(imageXObject);
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.image;
    }

    String getDisplay() {
        return this.display;
    }

    private class HtmlImage
    extends Image {
        private double pxToPt;

        public HtmlImage(PdfImageXObject xObject) {
            super(xObject);
            this.pxToPt = 0.75;
        }

        public float getImageWidth() {
            return (float)((double)this.xObject.getWidth() * this.pxToPt);
        }

        public float getImageHeight() {
            return (float)((double)this.xObject.getHeight() * this.pxToPt);
        }
    }
}

