/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTagWorker
implements ITagWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectTagWorker.class);
    private Image image = null;
    private ISvgProcessorResult res = null;
    private SvgProcessingUtil processUtil = new SvgProcessingUtil();

    public ObjectTagWorker(IElementNode element, ProcessorContext context) {
        InputStream svgStream;
        String type = element.getAttribute("type");
        if (this.isSvgImage(type) && (svgStream = context.getResourceResolver().retrieveResourceAsInputStream(element.getAttribute("data"))) != null) {
            try {
                this.res = SvgConverter.parseAndProcess((InputStream)svgStream);
            }
            catch (SvgProcessingException spe) {
                LOGGER.error(spe.getMessage());
            }
            catch (IOException ie) {
                LOGGER.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{context.getBaseUri(), element.getAttribute("data")}));
            }
        }
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (context.getPdfDocument() != null) {
            PdfDocument document = context.getPdfDocument();
            if (this.res != null) {
                this.image = this.processUtil.createImageFromProcessingResult(this.res, document);
            }
        } else {
            LOGGER.error("PdfDocument is not present");
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.image;
    }

    private boolean isSvgImage(String typeAttribute) {
        return typeAttribute.equals("image/svg+xml");
    }
}

