/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.jsoup.select;

import com.itextpdf.html2pdf.jsoup.helper.Validate;
import com.itextpdf.html2pdf.jsoup.nodes.Element;
import com.itextpdf.html2pdf.jsoup.select.Collector;
import com.itextpdf.html2pdf.jsoup.select.Elements;
import com.itextpdf.html2pdf.jsoup.select.Evaluator;
import com.itextpdf.html2pdf.jsoup.select.QueryParser;
import com.itextpdf.io.util.MessageFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;

public class Selector {
    private final Evaluator evaluator;
    private final Element root;

    private Selector(String query, Element root) {
        Validate.notNull(query);
        query = query.trim();
        Validate.notEmpty(query);
        Validate.notNull(root);
        this.evaluator = QueryParser.parse(query);
        this.root = root;
    }

    private Selector(Evaluator evaluator, Element root) {
        Validate.notNull(evaluator);
        Validate.notNull(root);
        this.evaluator = evaluator;
        this.root = root;
    }

    public static Elements select(String query, Element root) {
        return new Selector(query, root).select();
    }

    public static Elements select(Evaluator evaluator, Element root) {
        return new Selector(evaluator, root).select();
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty(query);
        Validate.notNull(roots);
        Evaluator evaluator = QueryParser.parse(query);
        ArrayList<Element> elements = new ArrayList<Element>();
        IdentityHashMap<Element, Boolean> seenElements = new IdentityHashMap<Element, Boolean>();
        for (Element root : roots) {
            Elements found = Selector.select(evaluator, root);
            for (Element el : found) {
                if (seenElements.containsKey(el)) continue;
                elements.add(el);
                seenElements.put(el, Boolean.TRUE);
            }
        }
        return new Elements((List<Element>)elements);
    }

    private Elements select() {
        return Collector.collect(this.evaluator, this.root);
    }

    static Elements filterOut(Collection<Element> elements, Collection<Element> outs) {
        Elements output = new Elements();
        for (Element el : elements) {
            boolean found = false;
            for (Element out : outs) {
                if (!el.equals(out)) continue;
                found = true;
                break;
            }
            if (found) continue;
            output.add(el);
        }
        return output;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg, Object ... params) {
            super(MessageFormatUtil.format((String)msg, (Object[])params));
        }
    }
}

