/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.resolver.resource.UriResolver;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.property.Transform;
import java.net.MalformedURLException;

public class ATagWorker
extends SpanTagWorker {
    public ATagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processEnd(element, context);
        String url = element.getAttribute("href");
        if (url != null) {
            String base = context.getBaseUri();
            if (base != null) {
                UriResolver uriResolver = new UriResolver(base);
                if (!url.startsWith("#") || !uriResolver.isLocalBaseUri()) {
                    try {
                        String resolvedUri = uriResolver.resolveAgainstBaseUri(url).toExternalForm();
                        if (!url.endsWith("/") && resolvedUri.endsWith("/")) {
                            resolvedUri = resolvedUri.substring(0, resolvedUri.length() - 1);
                        }
                        if (!resolvedUri.startsWith("file:")) {
                            url = resolvedUri;
                        }
                    }
                    catch (MalformedURLException resolvedUri) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < this.getAllElements().size(); ++i) {
                if (this.getAllElements().get(i) instanceof IBlockElement) {
                    Div simulatedDiv = new Div();
                    simulatedDiv.getAccessibilityProperties().setRole("Link");
                    Transform cssTransform = (Transform)this.getAllElements().get(i).getProperty(53);
                    if (cssTransform != null) {
                        this.getAllElements().get(i).deleteOwnProperty(53);
                        simulatedDiv.setProperty(53, (Object)cssTransform);
                    }
                    simulatedDiv.add((IBlockElement)this.getAllElements().get(i));
                    this.getAllElements().set(i, (IPropertyContainer)simulatedDiv);
                }
                LinkHelper.applyLinkAnnotation(this.getAllElements().get(i), url);
            }
        }
        if (!this.getAllElements().isEmpty()) {
            String name = element.getAttribute("name");
            IPropertyContainer firstElement = this.getAllElements().get(0);
            firstElement.setProperty(17, (Object)name);
        }
    }
}

