/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTextFieldRenderer
extends AbstractFormFieldRenderer {
    protected PdfFont font;

    AbstractTextFieldRenderer(IFormField modelElement) {
        super(modelElement);
    }

    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.trim().isEmpty()) {
            defaultValue = "\u00a0";
        }
        Paragraph paragraph = (Paragraph)new Paragraph(defaultValue).setMargin(0.0f);
        Leading leading = (Leading)this.getProperty(33);
        if (leading != null) {
            paragraph.setProperty(33, (Object)leading);
        }
        return paragraph.createRendererSubTree();
    }

    void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, int linesNumber) {
        float averageLineHeight = bBox.getHeight() / (float)lines.size();
        if (lines.size() != linesNumber) {
            float actualHeight = averageLineHeight * (float)linesNumber;
            bBox.moveUp(bBox.getHeight() - actualHeight);
            bBox.setHeight(actualHeight);
        }
        if (lines.size() > linesNumber) {
            ArrayList<LineRenderer> subList = new ArrayList<LineRenderer>(lines.subList(0, linesNumber));
            lines.clear();
            lines.addAll(subList);
        }
    }

    void applyDefaultFieldProperties(PdfFormField inputField) {
        ((PdfWidgetAnnotation)inputField.getWidgets().get(0)).setHighlightMode(PdfAnnotation.HIGHLIGHT_NONE);
        inputField.setBorderWidth(0.0f);
        TransparentColor color = this.getPropertyAsTransparentColor(21);
        if (color != null) {
            inputField.setColor(color.getColor());
        }
    }

    void updatePdfFont(ParagraphRenderer renderer) {
        Object retrievedFont;
        List lines;
        if (renderer != null && (lines = renderer.getLines()) != null) {
            for (LineRenderer line : lines) {
                for (IRenderer child : line.getChildRenderers()) {
                    retrievedFont = child.getProperty(20);
                    if (!(retrievedFont instanceof PdfFont)) continue;
                    this.font = (PdfFont)retrievedFont;
                    return;
                }
            }
        }
        if ((retrievedFont = renderer.getProperty(20)) instanceof PdfFont) {
            this.font = (PdfFont)retrievedFont;
        }
    }
}

