/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormFieldRenderer
extends BlockRenderer
implements ILeafElementRenderer {
    protected IRenderer flatRenderer;

    AbstractFormFieldRenderer(IFormField modelElement) {
        super((IElement)modelElement);
    }

    public boolean isFlatten() {
        Boolean flatten = this.getPropertyAsBoolean(0x100003);
        return flatten != null ? flatten.booleanValue() : ((Boolean)this.modelElement.getDefaultProperty(0x100003)).booleanValue();
    }

    public String getDefaultValue() {
        String defaultValue = (String)this.getProperty(0x100005);
        return defaultValue != null ? defaultValue : (String)this.modelElement.getDefaultProperty(0x100005);
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        return this.layout(layoutContext, false);
    }

    public void draw(DrawContext drawContext) {
        if (this.flatRenderer != null) {
            super.draw(drawContext);
        }
    }

    public void drawChildren(DrawContext drawContext) {
        drawContext.getCanvas().saveState();
        boolean flatten = this.isFlatten();
        if (flatten) {
            drawContext.getCanvas().rectangle(this.occupiedArea.getBBox()).clip().newPath();
            this.flatRenderer.draw(drawContext);
        } else {
            this.applyAcroField(drawContext);
        }
        drawContext.getCanvas().restoreState();
    }

    protected MinMaxWidth getMinMaxWidth() {
        MinMaxWidthLayoutResult result = (MinMaxWidthLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))), true);
        return result.getMinMaxWidth();
    }

    protected abstract void adjustFieldLayout();

    protected abstract IRenderer createFlatRenderer();

    protected abstract void applyAcroField(DrawContext var1);

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    protected boolean isRendererFit(float availableWidth, float availableHeight) {
        if (this.occupiedArea == null) {
            return false;
        }
        return availableHeight >= this.occupiedArea.getBBox().getHeight() && availableWidth >= this.occupiedArea.getBBox().getWidth();
    }

    protected Float getContentWidth() {
        UnitValue width = (UnitValue)this.getProperty(77);
        if (width != null) {
            if (width.isPointValue()) {
                return this.retrieveWidth(0.0f);
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Input field supports only point width");
        }
        return null;
    }

    private LayoutResult layout(LayoutContext layoutContext, boolean minMaxWidth) {
        this.childRenderers.clear();
        this.flatRenderer = null;
        float parentWidth = layoutContext.getArea().getBBox().getWidth();
        float parentHeight = layoutContext.getArea().getBBox().getHeight();
        UnitValue maxHeight = (UnitValue)this.getProperty(84);
        UnitValue height = (UnitValue)this.getProperty(27);
        boolean restoreMaxHeight = this.hasOwnProperty(84);
        boolean restoreHeight = this.hasOwnProperty(27);
        this.setProperty(84, null);
        this.setProperty(27, null);
        IRenderer renderer = this.createFlatRenderer();
        Float width = this.getContentWidth();
        if (width != null) {
            renderer.setProperty(77, (Object)new UnitValue(1, width.floatValue()));
        }
        this.addChild(renderer);
        Rectangle bBox = layoutContext.getArea().getBBox().clone().moveDown(1000000.0f - parentHeight).setHeight(1000000.0f);
        layoutContext.getArea().setBBox(bBox);
        LayoutResult result = super.layout(layoutContext);
        if (restoreMaxHeight) {
            this.setProperty(84, maxHeight);
        } else {
            this.deleteOwnProperty(84);
        }
        if (restoreHeight) {
            this.setProperty(27, height);
        } else {
            this.deleteOwnProperty(27);
        }
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && result.getStatus() != 1) {
            FloatPropertyValue floatPropertyValue = (FloatPropertyValue)this.getProperty(99);
            if (floatPropertyValue == null || floatPropertyValue == FloatPropertyValue.NONE) {
                this.setProperty(26, true);
            } else {
                this.flatRenderer = (IRenderer)this.childRenderers.get(0);
                this.childRenderers.clear();
                LayoutArea flatRendererOccupiedArea = this.flatRenderer.getOccupiedArea();
                this.applyPaddings(flatRendererOccupiedArea.getBBox(), true);
                this.applyBorderBox(flatRendererOccupiedArea.getBBox(), true);
                this.applyMargins(flatRendererOccupiedArea.getBBox(), true);
                this.childRenderers.add(this.flatRenderer);
                this.adjustFieldLayout();
                this.occupiedArea.setBBox(this.flatRenderer.getOccupiedArea().getBBox().clone());
            }
            return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth());
        }
        if (!this.childRenderers.isEmpty()) {
            this.flatRenderer = (IRenderer)this.childRenderers.get(0);
            this.childRenderers.clear();
            this.childRenderers.add(this.flatRenderer);
            this.adjustFieldLayout();
            Rectangle fBox = this.flatRenderer.getOccupiedArea().getBBox();
            this.occupiedArea.getBBox().setX(fBox.getX()).setY(fBox.getY()).setWidth(fBox.getWidth()).setHeight(fBox.getHeight());
            this.applyPaddings(this.occupiedArea.getBBox(), true);
            this.applyBorderBox(this.occupiedArea.getBBox(), true);
            this.applyMargins(this.occupiedArea.getBBox(), true);
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot layout form field field. It won't be displayed");
            this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
        }
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && !this.isRendererFit(parentWidth, parentHeight)) {
            if (!minMaxWidth) {
                this.setProperty(26, true);
                this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
                return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth());
            }
            return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth(this.occupiedArea.getBBox().getWidth(), this.occupiedArea.getBBox().getWidth(), 0.0f));
        }
        if (result.getStatus() != 1 || !this.isRendererFit(parentWidth, parentHeight)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Input field doesn't fit in outer object. It will be clipped");
        }
        return new MinMaxWidthLayoutResult(1, this.occupiedArea, (IRenderer)this, null).setMinMaxWidth(new MinMaxWidth(this.occupiedArea.getBBox().getWidth(), this.occupiedArea.getBBox().getWidth(), 0.0f));
    }
}

