/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreak;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreakType;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProcessor;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProperties;
import com.itextpdf.html2pdf.css.resolve.ICssResolver;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.List;

public class HtmlDocumentRenderer
extends DocumentRenderer {
    private static final boolean TRIM_LAST_BLANK_PAGE = true;
    private PageContextProcessor firstPageProc;
    private PageContextProcessor leftPageProc;
    private PageContextProcessor rightPageProc;
    private boolean currentPageEven = true;
    private IRenderer waitingElement;
    private boolean shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = true;
    private boolean anythingAddedToCurrentArea = false;
    private int estimatedNumberOfPages;

    public HtmlDocumentRenderer(Document document, boolean immediateFlush) {
        super(document, immediateFlush);
    }

    public void processPageRules(INode rootNode, ICssResolver cssResolver, ProcessorContext context) {
        PageContextProperties firstPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "first", "right");
        PageContextProperties leftPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "left");
        PageContextProperties rightPageProps = PageContextProperties.resolve(rootNode, cssResolver, context.getCssContext(), "right");
        PageSize defaultPageSize = this.document.getPdfDocument().getDefaultPageSize();
        this.firstPageProc = new PageContextProcessor(firstPageProps, context, defaultPageSize);
        this.leftPageProc = new PageContextProcessor(leftPageProps, context, defaultPageSize);
        this.rightPageProc = new PageContextProcessor(rightPageProps, context, defaultPageSize);
    }

    public void addChild(IRenderer renderer) {
        if (this.waitingElement != null) {
            if (Boolean.TRUE.equals(renderer.getProperty(0x100001))) {
                this.waitingElement.setProperty(81, (Object)true);
            }
            super.addChild(this.waitingElement);
            this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
            this.waitingElement = null;
        }
        this.waitingElement = renderer;
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)renderer.getProperty(99);
        Integer position = (Integer)renderer.getProperty(52);
        if (position != null && position == 3 || floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE)) {
            this.waitingElement = null;
            super.addChild(renderer);
        }
    }

    public void close() {
        PdfPage lastPage;
        if (this.waitingElement != null) {
            IRenderer r = this.waitingElement;
            this.waitingElement = null;
            super.addChild(r);
        }
        super.close();
        PdfDocument pdfDocument = this.document.getPdfDocument();
        if (pdfDocument.getNumberOfPages() > 1 && (lastPage = pdfDocument.getLastPage()).getContentStreamCount() == 1 && lastPage.getContentStream(0).getOutputStream().getCurrentPos() <= 0L) {
            pdfDocument.removePage(pdfDocument.getNumberOfPages());
        }
    }

    public IRenderer getNextRenderer() {
        if (this.waitingElement != null) {
            super.addChild(this.waitingElement);
            this.waitingElement = null;
        }
        HtmlDocumentRenderer relayoutRenderer = new HtmlDocumentRenderer(this.document, this.immediateFlush);
        relayoutRenderer.firstPageProc = this.firstPageProc;
        relayoutRenderer.leftPageProc = this.leftPageProc;
        relayoutRenderer.rightPageProc = this.rightPageProc;
        relayoutRenderer.estimatedNumberOfPages = this.currentPageNumber;
        return relayoutRenderer;
    }

    protected LayoutArea updateCurrentArea(LayoutResult overflowResult) {
        AreaBreak areaBreak;
        AreaBreak areaBreak2 = areaBreak = overflowResult != null ? overflowResult.getAreaBreak() : null;
        if (areaBreak instanceof HtmlPageBreak) {
            HtmlPageBreakType htmlPageBreakType = ((HtmlPageBreak)areaBreak).getBreakType();
            if (this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement && this.currentArea != null && overflowResult.getStatus() == 3 && this.currentArea.isEmptyArea() && this.currentArea.getPageNumber() == 1) {
                this.document.getPdfDocument().removePage(1);
                this.currentPageNumber = 0;
                overflowResult = null;
                this.currentArea = null;
                this.shouldTrimFirstBlankPagesCausedByBreakBeforeFirstElement = false;
                if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType) && this.isCurrentPageLeft() || HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType) && this.isCurrentPageRight()) {
                    this.currentPageEven = !this.currentPageEven;
                }
            }
            boolean bl = this.anythingAddedToCurrentArea = this.anythingAddedToCurrentArea || overflowResult != null && overflowResult.getStatus() == 2;
            if (HtmlPageBreakType.ALWAYS.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || this.currentArea == null) {
                    nextArea = super.updateCurrentArea(overflowResult);
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.LEFT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || !this.isCurrentPageLeft() || this.currentArea == null) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isCurrentPageLeft());
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
            if (HtmlPageBreakType.RIGHT.equals((Object)htmlPageBreakType)) {
                RootLayoutArea nextArea = this.currentArea;
                if (this.anythingAddedToCurrentArea || !this.isCurrentPageRight() || this.currentArea == null) {
                    do {
                        nextArea = super.updateCurrentArea(overflowResult);
                    } while (!this.isCurrentPageRight());
                }
                this.anythingAddedToCurrentArea = false;
                return nextArea;
            }
        }
        this.anythingAddedToCurrentArea = false;
        return super.updateCurrentArea(overflowResult);
    }

    protected void shrinkCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (renderer != null) {
            this.anythingAddedToCurrentArea = true;
        }
        super.shrinkCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
    }

    protected PageSize addNewPage(PageSize customPageSize) {
        int numberOfPages = this.document.getPdfDocument().getNumberOfPages();
        PageContextProcessor nextProcessor = this.getNextPageProcessor(numberOfPages == 0);
        PdfPage addedPage = customPageSize != null ? this.document.getPdfDocument().addNewPage(customPageSize) : this.document.getPdfDocument().addNewPage(nextProcessor.getPageSize());
        this.currentPageEven = !this.currentPageEven;
        nextProcessor.processNewPage(addedPage, this);
        float[] margins = nextProcessor.computeLayoutMargins();
        this.document.setMargins(margins[0], margins[1], margins[2], margins[3]);
        return new PageSize(addedPage.getTrimBox());
    }

    int getEstimatedNumberOfPages() {
        return this.estimatedNumberOfPages;
    }

    private PageContextProcessor getNextPageProcessor(boolean firstPage) {
        if (firstPage && this.currentPageEven) {
            return this.firstPageProc;
        }
        if (this.isCurrentPageRight()) {
            return this.leftPageProc;
        }
        return this.rightPageProc;
    }

    private boolean isCurrentPageLeft() {
        return this.currentPageEven;
    }

    private boolean isCurrentPageRight() {
        return !this.isCurrentPageLeft();
    }
}

