/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.resolver.resource;

import com.itextpdf.html2pdf.resolver.resource.SimpleImageCache;
import com.itextpdf.html2pdf.resolver.resource.UriResolver;
import com.itextpdf.io.codec.Base64;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolver {
    private UriResolver uriResolver;
    private SimpleImageCache imageCache;

    public ResourceResolver(String baseUri) {
        this.uriResolver = new UriResolver(baseUri);
        this.imageCache = new SimpleImageCache();
    }

    public PdfImageXObject retrieveImage(String src) {
        if (src == null) {
            return null;
        }
        if (src.contains("base64")) {
            try {
                String fixedSrc = src.replaceAll("\\s", "");
                fixedSrc = fixedSrc.substring(fixedSrc.indexOf("base64") + 7);
                PdfImageXObject imageXObject = this.imageCache.getImage(fixedSrc);
                if (imageXObject == null) {
                    imageXObject = new PdfImageXObject(ImageDataFactory.create((byte[])Base64.decode((String)fixedSrc)));
                    this.imageCache.putImage(fixedSrc, imageXObject);
                }
                return imageXObject;
            }
            catch (Exception fixedSrc) {
                // empty catch block
            }
        }
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(src);
            url = UrlUtil.getFinalURL((URL)url);
            String imageResolvedSrc = url.toExternalForm();
            PdfImageXObject imageXObject = this.imageCache.getImage(imageResolvedSrc);
            if (imageXObject == null) {
                imageXObject = new PdfImageXObject(ImageDataFactory.create((URL)url));
                this.imageCache.putImage(imageResolvedSrc, imageXObject);
            }
            return imageXObject;
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ResourceResolver.class);
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve image with given base URI ({0}) and image source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    public InputStream retrieveStyleSheet(String uri) throws IOException {
        return this.uriResolver.resolveAgainstBaseUri(uri).openStream();
    }

    public byte[] retrieveStream(String src) {
        if (src.contains("base64")) {
            try {
                String fixedSrc = src.replaceAll("\\s", "");
                fixedSrc = fixedSrc.substring(fixedSrc.indexOf("base64") + 7);
                return Base64.decode((String)fixedSrc);
            }
            catch (Exception fixedSrc) {
                // empty catch block
            }
        }
        try {
            return StreamUtil.inputStreamToArray((InputStream)this.uriResolver.resolveAgainstBaseUri(src).openStream());
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ResourceResolver.class);
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    public URL resolveAgainstBaseUri(String uri) throws MalformedURLException {
        return this.uriResolver.resolveAgainstBaseUri(uri);
    }

    public void resetCache() {
        this.imageCache.reset();
    }
}

