/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.util;

import com.itextpdf.html2pdf.css.util.CssPropertyNormalizer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.color.WebColors;
import com.itextpdf.layout.property.UnitValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssUtils {
    private static final String[] METRIC_MEASUREMENTS = new String[]{"px", "in", "cm", "mm", "pc", "pt"};
    private static final String[] RELATIVE_MEASUREMENTS = new String[]{"%", "em", "ex", "rem"};

    private CssUtils() {
    }

    public static String normalizeCssProperty(String str) {
        return str == null ? null : CssPropertyNormalizer.normalize(str);
    }

    public static String removeDoubleSpacesAndTrim(String str) {
        String[] parts = str.split("\\s");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static Integer parseInteger(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static Float parseFloat(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Float.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static int[] parseAspectRatio(String str) {
        int indexOfSlash = str.indexOf(47);
        try {
            int first = Integer.valueOf(str.substring(0, indexOfSlash));
            int second = Integer.valueOf(str.substring(indexOfSlash + 1));
            return new int[]{first, second};
        }
        catch (NullPointerException | NumberFormatException exc) {
            return null;
        }
    }

    public static float parseAbsoluteLength(String length, String defaultMetric) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(length);
        if (pos == 0) {
            return 0.0f;
        }
        float f = Float.parseFloat(length.substring(0, pos));
        String unit = length.substring(pos);
        if (unit.startsWith("pt") || unit.equals("") && defaultMetric.equals("pt")) {
            return f;
        }
        if (unit.startsWith("in") || unit.equals("") && defaultMetric.equals("in")) {
            return f * 72.0f;
        }
        if (unit.startsWith("cm") || unit.equals("") && defaultMetric.equals("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (unit.startsWith("q") || unit.equals("") && defaultMetric.equals("q")) {
            return f / 2.54f * 72.0f / 40.0f;
        }
        if (unit.startsWith("mm") || unit.equals("") && defaultMetric.equals("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (unit.startsWith("pc") || unit.equals("") && defaultMetric.equals("pc")) {
            return f * 12.0f;
        }
        if (unit.startsWith("px") || unit.equals("") && defaultMetric.equals("px")) {
            return f * 0.75f;
        }
        Logger logger = LoggerFactory.getLogger(CssUtils.class);
        logger.error(MessageFormatUtil.format((String)"Unknown absolute metric length parsed \"{0}\".", (Object[])new Object[]{unit.equals("") ? defaultMetric : unit}));
        return f;
    }

    public static float parseAbsoluteLength(String length) {
        return CssUtils.parseAbsoluteLength(length, "px");
    }

    public static float parseRelativeValue(String relativeValue, float baseValue) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(relativeValue);
        if (pos == 0) {
            return 0.0f;
        }
        double f = Double.parseDouble(relativeValue.substring(0, pos));
        String unit = relativeValue.substring(pos);
        if (unit.startsWith("%")) {
            f = (double)baseValue * f / 100.0;
        } else if (unit.startsWith("em") || unit.startsWith("rem")) {
            f = (double)baseValue * f;
        } else if (unit.startsWith("ex")) {
            f = (double)baseValue * f / 2.0;
        }
        return (float)f;
    }

    public static UnitValue parseLengthValueToPt(String value, float emValue, float remValue) {
        if (CssUtils.isMetricValue(value) || CssUtils.isNumericValue(value)) {
            return new UnitValue(1, CssUtils.parseAbsoluteLength(value));
        }
        if (value != null && value.endsWith("%")) {
            return new UnitValue(2, Float.parseFloat(value.substring(0, value.length() - 1)));
        }
        if (CssUtils.isRemValue(value)) {
            return new UnitValue(1, CssUtils.parseRelativeValue(value, remValue));
        }
        if (CssUtils.isRelativeValue(value)) {
            return new UnitValue(1, CssUtils.parseRelativeValue(value, emValue));
        }
        return null;
    }

    public static float parseResolution(String resolutionStr) {
        int pos = CssUtils.determinePositionBetweenValueAndUnit(resolutionStr);
        if (pos == 0) {
            return 0.0f;
        }
        float f = Float.parseFloat(resolutionStr.substring(0, pos));
        String unit = resolutionStr.substring(pos);
        if (unit.startsWith("dpcm")) {
            f *= 2.54f;
        } else if (unit.startsWith("dppx")) {
            f *= 96.0f;
        }
        return f;
    }

    private static int determinePositionBetweenValueAndUnit(String string) {
        int pos;
        if (string == null) {
            return 0;
        }
        for (pos = 0; pos < string.length() && (string.charAt(pos) == '+' || string.charAt(pos) == '-' || string.charAt(pos) == '.' || string.charAt(pos) >= '0' && string.charAt(pos) <= '9'); ++pos) {
        }
        return pos;
    }

    public static boolean isColorProperty(String value) {
        return value.contains("rgb(") || value.contains("rgba(") || value.contains("#") || WebColors.NAMES.containsKey((Object)value.toLowerCase()) || "transparent".equals(value);
    }

    public static float[] parseRgbaColor(String colorValue) {
        float[] rgbaColor = WebColors.getRGBAColor((String)colorValue);
        if (rgbaColor == null) {
            Logger logger = LoggerFactory.getLogger(CssUtils.class);
            logger.error(MessageFormatUtil.format((String)"Color \"{0}\" was not parsed. It has invalid value. Defaulting to black color.", (Object[])new Object[]{colorValue}));
            rgbaColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        return rgbaColor;
    }

    public static boolean isMetricValue(String value) {
        if (value == null) {
            return false;
        }
        for (String metricPostfix : METRIC_MEASUREMENTS) {
            if (!value.endsWith(metricPostfix) || !CssUtils.isNumericValue(value.substring(0, value.length() - metricPostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRelativeValue(String value) {
        if (value == null) {
            return false;
        }
        for (String relativePostfix : RELATIVE_MEASUREMENTS) {
            if (!value.endsWith(relativePostfix) || !CssUtils.isNumericValue(value.substring(0, value.length() - relativePostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemValue(String value) {
        return value != null && value.endsWith("rem") && CssUtils.isNumericValue(value.substring(0, value.length() - "rem".length()).trim());
    }

    public static boolean isNumericValue(String value) {
        return value != null && (value.matches("^[-+]?\\d\\d*\\.\\d*$") || value.matches("^[-+]?\\d\\d*$") || value.matches("^[-+]?\\.\\d\\d*$"));
    }

    public static String extractUrl(String url) {
        String urlString;
        String str = null;
        str = url.startsWith("url") ? ((urlString = url.substring(3).trim().replace("(", "").replace(")", "").trim()).startsWith("'") && urlString.endsWith("'") ? urlString.substring(urlString.indexOf("'") + 1, urlString.lastIndexOf("'")) : (urlString.startsWith("\"") && urlString.endsWith("\"") ? urlString.substring(urlString.indexOf(34) + 1, urlString.lastIndexOf(34)) : urlString)) : url;
        return str;
    }

    public static boolean isBase64Data(String data) {
        return data.matches("^data:([^\\s]*);base64,([^\\s]*)");
    }

    public static int findNextUnescapedChar(String source, char ch, int startIndex) {
        int afterNoneEscapePos;
        int symbolPos = source.indexOf(ch, startIndex);
        if (symbolPos == -1) {
            return -1;
        }
        for (afterNoneEscapePos = symbolPos; afterNoneEscapePos > 0 && source.charAt(afterNoneEscapePos - 1) == '\\'; --afterNoneEscapePos) {
        }
        return (symbolPos - afterNoneEscapePos) % 2 == 0 ? symbolPos : CssUtils.findNextUnescapedChar(source, ch, symbolPos + 1);
    }
}

