/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class CheckBoxFormFieldBuilder
extends TerminalFormFieldBuilder<CheckBoxFormFieldBuilder> {
    private CheckBoxType checkType = CheckBoxType.CROSS;

    public CheckBoxFormFieldBuilder(PdfDocument document, String formFieldName) {
        super(document, formFieldName);
    }

    public CheckBoxType getCheckType() {
        return this.checkType;
    }

    public CheckBoxFormFieldBuilder setCheckType(CheckBoxType checkType) {
        this.checkType = checkType;
        return this;
    }

    public PdfButtonFormField createCheckBox() {
        PdfButtonFormField check;
        if (this.getWidgetRectangle() == null) {
            check = PdfFormCreator.createButtonFormField(this.getDocument());
        } else {
            PdfWidgetAnnotation annotation = new PdfWidgetAnnotation(this.getWidgetRectangle());
            annotation.setAppearanceState(new PdfName("Off"));
            if (this.getGenericConformanceLevel() != null) {
                annotation.setFlag(4);
            }
            check = PdfFormCreator.createButtonFormField(annotation, this.getDocument());
        }
        check.disableFieldRegeneration();
        check.pdfConformanceLevel = this.getGenericConformanceLevel();
        check.setCheckType(this.checkType);
        check.setFieldName(this.getFormFieldName());
        check.setFontSize(0);
        check.put(PdfName.V, (PdfObject)new PdfName("Off"));
        if (this.getWidgetRectangle() != null) {
            this.setPageToField(check);
        }
        check.enableFieldRegeneration();
        return check;
    }

    @Override
    protected CheckBoxFormFieldBuilder getThis() {
        return this;
    }
}

