/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.itextpdf.commons.exceptions.ITextException;
import com.itextpdf.commons.json.JsonValue;
import com.itextpdf.commons.json.JsonValueDeserializer;
import com.itextpdf.commons.json.JsonValueSerializer;
import com.itextpdf.commons.utils.MessageFormatUtil;

final class JsonValueConverter {
    private JsonValueConverter() {
    }

    static String toJson(JsonValue value) {
        try {
            return JsonValueConverter.createObjectMapper().writer().writeValueAsString((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new ITextException(MessageFormatUtil.format("Failed to serialize json into string: {0}", e.getMessage()));
        }
    }

    static JsonValue fromJson(String json) {
        try {
            return (JsonValue)JsonValueConverter.createObjectMapper().readValue(json, JsonValue.class);
        }
        catch (JsonProcessingException e) {
            throw new ITextException(MessageFormatUtil.format("Failed to parse json string: {0}", e.getMessage()));
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonValue.class, (JsonSerializer)new JsonValueSerializer());
        module.addDeserializer(JsonValue.class, (JsonDeserializer)new JsonValueDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }
}

