/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.BezierCurve;
import com.itextpdf.kernel.geom.IShape;
import com.itextpdf.kernel.geom.Line;
import com.itextpdf.kernel.geom.LineSegment;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Path;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Subpath;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfTextArray;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.ClipperBridge;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.ClipperOffset;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.DefaultClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.LongRect;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Paths;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyTree;
import com.itextpdf.kernel.pdf.canvas.parser.data.ImageRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.PathRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.pdfcleanup.FilteredImagesCache;
import com.itextpdf.pdfcleanup.LineDashPattern;
import com.itextpdf.pdfcleanup.PdfCleanUpTool;
import com.itextpdf.pdfcleanup.util.CleanUpHelperUtil;
import com.itextpdf.pdfcleanup.util.CleanUpImageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfCleanUpFilter {
    private static final Logger logger = LoggerFactory.getLogger(PdfCleanUpFilter.class);
    private static final double CIRCLE_APPROXIMATION_CONST = 0.55191502449;
    private static final float EPS = 1.0E-4f;
    private static final Set<PdfName> NOT_SUPPORTED_FILTERS_FOR_DIRECT_CLEANUP = Collections.unmodifiableSet(new LinkedHashSet<PdfName>(Arrays.asList(PdfName.JBIG2Decode, PdfName.DCTDecode, PdfName.JPXDecode)));
    private List<Rectangle> regions;

    public PdfCleanUpFilter(List<Rectangle> regions) {
        this.regions = regions;
    }

    static boolean imageSupportsDirectCleanup(PdfImageXObject image) {
        PdfObject filter = ((PdfStream)image.getPdfObject()).get(PdfName.Filter);
        boolean supportedFilterForDirectCleanup = PdfCleanUpFilter.isSupportedFilterForDirectImageCleanup(filter);
        boolean deviceGrayOrNoCS = PdfName.DeviceGray.equals((Object)((PdfStream)image.getPdfObject()).getAsName(PdfName.ColorSpace)) || !((PdfStream)image.getPdfObject()).containsKey(PdfName.ColorSpace);
        return deviceGrayOrNoCS && supportedFilterForDirectCleanup;
    }

    static boolean checkIfRectanglesIntersect(Point[] rect1, Point[] rect2) {
        DefaultClipper clipper = new DefaultClipper();
        if (!ClipperBridge.addPolygonToClipper((IClipper)clipper, (Point[])rect2, (IClipper.PolyType)IClipper.PolyType.CLIP)) {
            if (!ClipperBridge.addPolygonToClipper((IClipper)clipper, (Point[])rect1, (IClipper.PolyType)IClipper.PolyType.SUBJECT)) {
                int i;
                if (!ClipperBridge.addPolylineSubjectToClipper((IClipper)clipper, (Point[])rect2)) {
                    return false;
                }
                if (rect1.length != rect2.length) {
                    return false;
                }
                Point startPoint = rect2[0];
                Point endPoint = rect2[0];
                for (i = 1; i < rect2.length; ++i) {
                    if (!(rect2[i].distance(startPoint) > (double)1.0E-4f)) continue;
                    endPoint = rect2[i];
                    break;
                }
                for (i = 0; i < rect1.length; ++i) {
                    if (!PdfCleanUpFilter.isPointOnALineSegment(rect1[i], startPoint, endPoint, true)) continue;
                    return true;
                }
            }
            return false;
        }
        boolean intersectionSubjectAdded = ClipperBridge.addPolygonToClipper((IClipper)clipper, (Point[])rect1, (IClipper.PolyType)IClipper.PolyType.SUBJECT);
        if (intersectionSubjectAdded) {
            Paths paths = new Paths();
            clipper.execute(IClipper.ClipType.INTERSECTION, paths, IClipper.PolyFillType.NON_ZERO, IClipper.PolyFillType.NON_ZERO);
            return !PdfCleanUpFilter.checkIfIntersectionRectangleDegenerate(paths.getBounds(), false) && !paths.isEmpty();
        }
        int rect1Size = rect1.length;
        intersectionSubjectAdded = ClipperBridge.addPolylineSubjectToClipper((IClipper)clipper, (Point[])rect1);
        if (!intersectionSubjectAdded) {
            double smallDiff = 0.01;
            ArrayList<Point> rect1List = new ArrayList<Point>(Arrays.asList(rect1));
            rect1List.add(new Point(rect1[0].getX() + smallDiff, rect1[0].getY()));
            rect1 = rect1List.toArray(new Point[rect1Size]);
            intersectionSubjectAdded = ClipperBridge.addPolylineSubjectToClipper((IClipper)clipper, (Point[])rect1);
            assert (intersectionSubjectAdded);
        }
        PolyTree polyTree = new PolyTree();
        clipper.execute(IClipper.ClipType.INTERSECTION, polyTree, IClipper.PolyFillType.NON_ZERO, IClipper.PolyFillType.NON_ZERO);
        Paths paths = Paths.makePolyTreeToPaths((PolyTree)polyTree);
        return !PdfCleanUpFilter.checkIfIntersectionRectangleDegenerate(paths.getBounds(), true) && !paths.isEmpty();
    }

    FilterResult<PdfArray> filterText(TextRenderInfo text) {
        PdfTextArray textArray = new PdfTextArray();
        if (this.isTextNotToBeCleaned(text)) {
            return new FilterResult<PdfArray>(false, new PdfArray((PdfObject)text.getPdfString()));
        }
        for (TextRenderInfo ri : text.getCharacterRenderInfos()) {
            if (this.isTextNotToBeCleaned(ri)) {
                textArray.add((PdfObject)ri.getPdfString());
                continue;
            }
            textArray.add((PdfObject)new PdfNumber((double)(-ri.getUnscaledWidth() * 1000.0f / (text.getFontSize() * text.getHorizontalScaling() / 100.0f))));
        }
        return new FilterResult<PdfTextArray>(true, textArray);
    }

    FilterResult<ImageData> filterImage(ImageRenderInfo image) {
        return PdfCleanUpFilter.filterImage(image.getImage(), this.getImageAreasToBeCleaned(image.getImageCtm()));
    }

    FilterResult<ImageData> filterImage(FilteredImagesCache.FilteredImageKey imageKey) {
        return PdfCleanUpFilter.filterImage(imageKey.getImageXObject(), imageKey.getCleanedAreas());
    }

    Path filterStrokePath(PathRenderInfo path) {
        PdfArray dashPattern = path.getLineDashPattern();
        LineDashPattern lineDashPattern = new LineDashPattern(dashPattern.getAsArray(0), dashPattern.getAsNumber(1).floatValue());
        return this.filterStrokePath(path.getPath(), path.getCtm(), path.getLineWidth(), path.getLineCapStyle(), path.getLineJoinStyle(), path.getMiterLimit(), lineDashPattern);
    }

    Path filterFillPath(PathRenderInfo path, int fillingRule) {
        return this.filterFillPath(path.getPath(), path.getCtm(), fillingRule);
    }

    FilteredImagesCache.FilteredImageKey createFilteredImageKey(PdfImageXObject image, Matrix imageCtm, PdfDocument document) {
        return FilteredImagesCache.createFilteredImageKey(image, this.getImageAreasToBeCleaned(imageCtm), document);
    }

    private Path filterFillPath(Path path, Matrix ctm, int fillingRule) {
        path.closeAllSubpaths();
        DefaultClipper clipper = new DefaultClipper();
        ClipperBridge.addPath((IClipper)clipper, (Path)path, (IClipper.PolyType)IClipper.PolyType.SUBJECT);
        for (Rectangle rectangle : this.regions) {
            try {
                Point[] transfRectVertices = PdfCleanUpFilter.transformPoints(ctm, true, PdfCleanUpFilter.getRectangleVertices(rectangle));
                ClipperBridge.addPolygonToClipper((IClipper)clipper, (Point[])transfRectVertices, (IClipper.PolyType)IClipper.PolyType.CLIP);
            }
            catch (PdfException e) {
                if (!(e.getCause() instanceof NoninvertibleTransformException)) {
                    throw e;
                }
                logger.error(MessageFormatUtil.format((String)"Failed to process a transformation matrix which is noninvertible. Some content may be placed not as expected.", (Object[])new Object[0]));
            }
        }
        IClipper.PolyFillType fillType = IClipper.PolyFillType.NON_ZERO;
        if (fillingRule == 2) {
            fillType = IClipper.PolyFillType.EVEN_ODD;
        }
        PolyTree resultTree = new PolyTree();
        clipper.execute(IClipper.ClipType.DIFFERENCE, resultTree, fillType, IClipper.PolyFillType.NON_ZERO);
        return ClipperBridge.convertToPath((PolyTree)resultTree);
    }

    private List<Rectangle> getImageAreasToBeCleaned(Matrix imageCtm) {
        Rectangle imageRect = PdfCleanUpFilter.calcImageRect(imageCtm);
        if (imageRect == null) {
            return null;
        }
        ArrayList<Rectangle> areasToBeCleaned = new ArrayList<Rectangle>();
        for (Rectangle region : this.regions) {
            Rectangle intersectionRect = PdfCleanUpFilter.getRectanglesIntersection(imageRect, region);
            if (intersectionRect == null) continue;
            if (imageRect.equalsWithEpsilon(intersectionRect)) {
                return null;
            }
            areasToBeCleaned.add(PdfCleanUpFilter.transformRectIntoImageCoordinates(intersectionRect, imageCtm));
        }
        return areasToBeCleaned;
    }

    private Path filterStrokePath(Path sourcePath, Matrix ctm, float lineWidth, int lineCapStyle, int lineJoinStyle, float miterLimit, LineDashPattern lineDashPattern) {
        Path path = sourcePath;
        IClipper.JoinType joinType = ClipperBridge.getJoinType((int)lineJoinStyle);
        IClipper.EndType endType = ClipperBridge.getEndType((int)lineCapStyle);
        if (lineDashPattern != null && !lineDashPattern.isSolid()) {
            path = LineDashPattern.applyDashPattern(path, lineDashPattern);
        }
        ClipperOffset offset = new ClipperOffset((double)miterLimit, PdfCleanUpTool.arcTolerance * PdfCleanUpTool.floatMultiplier);
        List degenerateSubpaths = ClipperBridge.addPath((ClipperOffset)offset, (Path)path, (IClipper.JoinType)joinType, (IClipper.EndType)endType);
        PolyTree resultTree = new PolyTree();
        offset.execute(resultTree, (double)lineWidth * PdfCleanUpTool.floatMultiplier / 2.0);
        Path offsetedPath = ClipperBridge.convertToPath((PolyTree)resultTree);
        if (degenerateSubpaths.size() > 0) {
            if (endType == IClipper.EndType.OPEN_ROUND) {
                List<Subpath> circles = PdfCleanUpFilter.convertToCircles(degenerateSubpaths, lineWidth / 2.0f);
                offsetedPath.addSubpaths(circles);
            } else if (endType == IClipper.EndType.OPEN_SQUARE && lineDashPattern != null) {
                List<Subpath> squares = PdfCleanUpFilter.convertToSquares(degenerateSubpaths, lineWidth, sourcePath);
                offsetedPath.addSubpaths(squares);
            }
        }
        return this.filterFillPath(offsetedPath, ctm, 1);
    }

    private boolean isTextNotToBeCleaned(TextRenderInfo renderInfo) {
        Point[] textRect = PdfCleanUpFilter.getTextRectangle(renderInfo);
        for (Rectangle region : this.regions) {
            Point[] redactRect = PdfCleanUpFilter.getRectangleVertices(region);
            if (!PdfCleanUpFilter.checkIfRectanglesIntersect(textRect, redactRect)) continue;
            return false;
        }
        return true;
    }

    private static FilterResult<ImageData> filterImage(PdfImageXObject image, List<Rectangle> imageAreasToBeCleaned) {
        byte[] filteredImageBytes;
        if (imageAreasToBeCleaned == null) {
            return new FilterResult<Object>(true, null);
        }
        if (imageAreasToBeCleaned.isEmpty()) {
            return new FilterResult<Object>(false, null);
        }
        if (PdfCleanUpFilter.imageSupportsDirectCleanup(image)) {
            byte[] imageStreamBytes = PdfCleanUpFilter.processImageDirectly(image, imageAreasToBeCleaned);
            PdfImageXObject tempImageClone = new PdfImageXObject((PdfStream)((PdfStream)image.getPdfObject()).clone());
            ((PdfStream)tempImageClone.getPdfObject()).setData(imageStreamBytes);
            filteredImageBytes = tempImageClone.getImageBytes();
        } else {
            byte[] originalImageBytes = image.getImageBytes();
            filteredImageBytes = CleanUpImageUtil.cleanUpImage(originalImageBytes, imageAreasToBeCleaned);
        }
        return new FilterResult<ImageData>(true, ImageDataFactory.create((byte[])filteredImageBytes));
    }

    private static boolean checkIfIntersectionRectangleDegenerate(LongRect rect, boolean isIntersectSubjectDegenerate) {
        float width = (float)((double)Math.abs(rect.left - rect.right) / ClipperBridge.floatMultiplier);
        float height = (float)((double)Math.abs(rect.top - rect.bottom) / ClipperBridge.floatMultiplier);
        return isIntersectSubjectDegenerate ? width < 1.0E-4f && height < 1.0E-4f : width < 1.0E-4f || height < 1.0E-4f;
    }

    private static boolean isPointOnALineSegment(Point currPoint, Point linePoint1, Point linePoint2, boolean isBetweenLinePoints) {
        double dxc = currPoint.x - linePoint1.x;
        double dyl = linePoint2.y - linePoint1.y;
        double dyc = currPoint.y - linePoint1.y;
        double dxl = linePoint2.x - linePoint1.x;
        double cross = dxc * dyl - dyc * dxl;
        if (Math.abs(cross) <= (double)1.0E-4f) {
            if (isBetweenLinePoints) {
                if (Math.abs(dxl) >= Math.abs(dyl)) {
                    return dxl > 0.0 ? linePoint1.x - (double)1.0E-4f <= currPoint.x && currPoint.x <= linePoint2.x + (double)1.0E-4f : linePoint2.x - (double)1.0E-4f <= currPoint.x && currPoint.x <= linePoint1.x + (double)1.0E-4f;
                }
                return dyl > 0.0 ? linePoint1.y - (double)1.0E-4f <= currPoint.y && currPoint.y <= linePoint2.y + (double)1.0E-4f : linePoint2.y - (double)1.0E-4f <= currPoint.y && currPoint.y <= linePoint1.y + (double)1.0E-4f;
            }
            return true;
        }
        return false;
    }

    private static boolean isSupportedFilterForDirectImageCleanup(PdfObject filter) {
        if (filter == null) {
            return true;
        }
        if (filter.isName()) {
            return !NOT_SUPPORTED_FILTERS_FOR_DIRECT_CLEANUP.contains((PdfName)filter);
        }
        if (filter.isArray()) {
            PdfArray filterArray = (PdfArray)filter;
            for (int i = 0; i < filterArray.size(); ++i) {
                if (!NOT_SUPPORTED_FILTERS_FOR_DIRECT_CLEANUP.contains(filterArray.getAsName(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static Rectangle calcImageRect(Matrix imageCtm) {
        if (imageCtm == null) {
            return null;
        }
        Point[] points = PdfCleanUpFilter.transformPoints(imageCtm, false, new Point(0, 0), new Point(0, 1), new Point(1, 0), new Point(1, 1));
        return Rectangle.calculateBBox(Arrays.asList(points));
    }

    private static Rectangle transformRectIntoImageCoordinates(Rectangle rect, Matrix imageCtm) {
        Point[] points = PdfCleanUpFilter.transformPoints(imageCtm, true, new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getLeft(), (double)rect.getTop()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop()));
        return Rectangle.calculateBBox(Arrays.asList(points));
    }

    private static byte[] processImageDirectly(PdfImageXObject image, List<Rectangle> imageAreasToBeCleaned) {
        int X = 0;
        int Y = 1;
        int W = 2;
        int H = 3;
        byte[] originalImageBytes = ((PdfStream)image.getPdfObject()).getBytes();
        PdfNumber bpcVal = ((PdfStream)image.getPdfObject()).getAsNumber(PdfName.BitsPerComponent);
        if (bpcVal == null) {
            throw new IllegalArgumentException("/BitsPerComponent entry is required for image dictionaries.");
        }
        int bpc = bpcVal.intValue();
        if (bpc != 1 && bpc != 2 && bpc != 4 && bpc != 8 && bpc != 16) {
            throw new IllegalArgumentException("/BitsPerComponent only allowed values are: 1, 2, 4, 8 and 16.");
        }
        double bytesInComponent = (double)bpc / 8.0;
        int firstComponentInByte = 0;
        if (bpc < 16) {
            for (int i = 0; i < bpc; ++i) {
                firstComponentInByte += (int)Math.pow(2.0, 7 - i);
            }
        }
        double width = image.getWidth();
        double height = image.getHeight();
        int rowPadding = 0;
        if (width * (double)bpc % 8.0 > 0.0) {
            rowPadding = (int)(8.0 - width * (double)bpc % 8.0);
        }
        for (Rectangle rect : imageAreasToBeCleaned) {
            int[] cleanImgRect = CleanUpHelperUtil.getImageRectToClean(rect, (int)width, (int)height);
            for (int j = cleanImgRect[Y]; j < cleanImgRect[Y] + cleanImgRect[H]; ++j) {
                for (int i = cleanImgRect[X]; i < cleanImgRect[X] + cleanImgRect[W]; ++i) {
                    double pixelPos = (double)j * ((width * (double)bpc + (double)rowPadding) / 8.0) + (double)i * bytesInComponent;
                    int pixelByteInd = (int)pixelPos;
                    byte byteWithSample = originalImageBytes[pixelByteInd];
                    if (bpc == 16) {
                        originalImageBytes[pixelByteInd] = 0;
                        originalImageBytes[pixelByteInd + 1] = 0;
                        continue;
                    }
                    int reset = ~(firstComponentInByte >> (int)((pixelPos - (double)pixelByteInd) * 8.0)) & 0xFF;
                    originalImageBytes[pixelByteInd] = (byte)(byteWithSample & reset);
                }
            }
        }
        return originalImageBytes;
    }

    private static List<Subpath> convertToCircles(List<Subpath> degenerateSubpaths, double radius) {
        ArrayList<Subpath> circles = new ArrayList<Subpath>(degenerateSubpaths.size());
        for (Subpath subpath : degenerateSubpaths) {
            BezierCurve[] circleSectors = PdfCleanUpFilter.approximateCircle(subpath.getStartPoint(), radius);
            Subpath circle = new Subpath();
            circle.addSegment((IShape)circleSectors[0]);
            circle.addSegment((IShape)circleSectors[1]);
            circle.addSegment((IShape)circleSectors[2]);
            circle.addSegment((IShape)circleSectors[3]);
            circles.add(circle);
        }
        return circles;
    }

    private static List<Subpath> convertToSquares(List<Subpath> degenerateSubpaths, double squareWidth, Path sourcePath) {
        List<Point> pathApprox = PdfCleanUpFilter.getPathApproximation(sourcePath);
        if (pathApprox.size() < 2) {
            return Collections.emptyList();
        }
        Iterator<Point> approxIter = pathApprox.iterator();
        Point approxPt1 = approxIter.next();
        Point approxPt2 = approxIter.next();
        StandardLine line = new StandardLine(approxPt1, approxPt2);
        ArrayList<Subpath> squares = new ArrayList<Subpath>(degenerateSubpaths.size());
        float widthHalf = (float)squareWidth / 2.0f;
        for (Subpath subpath : degenerateSubpaths) {
            Point point = subpath.getStartPoint();
            while (!line.contains(point)) {
                approxPt1 = approxPt2;
                approxPt2 = approxIter.next();
                line = new StandardLine(approxPt1, approxPt2);
            }
            double slope = line.getSlope();
            double angle = slope != Double.POSITIVE_INFINITY ? Math.atan(slope) : 1.5707963267948966;
            squares.add(PdfCleanUpFilter.constructSquare(point, widthHalf, angle));
        }
        return squares;
    }

    private static List<Point> getPathApproximation(Path path) {
        ApproxPointList approx = new ApproxPointList();
        for (Subpath subpath : path.getSubpaths()) {
            approx.addAllPoints(subpath.getPiecewiseLinearApproximation());
        }
        return approx;
    }

    private static Subpath constructSquare(Point squareCenter, double widthHalf, double rotationAngle) {
        Point[] ortogonalSquareVertices = new Point[]{new Point(-widthHalf, -widthHalf), new Point(-widthHalf, widthHalf), new Point(widthHalf, widthHalf), new Point(widthHalf, -widthHalf)};
        Point[] rotatedSquareVertices = PdfCleanUpFilter.getRotatedSquareVertices(ortogonalSquareVertices, rotationAngle, squareCenter);
        Subpath square = new Subpath();
        square.addSegment((IShape)new Line(rotatedSquareVertices[0], rotatedSquareVertices[1]));
        square.addSegment((IShape)new Line(rotatedSquareVertices[1], rotatedSquareVertices[2]));
        square.addSegment((IShape)new Line(rotatedSquareVertices[2], rotatedSquareVertices[3]));
        square.addSegment((IShape)new Line(rotatedSquareVertices[3], rotatedSquareVertices[0]));
        return square;
    }

    private static Point[] getRotatedSquareVertices(Point[] orthogonalSquareVertices, double angle, Point squareCenter) {
        Point[] rotatedSquareVertices = new Point[orthogonalSquareVertices.length];
        AffineTransform.getRotateInstance((double)((float)angle)).transform(orthogonalSquareVertices, 0, rotatedSquareVertices, 0, rotatedSquareVertices.length);
        AffineTransform.getTranslateInstance((double)((float)squareCenter.getX()), (double)((float)squareCenter.getY())).transform(rotatedSquareVertices, 0, rotatedSquareVertices, 0, orthogonalSquareVertices.length);
        return rotatedSquareVertices;
    }

    private static BezierCurve[] approximateCircle(Point center, double radius) {
        BezierCurve[] approximation = new BezierCurve[4];
        double x = center.getX();
        double y = center.getY();
        approximation[0] = new BezierCurve(Arrays.asList(new Point(x, y + radius), new Point(x + radius * 0.55191502449, y + radius), new Point(x + radius, y + radius * 0.55191502449), new Point(x + radius, y)));
        approximation[1] = new BezierCurve(Arrays.asList(new Point(x + radius, y), new Point(x + radius, y - radius * 0.55191502449), new Point(x + radius * 0.55191502449, y - radius), new Point(x, y - radius)));
        approximation[2] = new BezierCurve(Arrays.asList(new Point(x, y - radius), new Point(x - radius * 0.55191502449, y - radius), new Point(x - radius, y - radius * 0.55191502449), new Point(x - radius, y)));
        approximation[3] = new BezierCurve(Arrays.asList(new Point(x - radius, y), new Point(x - radius, y + radius * 0.55191502449), new Point(x - radius * 0.55191502449, y + radius), new Point(x, y + radius)));
        return approximation;
    }

    private static Point[] transformPoints(Matrix transformationMatrix, boolean inverse, Point ... points) {
        AffineTransform t = new AffineTransform((double)transformationMatrix.get(0), (double)transformationMatrix.get(1), (double)transformationMatrix.get(3), (double)transformationMatrix.get(4), (double)transformationMatrix.get(6), (double)transformationMatrix.get(7));
        Point[] transformed = new Point[points.length];
        if (inverse) {
            try {
                t = t.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new PdfException("A noninvertible matrix has been parsed. The behaviour is unpredictable.", (Throwable)e);
            }
        }
        t.transform(points, 0, transformed, 0, points.length);
        return transformed;
    }

    private static Point[] getTextRectangle(TextRenderInfo renderInfo) {
        LineSegment ascent = renderInfo.getAscentLine();
        LineSegment descent = renderInfo.getDescentLine();
        return new Point[]{new Point((double)ascent.getStartPoint().get(0), (double)ascent.getStartPoint().get(1)), new Point((double)ascent.getEndPoint().get(0), (double)ascent.getEndPoint().get(1)), new Point((double)descent.getEndPoint().get(0), (double)descent.getEndPoint().get(1)), new Point((double)descent.getStartPoint().get(0), (double)descent.getStartPoint().get(1))};
    }

    private static Point[] getRectangleVertices(Rectangle rect) {
        Point[] points = new Point[]{new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop()), new Point((double)rect.getLeft(), (double)rect.getTop())};
        return points;
    }

    private static Rectangle getRectanglesIntersection(Rectangle rect1, Rectangle rect2) {
        float x1 = Math.max(rect1.getLeft(), rect2.getLeft());
        float y1 = Math.max(rect1.getBottom(), rect2.getBottom());
        float x2 = Math.min(rect1.getRight(), rect2.getRight());
        float y2 = Math.min(rect1.getTop(), rect2.getTop());
        return x2 - x1 > 0.0f && y2 - y1 > 0.0f ? new Rectangle(x1, y1, x2 - x1, y2 - y1) : null;
    }

    private static class StandardLine {
        float A;
        float B;
        float C;

        StandardLine(Point p1, Point p2) {
            this.A = (float)(p2.getY() - p1.getY());
            this.B = (float)(p1.getX() - p2.getX());
            this.C = (float)(p1.getY() * (double)(-this.B) - p1.getX() * (double)this.A);
        }

        float getSlope() {
            if (this.B == 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return -this.A / this.B;
        }

        boolean contains(Point point) {
            return Float.compare(Math.abs(this.A * (float)point.getX() + this.B * (float)point.getY() + this.C), 0.1f) < 0;
        }
    }

    private static class ApproxPointList<T>
    extends ArrayList<Point> {
        public boolean addAllPoints(Collection<Point> c) {
            Point prevPoint = this.size() - 1 < 0 ? null : (Point)this.get(this.size() - 1);
            for (Point pt : c) {
                if (pt.equals((Object)prevPoint)) continue;
                this.add(pt);
                prevPoint = pt;
            }
            return true;
        }
    }

    static class FilterResult<T> {
        private boolean isModified;
        private T filterResult;

        public FilterResult(boolean isModified, T filterResult) {
            this.isModified = isModified;
            this.filterResult = filterResult;
        }

        boolean isModified() {
            return this.isModified;
        }

        T getFilterResult() {
            return this.filterResult;
        }
    }
}

