/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.ImageRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.PathRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PdfCleanUpEventListener
implements IEventListener {
    private static final String textDataExpected = "Text data expected.";
    private static final String imageDataExpected = "Image data expected.";
    private static final String pathDataExpected = "Path data expected.";
    private List<IEventData> content = new ArrayList<IEventData>();

    public void eventOccurred(IEventData data, EventType type) {
        switch (type) {
            case RENDER_TEXT: 
            case RENDER_IMAGE: 
            case RENDER_PATH: {
                this.content.add(data);
                break;
            }
        }
    }

    List<TextRenderInfo> getEncounteredText() {
        if (this.content.size() == 0) {
            throw new PdfException(textDataExpected);
        }
        ArrayList<TextRenderInfo> text = new ArrayList<TextRenderInfo>(this.content.size());
        for (IEventData data : this.content) {
            if (data instanceof TextRenderInfo) {
                text.add((TextRenderInfo)data);
                continue;
            }
            throw new PdfException(textDataExpected);
        }
        this.content.clear();
        return text;
    }

    ImageRenderInfo getEncounteredImage() {
        if (this.content.size() == 0) {
            throw new PdfException(imageDataExpected);
        }
        IEventData eventData = this.content.get(0);
        if (!(eventData instanceof ImageRenderInfo)) {
            throw new PdfException(imageDataExpected);
        }
        this.content.clear();
        return (ImageRenderInfo)eventData;
    }

    PathRenderInfo getEncounteredPath() {
        if (this.content.size() == 0) {
            throw new PdfException(pathDataExpected);
        }
        IEventData eventData = this.content.get(0);
        if (!(eventData instanceof PathRenderInfo)) {
            throw new PdfException(pathDataExpected);
        }
        this.content.clear();
        return (PathRenderInfo)eventData;
    }

    public Set<EventType> getSupportedEvents() {
        return null;
    }
}

