/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

class FilteredImagesCache {
    private Map<PdfIndirectReference, List<FilteredImageKey>> cache = new HashMap<PdfIndirectReference, List<FilteredImageKey>>();

    FilteredImagesCache() {
    }

    static FilteredImageKey createFilteredImageKey(PdfImageXObject image, List<Rectangle> areasToBeCleaned, PdfDocument document) {
        PdfStream imagePdfObject = (PdfStream)image.getPdfObject();
        if (imagePdfObject.getIndirectReference() == null) {
            imagePdfObject.makeIndirect(document);
        }
        return new FilteredImageKey(image, areasToBeCleaned);
    }

    PdfImageXObject get(FilteredImageKey imageKey) {
        List<FilteredImageKey> cachedFilteredImageKeys = this.cache.get(imageKey.getImageIndRef());
        if (cachedFilteredImageKeys != null) {
            for (FilteredImageKey cacheKey : cachedFilteredImageKeys) {
                if (!this.rectanglesEqualWithEps(cacheKey.getCleanedAreas(), imageKey.getCleanedAreas())) continue;
                return cacheKey.getFilteredImage();
            }
        }
        return null;
    }

    void put(FilteredImageKey imageKey, PdfImageXObject filteredImage) {
        if (imageKey.getCleanedAreas() == null || imageKey.getCleanedAreas().isEmpty()) {
            return;
        }
        List<FilteredImageKey> filteredImageKeys = this.cache.get(imageKey.getImageIndRef());
        if (filteredImageKeys == null) {
            filteredImageKeys = new ArrayList<FilteredImageKey>();
            this.cache.put(imageKey.getImageIndRef(), filteredImageKeys);
        }
        filteredImageKeys.add(imageKey);
        imageKey.setFilteredImage(filteredImage);
    }

    private boolean rectanglesEqualWithEps(List<Rectangle> cacheRects, List<Rectangle> keyRects) {
        if (keyRects == null || cacheRects.size() != keyRects.size()) {
            return false;
        }
        LinkedHashSet<Rectangle> cacheRectsSet = new LinkedHashSet<Rectangle>(cacheRects);
        for (Rectangle keyArea : keyRects) {
            boolean found = false;
            for (Rectangle cacheArea : cacheRectsSet) {
                if (!keyArea.equalsWithEpsilon(cacheArea)) continue;
                found = true;
                cacheRectsSet.remove(cacheArea);
                break;
            }
            if (found) continue;
            break;
        }
        return cacheRectsSet.isEmpty();
    }

    static class FilteredImageKey {
        private PdfImageXObject image;
        private List<Rectangle> cleanedAreas;
        private PdfImageXObject filteredImage;

        FilteredImageKey(PdfImageXObject image, List<Rectangle> cleanedAreas) {
            this.image = image;
            this.cleanedAreas = cleanedAreas;
        }

        List<Rectangle> getCleanedAreas() {
            return this.cleanedAreas;
        }

        PdfImageXObject getImageXObject() {
            return this.image;
        }

        PdfIndirectReference getImageIndRef() {
            return ((PdfStream)this.image.getPdfObject()).getIndirectReference();
        }

        PdfImageXObject getFilteredImage() {
            return this.filteredImage;
        }

        void setFilteredImage(PdfImageXObject filteredImage) {
            this.filteredImage = filteredImage;
        }
    }
}

