/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview;

import android.graphics.Bitmap;
import android.net.Uri;
import com.isseiaoki.simplecropview.CropImageView;
import com.isseiaoki.simplecropview.callback.CropCallback;
import io.reactivex.Single;

public class CropRequest {
    private CropImageView cropImageView;
    private Uri sourceUri;
    private int outputWidth;
    private int outputHeight;
    private int outputMaxWidth;
    private int outputMaxHeight;

    public CropRequest(CropImageView cropImageView, Uri sourceUri) {
        this.cropImageView = cropImageView;
        this.sourceUri = sourceUri;
    }

    public CropRequest outputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
        this.outputHeight = 0;
        return this;
    }

    public CropRequest outputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
        this.outputWidth = 0;
        return this;
    }

    public CropRequest outputMaxWidth(int outputMaxWidth) {
        this.outputMaxWidth = outputMaxWidth;
        return this;
    }

    public CropRequest outputMaxHeight(int outputMaxHeight) {
        this.outputMaxHeight = outputMaxHeight;
        return this;
    }

    private void build() {
        if (this.outputWidth > 0) {
            this.cropImageView.setOutputWidth(this.outputWidth);
        }
        if (this.outputHeight > 0) {
            this.cropImageView.setOutputHeight(this.outputHeight);
        }
        this.cropImageView.setOutputMaxSize(this.outputMaxWidth, this.outputMaxHeight);
    }

    public void execute(CropCallback cropCallback) {
        this.build();
        this.cropImageView.cropAsync(this.sourceUri, cropCallback);
    }

    public Single<Bitmap> executeAsSingle() {
        this.build();
        return this.cropImageView.cropAsSingle(this.sourceUri);
    }
}

