/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.isseiaoki.simplecropview.CropRequest;
import com.isseiaoki.simplecropview.LoadRequest;
import com.isseiaoki.simplecropview.R;
import com.isseiaoki.simplecropview.SaveRequest;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimator;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimatorListener;
import com.isseiaoki.simplecropview.animation.ValueAnimatorV14;
import com.isseiaoki.simplecropview.animation.ValueAnimatorV8;
import com.isseiaoki.simplecropview.callback.Callback;
import com.isseiaoki.simplecropview.callback.CropCallback;
import com.isseiaoki.simplecropview.callback.LoadCallback;
import com.isseiaoki.simplecropview.callback.SaveCallback;
import com.isseiaoki.simplecropview.util.Logger;
import com.isseiaoki.simplecropview.util.Utils;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class CropImageView
extends ImageView {
    private static final String TAG = CropImageView.class.getSimpleName();
    private static final int HANDLE_SIZE_IN_DP = 14;
    private static final int MIN_FRAME_SIZE_IN_DP = 50;
    private static final int FRAME_STROKE_WEIGHT_IN_DP = 1;
    private static final int GUIDE_STROKE_WEIGHT_IN_DP = 1;
    private static final float DEFAULT_INITIAL_FRAME_SCALE = 1.0f;
    private static final int DEFAULT_ANIMATION_DURATION_MILLIS = 100;
    private static final int DEBUG_TEXT_SIZE_IN_DP = 15;
    private static final int TRANSPARENT = 0;
    private static final int TRANSLUCENT_WHITE = -1140850689;
    private static final int WHITE = -1;
    private static final int TRANSLUCENT_BLACK = -1157627904;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private float mScale = 1.0f;
    private float mAngle = 0.0f;
    private float mImgWidth = 0.0f;
    private float mImgHeight = 0.0f;
    private boolean mIsInitialized = false;
    private Matrix mMatrix = null;
    private Paint mPaintTranslucent;
    private Paint mPaintFrame;
    private Paint mPaintBitmap;
    private Paint mPaintDebug;
    private RectF mFrameRect;
    private RectF mInitialFrameRect;
    private RectF mImageRect;
    private PointF mCenter = new PointF();
    private float mLastX;
    private float mLastY;
    private boolean mIsRotating = false;
    private boolean mIsAnimating = false;
    private SimpleValueAnimator mAnimator = null;
    private final Interpolator DEFAULT_INTERPOLATOR;
    private Interpolator mInterpolator = this.DEFAULT_INTERPOLATOR = new DecelerateInterpolator();
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Uri mSourceUri = null;
    private Uri mSaveUri = null;
    private int mExifRotation = 0;
    private int mOutputMaxWidth;
    private int mOutputMaxHeight;
    private int mOutputWidth = 0;
    private int mOutputHeight = 0;
    private boolean mIsDebug = false;
    private Bitmap.CompressFormat mCompressFormat = Bitmap.CompressFormat.PNG;
    private int mCompressQuality = 100;
    private int mInputImageWidth = 0;
    private int mInputImageHeight = 0;
    private int mOutputImageWidth = 0;
    private int mOutputImageHeight = 0;
    private AtomicBoolean mIsLoading = new AtomicBoolean(false);
    private AtomicBoolean mIsCropping = new AtomicBoolean(false);
    private AtomicBoolean mIsSaving = new AtomicBoolean(false);
    private ExecutorService mExecutor;
    private TouchArea mTouchArea = TouchArea.OUT_OF_BOUNDS;
    private CropMode mCropMode = CropMode.SQUARE;
    private ShowMode mGuideShowMode = ShowMode.SHOW_ALWAYS;
    private ShowMode mHandleShowMode = ShowMode.SHOW_ALWAYS;
    private float mMinFrameSize;
    private int mHandleSize;
    private int mTouchPadding = 0;
    private boolean mShowGuide = true;
    private boolean mShowHandle = true;
    private boolean mIsCropEnabled = true;
    private boolean mIsEnabled = true;
    private PointF mCustomRatio = new PointF(1.0f, 1.0f);
    private float mFrameStrokeWeight = 2.0f;
    private float mGuideStrokeWeight = 2.0f;
    private int mBackgroundColor;
    private int mOverlayColor;
    private int mFrameColor;
    private int mHandleColor;
    private int mGuideColor;
    private float mInitialFrameScale;
    private boolean mIsAnimationEnabled = true;
    private int mAnimationDurationMillis = 100;
    private boolean mIsHandleShadowEnabled = true;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mExecutor = Executors.newSingleThreadExecutor();
        float density = this.getDensity();
        this.mHandleSize = (int)(density * 14.0f);
        this.mMinFrameSize = density * 50.0f;
        this.mFrameStrokeWeight = density * 1.0f;
        this.mGuideStrokeWeight = density * 1.0f;
        this.mPaintFrame = new Paint();
        this.mPaintTranslucent = new Paint();
        this.mPaintBitmap = new Paint();
        this.mPaintBitmap.setFilterBitmap(true);
        this.mPaintDebug = new Paint();
        this.mPaintDebug.setAntiAlias(true);
        this.mPaintDebug.setStyle(Paint.Style.STROKE);
        this.mPaintDebug.setColor(-1);
        this.mPaintDebug.setTextSize(15.0f * density);
        this.mMatrix = new Matrix();
        this.mScale = 1.0f;
        this.mBackgroundColor = 0;
        this.mFrameColor = -1;
        this.mOverlayColor = -1157627904;
        this.mHandleColor = -1;
        this.mGuideColor = -1140850689;
        this.handleStyleable(context, attrs, defStyle, density);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mode = this.mCropMode;
        ss.backgroundColor = this.mBackgroundColor;
        ss.overlayColor = this.mOverlayColor;
        ss.frameColor = this.mFrameColor;
        ss.guideShowMode = this.mGuideShowMode;
        ss.handleShowMode = this.mHandleShowMode;
        ss.showGuide = this.mShowGuide;
        ss.showHandle = this.mShowHandle;
        ss.handleSize = this.mHandleSize;
        ss.touchPadding = this.mTouchPadding;
        ss.minFrameSize = this.mMinFrameSize;
        ss.customRatioX = this.mCustomRatio.x;
        ss.customRatioY = this.mCustomRatio.y;
        ss.frameStrokeWeight = this.mFrameStrokeWeight;
        ss.guideStrokeWeight = this.mGuideStrokeWeight;
        ss.isCropEnabled = this.mIsCropEnabled;
        ss.handleColor = this.mHandleColor;
        ss.guideColor = this.mGuideColor;
        ss.initialFrameScale = this.mInitialFrameScale;
        ss.angle = this.mAngle;
        ss.isAnimationEnabled = this.mIsAnimationEnabled;
        ss.animationDuration = this.mAnimationDurationMillis;
        ss.exifRotation = this.mExifRotation;
        ss.sourceUri = this.mSourceUri;
        ss.saveUri = this.mSaveUri;
        ss.compressFormat = this.mCompressFormat;
        ss.compressQuality = this.mCompressQuality;
        ss.isDebug = this.mIsDebug;
        ss.outputMaxWidth = this.mOutputMaxWidth;
        ss.outputMaxHeight = this.mOutputMaxHeight;
        ss.outputWidth = this.mOutputWidth;
        ss.outputHeight = this.mOutputHeight;
        ss.isHandleShadowEnabled = this.mIsHandleShadowEnabled;
        ss.inputImageWidth = this.mInputImageWidth;
        ss.inputImageHeight = this.mInputImageHeight;
        ss.outputImageWidth = this.mOutputImageWidth;
        ss.outputImageHeight = this.mOutputImageHeight;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mCropMode = ss.mode;
        this.mBackgroundColor = ss.backgroundColor;
        this.mOverlayColor = ss.overlayColor;
        this.mFrameColor = ss.frameColor;
        this.mGuideShowMode = ss.guideShowMode;
        this.mHandleShowMode = ss.handleShowMode;
        this.mShowGuide = ss.showGuide;
        this.mShowHandle = ss.showHandle;
        this.mHandleSize = ss.handleSize;
        this.mTouchPadding = ss.touchPadding;
        this.mMinFrameSize = ss.minFrameSize;
        this.mCustomRatio = new PointF(ss.customRatioX, ss.customRatioY);
        this.mFrameStrokeWeight = ss.frameStrokeWeight;
        this.mGuideStrokeWeight = ss.guideStrokeWeight;
        this.mIsCropEnabled = ss.isCropEnabled;
        this.mHandleColor = ss.handleColor;
        this.mGuideColor = ss.guideColor;
        this.mInitialFrameScale = ss.initialFrameScale;
        this.mAngle = ss.angle;
        this.mIsAnimationEnabled = ss.isAnimationEnabled;
        this.mAnimationDurationMillis = ss.animationDuration;
        this.mExifRotation = ss.exifRotation;
        this.mSourceUri = ss.sourceUri;
        this.mSaveUri = ss.saveUri;
        this.mCompressFormat = ss.compressFormat;
        this.mCompressQuality = ss.compressQuality;
        this.mIsDebug = ss.isDebug;
        this.mOutputMaxWidth = ss.outputMaxWidth;
        this.mOutputMaxHeight = ss.outputMaxHeight;
        this.mOutputWidth = ss.outputWidth;
        this.mOutputHeight = ss.outputHeight;
        this.mIsHandleShadowEnabled = ss.isHandleShadowEnabled;
        this.mInputImageWidth = ss.inputImageWidth;
        this.mInputImageHeight = ss.inputImageHeight;
        this.mOutputImageWidth = ss.outputImageWidth;
        this.mOutputImageHeight = ss.outputImageHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(viewWidth, viewHeight);
        this.mViewWidth = viewWidth - this.getPaddingLeft() - this.getPaddingRight();
        this.mViewHeight = viewHeight - this.getPaddingTop() - this.getPaddingBottom();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getDrawable() != null) {
            this.setupLayout(this.mViewWidth, this.mViewHeight);
        }
    }

    public void onDraw(Canvas canvas) {
        canvas.drawColor(this.mBackgroundColor);
        if (this.mIsInitialized) {
            this.setMatrix();
            Bitmap bm = this.getBitmap();
            if (bm != null) {
                canvas.drawBitmap(bm, this.mMatrix, this.mPaintBitmap);
                this.drawCropFrame(canvas);
            }
            if (this.mIsDebug) {
                this.drawDebugInfo(canvas);
            }
        }
    }

    protected void onDetachedFromWindow() {
        this.mExecutor.shutdown();
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStyleable(Context context, AttributeSet attrs, int defStyle, float mDensity) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.scv_CropImageView, defStyle, 0);
        this.mCropMode = CropMode.SQUARE;
        try {
            Drawable drawable = ta.getDrawable(R.styleable.scv_CropImageView_scv_img_src);
            if (drawable != null) {
                this.setImageDrawable(drawable);
            }
            for (CropMode cropMode : CropMode.values()) {
                if (ta.getInt(R.styleable.scv_CropImageView_scv_crop_mode, 3) != cropMode.getId()) continue;
                this.mCropMode = cropMode;
                break;
            }
            this.mBackgroundColor = ta.getColor(R.styleable.scv_CropImageView_scv_background_color, 0);
            this.mOverlayColor = ta.getColor(R.styleable.scv_CropImageView_scv_overlay_color, -1157627904);
            this.mFrameColor = ta.getColor(R.styleable.scv_CropImageView_scv_frame_color, -1);
            this.mHandleColor = ta.getColor(R.styleable.scv_CropImageView_scv_handle_color, -1);
            this.mGuideColor = ta.getColor(R.styleable.scv_CropImageView_scv_guide_color, -1140850689);
            for (Enum enum_ : ShowMode.values()) {
                if (ta.getInt(R.styleable.scv_CropImageView_scv_guide_show_mode, 1) != ((ShowMode)enum_).getId()) continue;
                this.mGuideShowMode = enum_;
                break;
            }
            for (Enum enum_ : ShowMode.values()) {
                if (ta.getInt(R.styleable.scv_CropImageView_scv_handle_show_mode, 1) != ((ShowMode)enum_).getId()) continue;
                this.mHandleShowMode = enum_;
                break;
            }
            this.setGuideShowMode(this.mGuideShowMode);
            this.setHandleShowMode(this.mHandleShowMode);
            this.mHandleSize = ta.getDimensionPixelSize(R.styleable.scv_CropImageView_scv_handle_size, (int)(14.0f * mDensity));
            this.mTouchPadding = ta.getDimensionPixelSize(R.styleable.scv_CropImageView_scv_touch_padding, 0);
            this.mMinFrameSize = ta.getDimensionPixelSize(R.styleable.scv_CropImageView_scv_min_frame_size, (int)(50.0f * mDensity));
            this.mFrameStrokeWeight = ta.getDimensionPixelSize(R.styleable.scv_CropImageView_scv_frame_stroke_weight, (int)(1.0f * mDensity));
            this.mGuideStrokeWeight = ta.getDimensionPixelSize(R.styleable.scv_CropImageView_scv_guide_stroke_weight, (int)(1.0f * mDensity));
            this.mIsCropEnabled = ta.getBoolean(R.styleable.scv_CropImageView_scv_crop_enabled, true);
            this.mInitialFrameScale = this.constrain(ta.getFloat(R.styleable.scv_CropImageView_scv_initial_frame_scale, 1.0f), 0.01f, 1.0f, 1.0f);
            this.mIsAnimationEnabled = ta.getBoolean(R.styleable.scv_CropImageView_scv_animation_enabled, true);
            this.mAnimationDurationMillis = ta.getInt(R.styleable.scv_CropImageView_scv_animation_duration, 100);
            this.mIsHandleShadowEnabled = ta.getBoolean(R.styleable.scv_CropImageView_scv_handle_shadow_enabled, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ta.recycle();
        }
    }

    private void drawDebugInfo(Canvas canvas) {
        Paint.FontMetrics fontMetrics = this.mPaintDebug.getFontMetrics();
        this.mPaintDebug.measureText("W");
        int textHeight = (int)(fontMetrics.descent - fontMetrics.ascent);
        int x = (int)(this.mImageRect.left + (float)this.mHandleSize * 0.5f * this.getDensity());
        int y = (int)(this.mImageRect.top + (float)textHeight + (float)this.mHandleSize * 0.5f * this.getDensity());
        StringBuilder builder = new StringBuilder();
        builder.append("LOADED FROM: ").append(this.mSourceUri != null ? "Uri" : "Bitmap");
        canvas.drawText(builder.toString(), (float)x, (float)y, this.mPaintDebug);
        builder = new StringBuilder();
        if (this.mSourceUri == null) {
            builder.append("INPUT_IMAGE_SIZE: ").append((int)this.mImgWidth).append("x").append((int)this.mImgHeight);
            canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
            builder = new StringBuilder();
        } else {
            builder = new StringBuilder().append("INPUT_IMAGE_SIZE: ").append(this.mInputImageWidth).append("x").append(this.mInputImageHeight);
            canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
            builder = new StringBuilder();
        }
        builder.append("LOADED_IMAGE_SIZE: ").append(this.getBitmap().getWidth()).append("x").append(this.getBitmap().getHeight());
        canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
        builder = new StringBuilder();
        if (this.mOutputImageWidth > 0 && this.mOutputImageHeight > 0) {
            builder.append("OUTPUT_IMAGE_SIZE: ").append(this.mOutputImageWidth).append("x").append(this.mOutputImageHeight);
            canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
            builder = new StringBuilder().append("EXIF ROTATION: ").append(this.mExifRotation);
            canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
            builder = new StringBuilder().append("CURRENT_ROTATION: ").append((int)this.mAngle);
            canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
        }
        builder = new StringBuilder();
        builder.append("FRAME_RECT: ").append(this.mFrameRect.toString());
        canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
        builder = new StringBuilder();
        builder.append("ACTUAL_CROP_RECT: ").append(this.getActualCropRect() != null ? this.getActualCropRect().toString() : "");
        canvas.drawText(builder.toString(), (float)x, (float)(y += textHeight), this.mPaintDebug);
    }

    private void drawCropFrame(Canvas canvas) {
        if (!this.mIsCropEnabled) {
            return;
        }
        if (this.mIsRotating) {
            return;
        }
        this.drawOverlay(canvas);
        this.drawFrame(canvas);
        if (this.mShowGuide) {
            this.drawGuidelines(canvas);
        }
        if (this.mShowHandle) {
            this.drawHandles(canvas);
        }
    }

    private void drawOverlay(Canvas canvas) {
        this.mPaintTranslucent.setAntiAlias(true);
        this.mPaintTranslucent.setFilterBitmap(true);
        this.mPaintTranslucent.setColor(this.mOverlayColor);
        this.mPaintTranslucent.setStyle(Paint.Style.FILL);
        Path path = new Path();
        RectF overlayRect = new RectF((float)Math.floor(this.mImageRect.left), (float)Math.floor(this.mImageRect.top), (float)Math.ceil(this.mImageRect.right), (float)Math.ceil(this.mImageRect.bottom));
        if (!(this.mIsAnimating || this.mCropMode != CropMode.CIRCLE && this.mCropMode != CropMode.CIRCLE_SQUARE)) {
            path.addRect(overlayRect, Path.Direction.CW);
            PointF circleCenter = new PointF((this.mFrameRect.left + this.mFrameRect.right) / 2.0f, (this.mFrameRect.top + this.mFrameRect.bottom) / 2.0f);
            float circleRadius = (this.mFrameRect.right - this.mFrameRect.left) / 2.0f;
            path.addCircle(circleCenter.x, circleCenter.y, circleRadius, Path.Direction.CCW);
            canvas.drawPath(path, this.mPaintTranslucent);
        } else {
            path.addRect(overlayRect, Path.Direction.CW);
            path.addRect(this.mFrameRect, Path.Direction.CCW);
            canvas.drawPath(path, this.mPaintTranslucent);
        }
    }

    private void drawFrame(Canvas canvas) {
        this.mPaintFrame.setAntiAlias(true);
        this.mPaintFrame.setFilterBitmap(true);
        this.mPaintFrame.setStyle(Paint.Style.STROKE);
        this.mPaintFrame.setColor(this.mFrameColor);
        this.mPaintFrame.setStrokeWidth(this.mFrameStrokeWeight);
        canvas.drawRect(this.mFrameRect, this.mPaintFrame);
    }

    private void drawGuidelines(Canvas canvas) {
        this.mPaintFrame.setColor(this.mGuideColor);
        this.mPaintFrame.setStrokeWidth(this.mGuideStrokeWeight);
        float h1 = this.mFrameRect.left + (this.mFrameRect.right - this.mFrameRect.left) / 3.0f;
        float h2 = this.mFrameRect.right - (this.mFrameRect.right - this.mFrameRect.left) / 3.0f;
        float v1 = this.mFrameRect.top + (this.mFrameRect.bottom - this.mFrameRect.top) / 3.0f;
        float v2 = this.mFrameRect.bottom - (this.mFrameRect.bottom - this.mFrameRect.top) / 3.0f;
        canvas.drawLine(h1, this.mFrameRect.top, h1, this.mFrameRect.bottom, this.mPaintFrame);
        canvas.drawLine(h2, this.mFrameRect.top, h2, this.mFrameRect.bottom, this.mPaintFrame);
        canvas.drawLine(this.mFrameRect.left, v1, this.mFrameRect.right, v1, this.mPaintFrame);
        canvas.drawLine(this.mFrameRect.left, v2, this.mFrameRect.right, v2, this.mPaintFrame);
    }

    private void drawHandles(Canvas canvas) {
        if (this.mIsHandleShadowEnabled) {
            this.drawHandleShadows(canvas);
        }
        this.mPaintFrame.setStyle(Paint.Style.FILL);
        this.mPaintFrame.setColor(this.mHandleColor);
        canvas.drawCircle(this.mFrameRect.left, this.mFrameRect.top, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(this.mFrameRect.right, this.mFrameRect.top, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(this.mFrameRect.left, this.mFrameRect.bottom, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(this.mFrameRect.right, this.mFrameRect.bottom, (float)this.mHandleSize, this.mPaintFrame);
    }

    private void drawHandleShadows(Canvas canvas) {
        this.mPaintFrame.setStyle(Paint.Style.FILL);
        this.mPaintFrame.setColor(-1157627904);
        RectF rect = new RectF(this.mFrameRect);
        rect.offset(0.0f, 1.0f);
        canvas.drawCircle(rect.left, rect.top, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(rect.right, rect.top, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(rect.left, rect.bottom, (float)this.mHandleSize, this.mPaintFrame);
        canvas.drawCircle(rect.right, rect.bottom, (float)this.mHandleSize, this.mPaintFrame);
    }

    private void setMatrix() {
        this.mMatrix.reset();
        this.mMatrix.setTranslate(this.mCenter.x - this.mImgWidth * 0.5f, this.mCenter.y - this.mImgHeight * 0.5f);
        this.mMatrix.postScale(this.mScale, this.mScale, this.mCenter.x, this.mCenter.y);
        this.mMatrix.postRotate(this.mAngle, this.mCenter.x, this.mCenter.y);
    }

    private void setupLayout(int viewW, int viewH) {
        if (viewW == 0 || viewH == 0) {
            return;
        }
        this.setCenter(new PointF((float)this.getPaddingLeft() + (float)viewW * 0.5f, (float)this.getPaddingTop() + (float)viewH * 0.5f));
        this.setScale(this.calcScale(viewW, viewH, this.mAngle));
        this.setMatrix();
        this.mImageRect = this.calcImageRect(new RectF(0.0f, 0.0f, this.mImgWidth, this.mImgHeight), this.mMatrix);
        this.mFrameRect = this.mInitialFrameRect != null ? this.applyInitialFrameRect(this.mInitialFrameRect) : this.calcFrameRect(this.mImageRect);
        this.mIsInitialized = true;
        this.invalidate();
    }

    private float calcScale(int viewW, int viewH, float angle) {
        this.mImgWidth = this.getDrawable().getIntrinsicWidth();
        this.mImgHeight = this.getDrawable().getIntrinsicHeight();
        if (this.mImgWidth <= 0.0f) {
            this.mImgWidth = viewW;
        }
        if (this.mImgHeight <= 0.0f) {
            this.mImgHeight = viewH;
        }
        float viewRatio = (float)viewW / (float)viewH;
        float imgRatio = this.getRotatedWidth(angle) / this.getRotatedHeight(angle);
        float scale = 1.0f;
        if (imgRatio >= viewRatio) {
            scale = (float)viewW / this.getRotatedWidth(angle);
        } else if (imgRatio < viewRatio) {
            scale = (float)viewH / this.getRotatedHeight(angle);
        }
        return scale;
    }

    private RectF calcImageRect(RectF rect, Matrix matrix) {
        RectF applied = new RectF();
        matrix.mapRect(applied, rect);
        return applied;
    }

    private RectF calcFrameRect(RectF imageRect) {
        float frameW = this.getRatioX(imageRect.width());
        float frameH = this.getRatioY(imageRect.height());
        float imgRatio = imageRect.width() / imageRect.height();
        float frameRatio = frameW / frameH;
        float l = imageRect.left;
        float t = imageRect.top;
        float r = imageRect.right;
        float b = imageRect.bottom;
        if (frameRatio >= imgRatio) {
            l = imageRect.left;
            r = imageRect.right;
            float hy = (imageRect.top + imageRect.bottom) * 0.5f;
            float hh = imageRect.width() / frameRatio * 0.5f;
            t = hy - hh;
            b = hy + hh;
        } else if (frameRatio < imgRatio) {
            t = imageRect.top;
            b = imageRect.bottom;
            float hx = (imageRect.left + imageRect.right) * 0.5f;
            float hw = imageRect.height() * frameRatio * 0.5f;
            l = hx - hw;
            r = hx + hw;
        }
        float w = r - l;
        float h = b - t;
        float cx = l + w / 2.0f;
        float cy = t + h / 2.0f;
        float sw = w * this.mInitialFrameScale;
        float sh = h * this.mInitialFrameScale;
        return new RectF(cx - sw / 2.0f, cy - sh / 2.0f, cx + sw / 2.0f, cy + sh / 2.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsInitialized) {
            return false;
        }
        if (!this.mIsCropEnabled) {
            return false;
        }
        if (!this.mIsEnabled) {
            return false;
        }
        if (this.mIsRotating) {
            return false;
        }
        if (this.mIsAnimating) {
            return false;
        }
        if (this.mIsLoading.get()) {
            return false;
        }
        if (this.mIsCropping.get()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onDown(event);
                return true;
            }
            case 2: {
                this.onMove(event);
                if (this.mTouchArea != TouchArea.OUT_OF_BOUNDS) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return true;
            }
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onCancel();
                return true;
            }
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onUp(event);
                return true;
            }
        }
        return false;
    }

    private void onDown(MotionEvent e) {
        this.invalidate();
        this.mLastX = e.getX();
        this.mLastY = e.getY();
        this.checkTouchArea(e.getX(), e.getY());
    }

    private void onMove(MotionEvent e) {
        float diffX = e.getX() - this.mLastX;
        float diffY = e.getY() - this.mLastY;
        switch (this.mTouchArea) {
            case CENTER: {
                this.moveFrame(diffX, diffY);
                break;
            }
            case LEFT_TOP: {
                this.moveHandleLT(diffX, diffY);
                break;
            }
            case RIGHT_TOP: {
                this.moveHandleRT(diffX, diffY);
                break;
            }
            case LEFT_BOTTOM: {
                this.moveHandleLB(diffX, diffY);
                break;
            }
            case RIGHT_BOTTOM: {
                this.moveHandleRB(diffX, diffY);
                break;
            }
        }
        this.invalidate();
        this.mLastX = e.getX();
        this.mLastY = e.getY();
    }

    private void onUp(MotionEvent e) {
        if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
            this.mShowGuide = false;
        }
        if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
            this.mShowHandle = false;
        }
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
        this.invalidate();
    }

    private void onCancel() {
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
        this.invalidate();
    }

    private void checkTouchArea(float x, float y) {
        if (this.isInsideCornerLeftTop(x, y)) {
            this.mTouchArea = TouchArea.LEFT_TOP;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerRightTop(x, y)) {
            this.mTouchArea = TouchArea.RIGHT_TOP;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerLeftBottom(x, y)) {
            this.mTouchArea = TouchArea.LEFT_BOTTOM;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerRightBottom(x, y)) {
            this.mTouchArea = TouchArea.RIGHT_BOTTOM;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideFrame(x, y)) {
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            this.mTouchArea = TouchArea.CENTER;
            return;
        }
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
    }

    private boolean isInsideFrame(float x, float y) {
        if (this.mFrameRect.left <= x && this.mFrameRect.right >= x && this.mFrameRect.top <= y && this.mFrameRect.bottom >= y) {
            this.mTouchArea = TouchArea.CENTER;
            return true;
        }
        return false;
    }

    private boolean isInsideCornerLeftTop(float x, float y) {
        float dx = x - this.mFrameRect.left;
        float dy = y - this.mFrameRect.top;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerRightTop(float x, float y) {
        float dx = x - this.mFrameRect.right;
        float dy = y - this.mFrameRect.top;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerLeftBottom(float x, float y) {
        float dx = x - this.mFrameRect.left;
        float dy = y - this.mFrameRect.bottom;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerRightBottom(float x, float y) {
        float dx = x - this.mFrameRect.right;
        float dy = y - this.mFrameRect.bottom;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private void moveFrame(float x, float y) {
        this.mFrameRect.left += x;
        this.mFrameRect.right += x;
        this.mFrameRect.top += y;
        this.mFrameRect.bottom += y;
        this.checkMoveBounds();
    }

    private void moveHandleLT(float diffX, float diffY) {
        if (this.mCropMode == CropMode.FREE) {
            this.mFrameRect.left += diffX;
            this.mFrameRect.top += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.left += dx;
            this.mFrameRect.top += dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top -= offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left -= offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.left)) {
                ox = this.mImageRect.left - this.mFrameRect.left;
                this.mFrameRect.left += ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top += oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.top)) {
                oy = this.mImageRect.top - this.mFrameRect.top;
                this.mFrameRect.top += oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left += ox;
            }
        }
    }

    private void moveHandleRT(float diffX, float diffY) {
        if (this.mCropMode == CropMode.FREE) {
            this.mFrameRect.right += diffX;
            this.mFrameRect.top += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.right += dx;
            this.mFrameRect.top -= dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top -= offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right += offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.right)) {
                ox = this.mFrameRect.right - this.mImageRect.right;
                this.mFrameRect.right -= ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top += oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.top)) {
                oy = this.mImageRect.top - this.mFrameRect.top;
                this.mFrameRect.top += oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right -= ox;
            }
        }
    }

    private void moveHandleLB(float diffX, float diffY) {
        if (this.mCropMode == CropMode.FREE) {
            this.mFrameRect.left += diffX;
            this.mFrameRect.bottom += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.left += dx;
            this.mFrameRect.bottom -= dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom += offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left -= offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.left)) {
                ox = this.mImageRect.left - this.mFrameRect.left;
                this.mFrameRect.left += ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom -= oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.bottom)) {
                oy = this.mFrameRect.bottom - this.mImageRect.bottom;
                this.mFrameRect.bottom -= oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left += ox;
            }
        }
    }

    private void moveHandleRB(float diffX, float diffY) {
        if (this.mCropMode == CropMode.FREE) {
            this.mFrameRect.right += diffX;
            this.mFrameRect.bottom += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.right += dx;
            this.mFrameRect.bottom += dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom += offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right += offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.right)) {
                ox = this.mFrameRect.right - this.mImageRect.right;
                this.mFrameRect.right -= ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom -= oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.bottom)) {
                oy = this.mFrameRect.bottom - this.mImageRect.bottom;
                this.mFrameRect.bottom -= oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right -= ox;
            }
        }
    }

    private void checkScaleBounds() {
        float lDiff = this.mFrameRect.left - this.mImageRect.left;
        float rDiff = this.mFrameRect.right - this.mImageRect.right;
        float tDiff = this.mFrameRect.top - this.mImageRect.top;
        float bDiff = this.mFrameRect.bottom - this.mImageRect.bottom;
        if (lDiff < 0.0f) {
            this.mFrameRect.left -= lDiff;
        }
        if (rDiff > 0.0f) {
            this.mFrameRect.right -= rDiff;
        }
        if (tDiff < 0.0f) {
            this.mFrameRect.top -= tDiff;
        }
        if (bDiff > 0.0f) {
            this.mFrameRect.bottom -= bDiff;
        }
    }

    private void checkMoveBounds() {
        float diff = this.mFrameRect.left - this.mImageRect.left;
        if (diff < 0.0f) {
            this.mFrameRect.left -= diff;
            this.mFrameRect.right -= diff;
        }
        if ((diff = this.mFrameRect.right - this.mImageRect.right) > 0.0f) {
            this.mFrameRect.left -= diff;
            this.mFrameRect.right -= diff;
        }
        if ((diff = this.mFrameRect.top - this.mImageRect.top) < 0.0f) {
            this.mFrameRect.top -= diff;
            this.mFrameRect.bottom -= diff;
        }
        if ((diff = this.mFrameRect.bottom - this.mImageRect.bottom) > 0.0f) {
            this.mFrameRect.top -= diff;
            this.mFrameRect.bottom -= diff;
        }
    }

    private boolean isInsideHorizontal(float x) {
        return this.mImageRect.left <= x && this.mImageRect.right >= x;
    }

    private boolean isInsideVertical(float y) {
        return this.mImageRect.top <= y && this.mImageRect.bottom >= y;
    }

    private boolean isWidthTooSmall() {
        return this.getFrameW() < this.mMinFrameSize;
    }

    private boolean isHeightTooSmall() {
        return this.getFrameH() < this.mMinFrameSize;
    }

    private void recalculateFrameRect(int durationMillis) {
        if (this.mImageRect == null) {
            return;
        }
        if (this.mIsAnimating) {
            this.getAnimator().cancelAnimation();
        }
        final RectF currentRect = new RectF(this.mFrameRect);
        final RectF newRect = this.calcFrameRect(this.mImageRect);
        final float diffL = newRect.left - currentRect.left;
        final float diffT = newRect.top - currentRect.top;
        final float diffR = newRect.right - currentRect.right;
        final float diffB = newRect.bottom - currentRect.bottom;
        if (this.mIsAnimationEnabled) {
            SimpleValueAnimator animator = this.getAnimator();
            animator.addAnimatorListener(new SimpleValueAnimatorListener(){

                @Override
                public void onAnimationStarted() {
                    CropImageView.this.mIsAnimating = true;
                }

                @Override
                public void onAnimationUpdated(float scale) {
                    CropImageView.this.mFrameRect = new RectF(currentRect.left + diffL * scale, currentRect.top + diffT * scale, currentRect.right + diffR * scale, currentRect.bottom + diffB * scale);
                    CropImageView.this.invalidate();
                }

                @Override
                public void onAnimationFinished() {
                    CropImageView.this.mFrameRect = newRect;
                    CropImageView.this.invalidate();
                    CropImageView.this.mIsAnimating = false;
                }
            });
            animator.startAnimation(durationMillis);
        } else {
            this.mFrameRect = this.calcFrameRect(this.mImageRect);
            this.invalidate();
        }
    }

    private float getRatioX(float w) {
        switch (this.mCropMode) {
            case FIT_IMAGE: {
                return this.mImageRect.width();
            }
            case FREE: {
                return w;
            }
            case RATIO_4_3: {
                return 4.0f;
            }
            case RATIO_3_4: {
                return 3.0f;
            }
            case RATIO_16_9: {
                return 16.0f;
            }
            case RATIO_9_16: {
                return 9.0f;
            }
            case SQUARE: 
            case CIRCLE: 
            case CIRCLE_SQUARE: {
                return 1.0f;
            }
            case CUSTOM: {
                return this.mCustomRatio.x;
            }
        }
        return w;
    }

    private float getRatioY(float h) {
        switch (this.mCropMode) {
            case FIT_IMAGE: {
                return this.mImageRect.height();
            }
            case FREE: {
                return h;
            }
            case RATIO_4_3: {
                return 3.0f;
            }
            case RATIO_3_4: {
                return 4.0f;
            }
            case RATIO_16_9: {
                return 9.0f;
            }
            case RATIO_9_16: {
                return 16.0f;
            }
            case SQUARE: 
            case CIRCLE: 
            case CIRCLE_SQUARE: {
                return 1.0f;
            }
            case CUSTOM: {
                return this.mCustomRatio.y;
            }
        }
        return h;
    }

    private float getRatioX() {
        switch (this.mCropMode) {
            case FIT_IMAGE: {
                return this.mImageRect.width();
            }
            case RATIO_4_3: {
                return 4.0f;
            }
            case RATIO_3_4: {
                return 3.0f;
            }
            case RATIO_16_9: {
                return 16.0f;
            }
            case RATIO_9_16: {
                return 9.0f;
            }
            case SQUARE: 
            case CIRCLE: 
            case CIRCLE_SQUARE: {
                return 1.0f;
            }
            case CUSTOM: {
                return this.mCustomRatio.x;
            }
        }
        return 1.0f;
    }

    private float getRatioY() {
        switch (this.mCropMode) {
            case FIT_IMAGE: {
                return this.mImageRect.height();
            }
            case RATIO_4_3: {
                return 3.0f;
            }
            case RATIO_3_4: {
                return 4.0f;
            }
            case RATIO_16_9: {
                return 9.0f;
            }
            case RATIO_9_16: {
                return 16.0f;
            }
            case SQUARE: 
            case CIRCLE: 
            case CIRCLE_SQUARE: {
                return 1.0f;
            }
            case CUSTOM: {
                return this.mCustomRatio.y;
            }
        }
        return 1.0f;
    }

    private float getDensity() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    private float sq(float value) {
        return value * value;
    }

    private float constrain(float val, float min, float max, float defaultVal) {
        if (val < min || val > max) {
            return defaultVal;
        }
        return val;
    }

    private void postErrorOnMainThread(final Callback callback, final Throwable e) {
        if (callback == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            callback.onError(e);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onError(e);
                }
            });
        }
    }

    private Bitmap getBitmap() {
        Bitmap bm = null;
        Drawable d = this.getDrawable();
        if (d != null && d instanceof BitmapDrawable) {
            bm = ((BitmapDrawable)d).getBitmap();
        }
        return bm;
    }

    private float getRotatedWidth(float angle) {
        return this.getRotatedWidth(angle, this.mImgWidth, this.mImgHeight);
    }

    private float getRotatedWidth(float angle, float width, float height) {
        return angle % 180.0f == 0.0f ? width : height;
    }

    private float getRotatedHeight(float angle) {
        return this.getRotatedHeight(angle, this.mImgWidth, this.mImgHeight);
    }

    private float getRotatedHeight(float angle, float width, float height) {
        return angle % 180.0f == 0.0f ? height : width;
    }

    private Bitmap getRotatedBitmap(Bitmap bitmap) {
        Matrix rotateMatrix = new Matrix();
        rotateMatrix.setRotate(this.mAngle, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)rotateMatrix, (boolean)true);
    }

    private SimpleValueAnimator getAnimator() {
        this.setupAnimatorIfNeeded();
        return this.mAnimator;
    }

    private void setupAnimatorIfNeeded() {
        if (this.mAnimator == null) {
            this.mAnimator = Build.VERSION.SDK_INT < 14 ? new ValueAnimatorV8(this.mInterpolator) : new ValueAnimatorV14(this.mInterpolator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getCroppedBitmapFromUri() throws IOException {
        Bitmap cropped = null;
        InputStream is = null;
        try {
            is = this.getContext().getContentResolver().openInputStream(this.mSourceUri);
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((InputStream)is, (boolean)false);
            int originalImageWidth = decoder.getWidth();
            int originalImageHeight = decoder.getHeight();
            Rect cropRect = this.calcCropRect(originalImageWidth, originalImageHeight);
            if (this.mAngle != 0.0f) {
                Matrix matrix = new Matrix();
                matrix.setRotate(-this.mAngle);
                RectF rotated = new RectF();
                matrix.mapRect(rotated, new RectF(cropRect));
                rotated.offset(rotated.left < 0.0f ? (float)originalImageWidth : 0.0f, rotated.top < 0.0f ? (float)originalImageHeight : 0.0f);
                cropRect = new Rect((int)rotated.left, (int)rotated.top, (int)rotated.right, (int)rotated.bottom);
            }
            cropped = decoder.decodeRegion(cropRect, new BitmapFactory.Options());
            if (this.mAngle != 0.0f) {
                Bitmap rotated = this.getRotatedBitmap(cropped);
                if (cropped != this.getBitmap() && cropped != rotated) {
                    cropped.recycle();
                }
                cropped = rotated;
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(is);
            throw throwable;
        }
        Utils.closeQuietly(is);
        return cropped;
    }

    private Rect calcCropRect(int originalImageWidth, int originalImageHeight) {
        float scaleToOriginal = this.getRotatedWidth(this.mAngle, originalImageWidth, originalImageHeight) / this.mImageRect.width();
        float offsetX = this.mImageRect.left * scaleToOriginal;
        float offsetY = this.mImageRect.top * scaleToOriginal;
        int left = Math.round(this.mFrameRect.left * scaleToOriginal - offsetX);
        int top = Math.round(this.mFrameRect.top * scaleToOriginal - offsetY);
        int right = Math.round(this.mFrameRect.right * scaleToOriginal - offsetX);
        int bottom = Math.round(this.mFrameRect.bottom * scaleToOriginal - offsetY);
        int imageW = Math.round(this.getRotatedWidth(this.mAngle, originalImageWidth, originalImageHeight));
        int imageH = Math.round(this.getRotatedHeight(this.mAngle, originalImageWidth, originalImageHeight));
        return new Rect(Math.max(left, 0), Math.max(top, 0), Math.min(right, imageW), Math.min(bottom, imageH));
    }

    private Bitmap scaleBitmapIfNeeded(Bitmap cropped) {
        int width = cropped.getWidth();
        int height = cropped.getHeight();
        int outWidth = 0;
        int outHeight = 0;
        float imageRatio = this.getRatioX(this.mFrameRect.width()) / this.getRatioY(this.mFrameRect.height());
        if (this.mOutputWidth > 0) {
            outWidth = this.mOutputWidth;
            outHeight = Math.round((float)this.mOutputWidth / imageRatio);
        } else if (this.mOutputHeight > 0) {
            outHeight = this.mOutputHeight;
            outWidth = Math.round((float)this.mOutputHeight * imageRatio);
        } else if (this.mOutputMaxWidth > 0 && this.mOutputMaxHeight > 0 && (width > this.mOutputMaxWidth || height > this.mOutputMaxHeight)) {
            float maxRatio = (float)this.mOutputMaxWidth / (float)this.mOutputMaxHeight;
            if (maxRatio >= imageRatio) {
                outHeight = this.mOutputMaxHeight;
                outWidth = Math.round((float)this.mOutputMaxHeight * imageRatio);
            } else {
                outWidth = this.mOutputMaxWidth;
                outHeight = Math.round((float)this.mOutputMaxWidth / imageRatio);
            }
        }
        if (outWidth > 0 && outHeight > 0) {
            Bitmap scaled = Utils.getScaledBitmap(cropped, outWidth, outHeight);
            if (cropped != this.getBitmap() && cropped != scaled) {
                cropped.recycle();
            }
            cropped = scaled;
        }
        return cropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Uri saveImage(Bitmap bitmap, Uri uri) throws IOException, IllegalStateException {
        Uri uri2;
        this.mSaveUri = uri;
        if (this.mSaveUri == null) {
            throw new IllegalStateException("Save uri must not be null.");
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.getContext().getContentResolver().openOutputStream(uri);
            bitmap.compress(this.mCompressFormat, this.mCompressQuality, outputStream);
            Utils.copyExifInfo(this.getContext(), this.mSourceUri, uri, bitmap.getWidth(), bitmap.getHeight());
            Utils.updateGalleryInfo(this.getContext(), uri);
            uri2 = uri;
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(outputStream);
            throw throwable;
        }
        Utils.closeQuietly(outputStream);
        return uri2;
    }

    public Bitmap getImageBitmap() {
        return this.getBitmap();
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
    }

    public void setImageResource(int resId) {
        this.mIsInitialized = false;
        this.resetImageInfo();
        super.setImageResource(resId);
        this.updateLayout();
    }

    public void setImageDrawable(Drawable drawable) {
        this.mIsInitialized = false;
        this.resetImageInfo();
        this.setImageDrawableInternal(drawable);
    }

    private void setImageDrawableInternal(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.updateLayout();
    }

    public void setImageURI(Uri uri) {
        this.mIsInitialized = false;
        super.setImageURI(uri);
        this.updateLayout();
    }

    private void updateLayout() {
        Drawable d = this.getDrawable();
        if (d != null) {
            this.setupLayout(this.mViewWidth, this.mViewHeight);
        }
    }

    private void resetImageInfo() {
        if (this.mIsLoading.get()) {
            return;
        }
        this.mSourceUri = null;
        this.mSaveUri = null;
        this.mInputImageWidth = 0;
        this.mInputImageHeight = 0;
        this.mOutputImageWidth = 0;
        this.mOutputImageHeight = 0;
        this.mAngle = this.mExifRotation;
    }

    public void startLoad(Uri sourceUri, LoadCallback callback) {
        this.loadAsync(sourceUri, callback);
    }

    public void loadAsync(Uri sourceUri, LoadCallback callback) {
        this.loadAsync(sourceUri, false, null, callback);
    }

    public void loadAsync(final Uri sourceUri, final boolean useThumbnail, final RectF initialFrameRect, final LoadCallback callback) {
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CropImageView.this.mIsLoading.set(true);
                    CropImageView.this.mSourceUri = sourceUri;
                    CropImageView.this.mInitialFrameRect = initialFrameRect;
                    if (useThumbnail) {
                        CropImageView.this.applyThumbnail(sourceUri);
                    }
                    final Bitmap sampled = CropImageView.this.getImage(sourceUri);
                    CropImageView.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CropImageView.this.mAngle = CropImageView.this.mExifRotation;
                            CropImageView.this.setImageDrawableInternal((Drawable)new BitmapDrawable(CropImageView.this.getResources(), sampled));
                            if (callback != null) {
                                callback.onSuccess();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    CropImageView.this.postErrorOnMainThread(callback, e);
                }
                finally {
                    CropImageView.this.mIsLoading.set(false);
                }
            }
        });
    }

    public Completable loadAsCompletable(Uri sourceUri) {
        return this.loadAsCompletable(sourceUri, false, null);
    }

    public Completable loadAsCompletable(final Uri sourceUri, final boolean useThumbnail, final RectF initialFrameRect) {
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final @NonNull CompletableEmitter emitter) throws Exception {
                CropImageView.this.mInitialFrameRect = initialFrameRect;
                CropImageView.this.mSourceUri = sourceUri;
                if (useThumbnail) {
                    CropImageView.this.applyThumbnail(sourceUri);
                }
                final Bitmap sampled = CropImageView.this.getImage(sourceUri);
                CropImageView.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CropImageView.this.mAngle = CropImageView.this.mExifRotation;
                        CropImageView.this.setImageDrawableInternal((Drawable)new BitmapDrawable(CropImageView.this.getResources(), sampled));
                        emitter.onComplete();
                    }
                });
            }
        }).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(@NonNull Disposable disposable) throws Exception {
                CropImageView.this.mIsLoading.set(true);
            }
        }).doFinally(new Action(){

            public void run() throws Exception {
                CropImageView.this.mIsLoading.set(false);
            }
        });
    }

    public LoadRequest load(Uri sourceUri) {
        return new LoadRequest(this, sourceUri);
    }

    private void applyThumbnail(Uri sourceUri) {
        final Bitmap thumb = this.getThumbnail(sourceUri);
        if (thumb == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CropImageView.this.mAngle = CropImageView.this.mExifRotation;
                CropImageView.this.setImageDrawableInternal((Drawable)new BitmapDrawable(CropImageView.this.getResources(), thumb));
            }
        });
    }

    private Bitmap getImage(Uri sourceUri) {
        if (sourceUri == null) {
            throw new IllegalStateException("Source Uri must not be null.");
        }
        this.mExifRotation = Utils.getExifOrientation(this.getContext(), this.mSourceUri);
        int maxSize = Utils.getMaxSize();
        int requestSize = Math.max(this.mViewWidth, this.mViewHeight);
        if (requestSize == 0) {
            requestSize = maxSize;
        }
        Bitmap sampledBitmap = Utils.decodeSampledBitmapFromUri(this.getContext(), this.mSourceUri, requestSize);
        this.mInputImageWidth = Utils.sInputImageWidth;
        this.mInputImageHeight = Utils.sInputImageHeight;
        return sampledBitmap;
    }

    private Bitmap getThumbnail(Uri sourceUri) {
        if (sourceUri == null) {
            throw new IllegalStateException("Source Uri must not be null.");
        }
        this.mExifRotation = Utils.getExifOrientation(this.getContext(), this.mSourceUri);
        int requestSize = (int)((float)Math.max(this.mViewWidth, this.mViewHeight) * 0.1f);
        if (requestSize == 0) {
            return null;
        }
        Bitmap sampledBitmap = Utils.decodeSampledBitmapFromUri(this.getContext(), this.mSourceUri, requestSize);
        this.mInputImageWidth = Utils.sInputImageWidth;
        this.mInputImageHeight = Utils.sInputImageHeight;
        return sampledBitmap;
    }

    public void rotateImage(RotateDegrees degrees, int durationMillis) {
        if (this.mIsRotating) {
            this.getAnimator().cancelAnimation();
        }
        final float currentAngle = this.mAngle;
        final float newAngle = this.mAngle + (float)degrees.getValue();
        final float angleDiff = newAngle - currentAngle;
        final float currentScale = this.mScale;
        final float newScale = this.calcScale(this.mViewWidth, this.mViewHeight, newAngle);
        if (this.mIsAnimationEnabled) {
            final float scaleDiff = newScale - currentScale;
            SimpleValueAnimator animator = this.getAnimator();
            animator.addAnimatorListener(new SimpleValueAnimatorListener(){

                @Override
                public void onAnimationStarted() {
                    CropImageView.this.mIsRotating = true;
                }

                @Override
                public void onAnimationUpdated(float scale) {
                    CropImageView.this.mAngle = currentAngle + angleDiff * scale;
                    CropImageView.this.mScale = currentScale + scaleDiff * scale;
                    CropImageView.this.setMatrix();
                    CropImageView.this.invalidate();
                }

                @Override
                public void onAnimationFinished() {
                    CropImageView.this.mAngle = newAngle % 360.0f;
                    CropImageView.this.mScale = newScale;
                    CropImageView.this.mInitialFrameRect = null;
                    CropImageView.this.setupLayout(CropImageView.this.mViewWidth, CropImageView.this.mViewHeight);
                    CropImageView.this.mIsRotating = false;
                }
            });
            animator.startAnimation(durationMillis);
        } else {
            this.mAngle = newAngle % 360.0f;
            this.mScale = newScale;
            this.setupLayout(this.mViewWidth, this.mViewHeight);
        }
    }

    public void rotateImage(RotateDegrees degrees) {
        this.rotateImage(degrees, this.mAnimationDurationMillis);
    }

    public Bitmap getCroppedBitmap() {
        Rect cropRect;
        Bitmap cropped;
        Bitmap source = this.getBitmap();
        if (source == null) {
            return null;
        }
        Bitmap rotated = this.getRotatedBitmap(source);
        if (rotated != (cropped = Bitmap.createBitmap((Bitmap)rotated, (int)cropRect.left, (int)cropRect.top, (int)(cropRect = this.calcCropRect(source.getWidth(), source.getHeight())).width(), (int)cropRect.height(), null, (boolean)false)) && rotated != source) {
            rotated.recycle();
        }
        if (this.mCropMode == CropMode.CIRCLE) {
            Bitmap circle = this.getCircularBitmap(cropped);
            if (cropped != this.getBitmap()) {
                cropped.recycle();
            }
            cropped = circle;
        }
        return cropped;
    }

    public Bitmap getCircularBitmap(Bitmap square) {
        if (square == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)square.getWidth(), (int)square.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Rect rect = new Rect(0, 0, square.getWidth(), square.getHeight());
        Canvas canvas = new Canvas(output);
        int halfWidth = square.getWidth() / 2;
        int halfHeight = square.getHeight() / 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        canvas.drawCircle((float)halfWidth, (float)halfHeight, (float)Math.min(halfWidth, halfHeight), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(square, rect, rect, paint);
        return output;
    }

    public void startCrop(final Uri saveUri, final CropCallback cropCallback, final SaveCallback saveCallback) {
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Bitmap croppedImage = null;
                try {
                    CropImageView.this.mIsCropping.set(true);
                    final Bitmap cropped = croppedImage = CropImageView.this.cropImage();
                    CropImageView.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (cropCallback != null) {
                                cropCallback.onSuccess(cropped);
                            }
                            if (CropImageView.this.mIsDebug) {
                                CropImageView.this.invalidate();
                            }
                        }
                    });
                    CropImageView.this.saveImage(croppedImage, saveUri);
                    CropImageView.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (saveCallback != null) {
                                saveCallback.onSuccess(saveUri);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (croppedImage == null) {
                        CropImageView.this.postErrorOnMainThread(cropCallback, e);
                    } else {
                        CropImageView.this.postErrorOnMainThread(saveCallback, e);
                    }
                }
                finally {
                    CropImageView.this.mIsCropping.set(false);
                }
            }
        });
    }

    public void cropAsync(final Uri sourceUri, final CropCallback cropCallback) {
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CropImageView.this.mIsCropping.set(true);
                    if (sourceUri != null) {
                        CropImageView.this.mSourceUri = sourceUri;
                    }
                    final Bitmap cropped = CropImageView.this.cropImage();
                    CropImageView.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (cropCallback != null) {
                                cropCallback.onSuccess(cropped);
                            }
                            if (CropImageView.this.mIsDebug) {
                                CropImageView.this.invalidate();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    CropImageView.this.postErrorOnMainThread(cropCallback, e);
                }
                finally {
                    CropImageView.this.mIsCropping.set(false);
                }
            }
        });
    }

    public void cropAsync(CropCallback cropCallback) {
        this.cropAsync(null, cropCallback);
    }

    public Single<Bitmap> cropAsSingle(final Uri sourceUri) {
        return Single.fromCallable((Callable)new Callable<Bitmap>(){

            @Override
            public Bitmap call() throws Exception {
                if (sourceUri != null) {
                    CropImageView.this.mSourceUri = sourceUri;
                }
                return CropImageView.this.cropImage();
            }
        }).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(@NonNull Disposable disposable) throws Exception {
                CropImageView.this.mIsCropping.set(true);
            }
        }).doFinally(new Action(){

            public void run() throws Exception {
                CropImageView.this.mIsCropping.set(false);
            }
        });
    }

    public Single<Bitmap> cropAsSingle() {
        return this.cropAsSingle(null);
    }

    public CropRequest crop(Uri sourceUri) {
        return new CropRequest(this, sourceUri);
    }

    public void saveAsync(final Uri saveUri, final Bitmap image, final SaveCallback saveCallback) {
        this.mExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CropImageView.this.mIsSaving.set(true);
                    CropImageView.this.saveImage(image, saveUri);
                    CropImageView.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (saveCallback != null) {
                                saveCallback.onSuccess(saveUri);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    CropImageView.this.postErrorOnMainThread(saveCallback, e);
                }
                finally {
                    CropImageView.this.mIsSaving.set(false);
                }
            }
        });
    }

    public Single<Uri> saveAsSingle(final Bitmap bitmap, final Uri saveUri) {
        return Single.fromCallable((Callable)new Callable<Uri>(){

            @Override
            public Uri call() throws Exception {
                return CropImageView.this.saveImage(bitmap, saveUri);
            }
        }).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(@NonNull Disposable disposable) throws Exception {
                CropImageView.this.mIsSaving.set(true);
            }
        }).doFinally(new Action(){

            public void run() throws Exception {
                CropImageView.this.mIsSaving.set(false);
            }
        });
    }

    public SaveRequest save(Bitmap bitmap) {
        return new SaveRequest(this, bitmap);
    }

    private Bitmap cropImage() throws IOException, IllegalStateException {
        Bitmap cropped;
        if (this.mSourceUri == null) {
            cropped = this.getCroppedBitmap();
        } else {
            cropped = this.getCroppedBitmapFromUri();
            if (this.mCropMode == CropMode.CIRCLE) {
                Bitmap circle = this.getCircularBitmap(cropped);
                if (cropped != this.getBitmap()) {
                    cropped.recycle();
                }
                cropped = circle;
            }
        }
        cropped = this.scaleBitmapIfNeeded(cropped);
        this.mOutputImageWidth = cropped.getWidth();
        this.mOutputImageHeight = cropped.getHeight();
        return cropped;
    }

    public RectF getActualCropRect() {
        if (this.mImageRect == null) {
            return null;
        }
        float offsetX = this.mImageRect.left / this.mScale;
        float offsetY = this.mImageRect.top / this.mScale;
        float l = this.mFrameRect.left / this.mScale - offsetX;
        float t = this.mFrameRect.top / this.mScale - offsetY;
        float r = this.mFrameRect.right / this.mScale - offsetX;
        float b = this.mFrameRect.bottom / this.mScale - offsetY;
        l = Math.max(0.0f, l);
        t = Math.max(0.0f, t);
        r = Math.min(this.mImageRect.right / this.mScale, r);
        b = Math.min(this.mImageRect.bottom / this.mScale, b);
        return new RectF(l, t, r, b);
    }

    private RectF applyInitialFrameRect(RectF initialFrameRect) {
        RectF frameRect = new RectF();
        frameRect.set(initialFrameRect.left * this.mScale, initialFrameRect.top * this.mScale, initialFrameRect.right * this.mScale, initialFrameRect.bottom * this.mScale);
        frameRect.offset(this.mImageRect.left, this.mImageRect.top);
        float l = Math.max(this.mImageRect.left, frameRect.left);
        float t = Math.max(this.mImageRect.top, frameRect.top);
        float r = Math.min(this.mImageRect.right, frameRect.right);
        float b = Math.min(this.mImageRect.bottom, frameRect.bottom);
        frameRect.set(l, t, r, b);
        return frameRect;
    }

    public void setCropMode(CropMode mode, int durationMillis) {
        if (mode == CropMode.CUSTOM) {
            this.setCustomRatio(1, 1);
        } else {
            this.mCropMode = mode;
            this.recalculateFrameRect(durationMillis);
        }
    }

    public void setCropMode(CropMode mode) {
        this.setCropMode(mode, this.mAnimationDurationMillis);
    }

    public void setCustomRatio(int ratioX, int ratioY, int durationMillis) {
        if (ratioX == 0 || ratioY == 0) {
            return;
        }
        this.mCropMode = CropMode.CUSTOM;
        this.mCustomRatio = new PointF((float)ratioX, (float)ratioY);
        this.recalculateFrameRect(durationMillis);
    }

    public void setCustomRatio(int ratioX, int ratioY) {
        this.setCustomRatio(ratioX, ratioY, this.mAnimationDurationMillis);
    }

    public void setOverlayColor(int overlayColor) {
        this.mOverlayColor = overlayColor;
        this.invalidate();
    }

    public void setFrameColor(int frameColor) {
        this.mFrameColor = frameColor;
        this.invalidate();
    }

    public void setHandleColor(int handleColor) {
        this.mHandleColor = handleColor;
        this.invalidate();
    }

    public void setGuideColor(int guideColor) {
        this.mGuideColor = guideColor;
        this.invalidate();
    }

    public void setBackgroundColor(int bgColor) {
        this.mBackgroundColor = bgColor;
        this.invalidate();
    }

    public void setMinFrameSizeInDp(int minDp) {
        this.mMinFrameSize = (float)minDp * this.getDensity();
    }

    public void setMinFrameSizeInPx(int minPx) {
        this.mMinFrameSize = minPx;
    }

    public void setHandleSizeInDp(int handleDp) {
        this.mHandleSize = (int)((float)handleDp * this.getDensity());
    }

    public void setTouchPaddingInDp(int paddingDp) {
        this.mTouchPadding = (int)((float)paddingDp * this.getDensity());
    }

    public void setGuideShowMode(ShowMode mode) {
        this.mGuideShowMode = mode;
        switch (mode) {
            case SHOW_ALWAYS: {
                this.mShowGuide = true;
                break;
            }
            case NOT_SHOW: 
            case SHOW_ON_TOUCH: {
                this.mShowGuide = false;
            }
        }
        this.invalidate();
    }

    public void setHandleShowMode(ShowMode mode) {
        this.mHandleShowMode = mode;
        switch (mode) {
            case SHOW_ALWAYS: {
                this.mShowHandle = true;
                break;
            }
            case NOT_SHOW: 
            case SHOW_ON_TOUCH: {
                this.mShowHandle = false;
            }
        }
        this.invalidate();
    }

    public void setFrameStrokeWeightInDp(int weightDp) {
        this.mFrameStrokeWeight = (float)weightDp * this.getDensity();
        this.invalidate();
    }

    public void setGuideStrokeWeightInDp(int weightDp) {
        this.mGuideStrokeWeight = (float)weightDp * this.getDensity();
        this.invalidate();
    }

    public void setCropEnabled(boolean enabled) {
        this.mIsCropEnabled = enabled;
        this.invalidate();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    public void setInitialFrameScale(float initialScale) {
        this.mInitialFrameScale = this.constrain(initialScale, 0.01f, 1.0f, 1.0f);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.mIsAnimationEnabled = enabled;
    }

    public void setAnimationDuration(int durationMillis) {
        this.mAnimationDurationMillis = durationMillis;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mAnimator = null;
        this.setupAnimatorIfNeeded();
    }

    public void setDebug(boolean debug) {
        this.mIsDebug = debug;
        Logger.enabled = true;
        this.invalidate();
    }

    public void setLoggingEnabled(boolean enabled) {
        Logger.enabled = enabled;
    }

    public void setOutputWidth(int outputWidth) {
        this.mOutputWidth = outputWidth;
        this.mOutputHeight = 0;
    }

    public void setOutputHeight(int outputHeight) {
        this.mOutputHeight = outputHeight;
        this.mOutputWidth = 0;
    }

    public void setOutputMaxSize(int maxWidth, int maxHeight) {
        this.mOutputMaxWidth = maxWidth;
        this.mOutputMaxHeight = maxHeight;
    }

    public void setCompressFormat(Bitmap.CompressFormat format) {
        this.mCompressFormat = format;
    }

    public void setCompressQuality(int quality) {
        this.mCompressQuality = quality;
    }

    public void setHandleShadowEnabled(boolean handleShadowEnabled) {
        this.mIsHandleShadowEnabled = handleShadowEnabled;
    }

    public boolean isCropping() {
        return this.mIsCropping.get();
    }

    public Uri getSourceUri() {
        return this.mSourceUri;
    }

    public Uri getSaveUri() {
        return this.mSaveUri;
    }

    public boolean isSaving() {
        return this.mIsSaving.get();
    }

    private void setScale(float mScale) {
        this.mScale = mScale;
    }

    private void setCenter(PointF mCenter) {
        this.mCenter = mCenter;
    }

    private float getFrameW() {
        return this.mFrameRect.right - this.mFrameRect.left;
    }

    private float getFrameH() {
        return this.mFrameRect.bottom - this.mFrameRect.top;
    }

    public static class SavedState
    extends View.BaseSavedState {
        CropMode mode;
        int backgroundColor;
        int overlayColor;
        int frameColor;
        ShowMode guideShowMode;
        ShowMode handleShowMode;
        boolean showGuide;
        boolean showHandle;
        int handleSize;
        int touchPadding;
        float minFrameSize;
        float customRatioX;
        float customRatioY;
        float frameStrokeWeight;
        float guideStrokeWeight;
        boolean isCropEnabled;
        int handleColor;
        int guideColor;
        float initialFrameScale;
        float angle;
        boolean isAnimationEnabled;
        int animationDuration;
        int exifRotation;
        Uri sourceUri;
        Uri saveUri;
        Bitmap.CompressFormat compressFormat;
        int compressQuality;
        boolean isDebug;
        int outputMaxWidth;
        int outputMaxHeight;
        int outputWidth;
        int outputHeight;
        boolean isHandleShadowEnabled;
        int inputImageWidth;
        int inputImageHeight;
        int outputImageWidth;
        int outputImageHeight;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

            public SavedState createFromParcel(Parcel inParcel) {
                return new SavedState(inParcel);
            }

            public SavedState[] newArray(int inSize) {
                return new SavedState[inSize];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mode = (CropMode)((Object)in.readSerializable());
            this.backgroundColor = in.readInt();
            this.overlayColor = in.readInt();
            this.frameColor = in.readInt();
            this.guideShowMode = (ShowMode)((Object)in.readSerializable());
            this.handleShowMode = (ShowMode)((Object)in.readSerializable());
            this.showGuide = in.readInt() != 0;
            this.showHandle = in.readInt() != 0;
            this.handleSize = in.readInt();
            this.touchPadding = in.readInt();
            this.minFrameSize = in.readFloat();
            this.customRatioX = in.readFloat();
            this.customRatioY = in.readFloat();
            this.frameStrokeWeight = in.readFloat();
            this.guideStrokeWeight = in.readFloat();
            this.isCropEnabled = in.readInt() != 0;
            this.handleColor = in.readInt();
            this.guideColor = in.readInt();
            this.initialFrameScale = in.readFloat();
            this.angle = in.readFloat();
            this.isAnimationEnabled = in.readInt() != 0;
            this.animationDuration = in.readInt();
            this.exifRotation = in.readInt();
            this.sourceUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
            this.saveUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
            this.compressFormat = (Bitmap.CompressFormat)in.readSerializable();
            this.compressQuality = in.readInt();
            this.isDebug = in.readInt() != 0;
            this.outputMaxWidth = in.readInt();
            this.outputMaxHeight = in.readInt();
            this.outputWidth = in.readInt();
            this.outputHeight = in.readInt();
            this.isHandleShadowEnabled = in.readInt() != 0;
            this.inputImageWidth = in.readInt();
            this.inputImageHeight = in.readInt();
            this.outputImageWidth = in.readInt();
            this.outputImageHeight = in.readInt();
        }

        public void writeToParcel(Parcel out, int flag) {
            super.writeToParcel(out, flag);
            out.writeSerializable((Serializable)((Object)this.mode));
            out.writeInt(this.backgroundColor);
            out.writeInt(this.overlayColor);
            out.writeInt(this.frameColor);
            out.writeSerializable((Serializable)((Object)this.guideShowMode));
            out.writeSerializable((Serializable)((Object)this.handleShowMode));
            out.writeInt(this.showGuide ? 1 : 0);
            out.writeInt(this.showHandle ? 1 : 0);
            out.writeInt(this.handleSize);
            out.writeInt(this.touchPadding);
            out.writeFloat(this.minFrameSize);
            out.writeFloat(this.customRatioX);
            out.writeFloat(this.customRatioY);
            out.writeFloat(this.frameStrokeWeight);
            out.writeFloat(this.guideStrokeWeight);
            out.writeInt(this.isCropEnabled ? 1 : 0);
            out.writeInt(this.handleColor);
            out.writeInt(this.guideColor);
            out.writeFloat(this.initialFrameScale);
            out.writeFloat(this.angle);
            out.writeInt(this.isAnimationEnabled ? 1 : 0);
            out.writeInt(this.animationDuration);
            out.writeInt(this.exifRotation);
            out.writeParcelable((Parcelable)this.sourceUri, flag);
            out.writeParcelable((Parcelable)this.saveUri, flag);
            out.writeSerializable((Serializable)this.compressFormat);
            out.writeInt(this.compressQuality);
            out.writeInt(this.isDebug ? 1 : 0);
            out.writeInt(this.outputMaxWidth);
            out.writeInt(this.outputMaxHeight);
            out.writeInt(this.outputWidth);
            out.writeInt(this.outputHeight);
            out.writeInt(this.isHandleShadowEnabled ? 1 : 0);
            out.writeInt(this.inputImageWidth);
            out.writeInt(this.inputImageHeight);
            out.writeInt(this.outputImageWidth);
            out.writeInt(this.outputImageHeight);
        }
    }

    public static enum RotateDegrees {
        ROTATE_90D(90),
        ROTATE_180D(180),
        ROTATE_270D(270),
        ROTATE_M90D(-90),
        ROTATE_M180D(-180),
        ROTATE_M270D(-270);

        private final int VALUE;

        private RotateDegrees(int value) {
            this.VALUE = value;
        }

        public int getValue() {
            return this.VALUE;
        }
    }

    public static enum ShowMode {
        SHOW_ALWAYS(1),
        SHOW_ON_TOUCH(2),
        NOT_SHOW(3);

        private final int ID;

        private ShowMode(int id) {
            this.ID = id;
        }

        public int getId() {
            return this.ID;
        }
    }

    public static enum CropMode {
        FIT_IMAGE(0),
        RATIO_4_3(1),
        RATIO_3_4(2),
        SQUARE(3),
        RATIO_16_9(4),
        RATIO_9_16(5),
        FREE(6),
        CUSTOM(7),
        CIRCLE(8),
        CIRCLE_SQUARE(9);

        private final int ID;

        private CropMode(int id) {
            this.ID = id;
        }

        public int getId() {
            return this.ID;
        }
    }

    private static enum TouchArea {
        OUT_OF_BOUNDS,
        CENTER,
        LEFT_TOP,
        RIGHT_TOP,
        LEFT_BOTTOM,
        RIGHT_BOTTOM;

    }
}

