/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview;

import android.graphics.Bitmap;
import android.net.Uri;
import com.isseiaoki.simplecropview.CropImageView;
import com.isseiaoki.simplecropview.callback.SaveCallback;
import io.reactivex.Single;

public class SaveRequest {
    private CropImageView cropImageView;
    private Bitmap image;
    private Bitmap.CompressFormat compressFormat;
    private int compressQuality = -1;

    public SaveRequest(CropImageView cropImageView, Bitmap image) {
        this.cropImageView = cropImageView;
        this.image = image;
    }

    public SaveRequest compressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
        return this;
    }

    public SaveRequest compressQuality(int compressQuality) {
        this.compressQuality = compressQuality;
        return this;
    }

    private void build() {
        if (this.compressFormat != null) {
            this.cropImageView.setCompressFormat(this.compressFormat);
        }
        if (this.compressQuality >= 0) {
            this.cropImageView.setCompressQuality(this.compressQuality);
        }
    }

    public void execute(Uri saveUri, SaveCallback callback) {
        this.build();
        this.cropImageView.saveAsync(saveUri, this.image, callback);
    }

    public Single<Uri> executeAsSingle(Uri saveUri) {
        this.build();
        return this.cropImageView.saveAsSingle(this.image, saveUri);
    }
}

