/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.view.animation.Interpolator;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimator;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimatorListener;

@TargetApi(value=14)
public class ValueAnimatorV14
implements SimpleValueAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private static final int DEFAULT_ANIMATION_DURATION = 150;
    private ValueAnimator animator;
    private SimpleValueAnimatorListener animatorListener = new SimpleValueAnimatorListener(){

        @Override
        public void onAnimationStarted() {
        }

        @Override
        public void onAnimationUpdated(float scale) {
        }

        @Override
        public void onAnimationFinished() {
        }
    };

    public ValueAnimatorV14(Interpolator interpolator) {
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animator.setInterpolator((TimeInterpolator)interpolator);
    }

    @Override
    public void startAnimation(long duration) {
        if (duration >= 0L) {
            this.animator.setDuration(duration);
        } else {
            this.animator.setDuration(150L);
        }
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void addAnimatorListener(SimpleValueAnimatorListener animatorListener) {
        if (animatorListener != null) {
            this.animatorListener = animatorListener;
        }
    }

    public void onAnimationStart(Animator animation) {
        this.animatorListener.onAnimationStarted();
    }

    public void onAnimationEnd(Animator animation) {
        this.animatorListener.onAnimationFinished();
    }

    public void onAnimationCancel(Animator animation) {
        this.animatorListener.onAnimationFinished();
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.animatorListener.onAnimationUpdated(animation.getAnimatedFraction());
    }
}

