/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview.animation;

import android.os.SystemClock;
import android.view.animation.Interpolator;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimator;
import com.isseiaoki.simplecropview.animation.SimpleValueAnimatorListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ValueAnimatorV8
implements SimpleValueAnimator {
    private static final int FRAME_RATE = 30;
    private static final int UPDATE_SPAN = Math.round(33.333332f);
    private static final int DEFAULT_ANIMATION_DURATION = 150;
    private Interpolator mInterpolator;
    ScheduledExecutorService service;
    long start;
    boolean isAnimationStarted = false;
    long duration;
    private SimpleValueAnimatorListener animatorListener = new SimpleValueAnimatorListener(){

        @Override
        public void onAnimationStarted() {
        }

        @Override
        public void onAnimationUpdated(float scale) {
        }

        @Override
        public void onAnimationFinished() {
        }
    };
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            long elapsed = SystemClock.uptimeMillis() - ValueAnimatorV8.this.start;
            if (elapsed > ValueAnimatorV8.this.duration) {
                ValueAnimatorV8.this.isAnimationStarted = false;
                ValueAnimatorV8.this.animatorListener.onAnimationFinished();
                ValueAnimatorV8.this.service.shutdown();
                return;
            }
            float scale = Math.min(ValueAnimatorV8.this.mInterpolator.getInterpolation((float)elapsed / (float)ValueAnimatorV8.this.duration), 1.0f);
            ValueAnimatorV8.this.animatorListener.onAnimationUpdated(scale);
        }
    };

    public ValueAnimatorV8(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @Override
    public void startAnimation(long duration) {
        this.duration = duration >= 0L ? duration : 150L;
        this.isAnimationStarted = true;
        this.animatorListener.onAnimationStarted();
        this.start = SystemClock.uptimeMillis();
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(this.runnable, 0L, UPDATE_SPAN, TimeUnit.MILLISECONDS);
    }

    @Override
    public void cancelAnimation() {
        this.isAnimationStarted = false;
        this.service.shutdown();
        this.animatorListener.onAnimationFinished();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    @Override
    public void addAnimatorListener(SimpleValueAnimatorListener animatorListener) {
        if (animatorListener != null) {
            this.animatorListener = animatorListener;
        }
    }
}

