/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview.util;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.opengl.GLES10;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.isseiaoki.simplecropview.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    private static final int SIZE_DEFAULT = 2048;
    private static final int SIZE_LIMIT = 4096;
    public static int sInputImageWidth = 0;
    public static int sInputImageHeight = 0;

    public static int getExifRotation(File file) {
        if (file == null) {
            return 0;
        }
        try {
            ExifInterface exif = new ExifInterface(file.getAbsolutePath());
            return Utils.getRotateDegreeFromOrientation(exif.getAttributeInt("Orientation", 0));
        }
        catch (IOException e) {
            Logger.e("An error occurred while getting the exif data: " + e.getMessage(), e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExifOrientation(Context context, Uri uri) {
        int n;
        Cursor cursor = null;
        String[] projection = new String[]{"orientation"};
        try {
            cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n2 = 0;
                Utils.closeQuietly((Closeable)cursor);
                return n2;
            }
            n = cursor.getInt(0);
            Utils.closeQuietly((Closeable)cursor);
        }
        catch (RuntimeException ignored) {
            int n3 = 0;
            return n3;
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return n;
    }

    public static int getRotateDegreeFromOrientation(int orientation) {
        int degree = 0;
        switch (orientation) {
            case 6: {
                degree = 90;
                break;
            }
            case 3: {
                degree = 180;
                break;
            }
            case 8: {
                degree = 270;
                break;
            }
        }
        return degree;
    }

    public static Matrix getMatrixFromExifOrientation(int orientation) {
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                break;
            }
            case 4: {
                matrix.postScale(1.0f, -1.0f);
                break;
            }
            case 6: {
                matrix.postRotate(90.0f);
                break;
            }
            case 7: {
                matrix.postRotate(-90.0f);
                matrix.postScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.postRotate(90.0f);
                matrix.postScale(1.0f, -1.0f);
                break;
            }
            case 8: {
                matrix.postRotate(-90.0f);
            }
        }
        return matrix;
    }

    public static int getExifOrientationFromAngle(int angle) {
        int normalizedAngle = angle % 360;
        switch (normalizedAngle) {
            case 0: {
                return 1;
            }
            case 90: {
                return 6;
            }
            case 180: {
                return 3;
            }
            case 270: {
                return 8;
            }
        }
        return 1;
    }

    @TargetApi(value=19)
    public static File getFileFromUri(Context context, Uri uri) {
        boolean isKitkat;
        String filePath = null;
        boolean bl = isKitkat = Build.VERSION.SDK_INT >= 19;
        if (isKitkat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (Utils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    filePath = Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else if (Utils.isDownloadsDocument(uri)) {
                String id = DocumentsContract.getDocumentId((Uri)uri);
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                filePath = Utils.getDataColumn(context, contentUri, null, null);
            } else if (Utils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                filePath = Utils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
            } else if (Utils.isGoogleDriveDocument(uri)) {
                return Utils.getGoogleDriveFile(context, uri);
            }
        } else if ("content".equalsIgnoreCase(uri.getScheme())) {
            filePath = Utils.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : Utils.getDataColumn(context, uri, null, null);
        } else if ("file".equalsIgnoreCase(uri.getScheme())) {
            filePath = uri.getPath();
        }
        if (filePath != null) {
            return new File(filePath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block2: {
            String string;
            cursor = null;
            String[] projection = new String[]{"_data", "_display_name"};
            try {
                int columnIndex;
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block2;
                int n = columnIndex = uri.toString().startsWith("content://com.google.android.gallery3d") ? cursor.getColumnIndex("_display_name") : cursor.getColumnIndex("_data");
                if (columnIndex == -1) break block2;
                string = cursor.getString(columnIndex);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(cursor);
                throw throwable;
            }
            Utils.closeQuietly((Closeable)cursor);
            return string;
        }
        Utils.closeQuietly((Closeable)cursor);
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isGoogleDriveDocument(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static File getGoogleDriveFile(Context context, Uri uri) {
        block8: {
            File file;
            ParcelFileDescriptor pfd;
            String filePath;
            FileOutputStream output;
            FileInputStream input;
            block7: {
                if (uri == null) {
                    return null;
                }
                input = null;
                output = null;
                filePath = new File(context.getCacheDir(), "tmp").getAbsolutePath();
                pfd = context.getContentResolver().openFileDescriptor(uri, "r");
                if (pfd != null) break block7;
                File file2 = null;
                Utils.closeQuietly(input);
                Utils.closeQuietly(output);
                return file2;
            }
            try {
                int read;
                FileDescriptor fd = pfd.getFileDescriptor();
                input = new FileInputStream(fd);
                output = new FileOutputStream(filePath);
                byte[] bytes = new byte[4096];
                while ((read = input.read(bytes)) != -1) {
                    output.write(bytes, 0, read);
                }
                file = new File(filePath);
            }
            catch (IOException ignored) {
                Utils.closeQuietly(input);
                Utils.closeQuietly(output);
                break block8;
                catch (Throwable throwable) {
                    Utils.closeQuietly(input);
                    Utils.closeQuietly(output);
                    throw throwable;
                }
            }
            Utils.closeQuietly(input);
            Utils.closeQuietly(output);
            return file;
        }
        return null;
    }

    public static Bitmap decodeSampledBitmapFromUri(Context context, Uri sourceUri, int requestSize) {
        InputStream is = null;
        try {
            is = context.getContentResolver().openInputStream(sourceUri);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = Utils.calculateInSampleSize(context, sourceUri, requestSize);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int calculateInSampleSize(Context context, Uri sourceUri, int requestSize) {
        InputStream is = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            is = context.getContentResolver().openInputStream(sourceUri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
        catch (FileNotFoundException ignored) {
            Utils.closeQuietly(is);
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly(is);
        int inSampleSize = 1;
        sInputImageWidth = options.outWidth;
        sInputImageHeight = options.outHeight;
        while (options.outWidth / inSampleSize > requestSize || options.outHeight / inSampleSize > requestSize) {
            inSampleSize *= 2;
        }
        return inSampleSize;
    }

    public static Bitmap getScaledBitmapForHeight(Bitmap bitmap, int outHeight) {
        float currentWidth = bitmap.getWidth();
        float currentHeight = bitmap.getHeight();
        float ratio = currentWidth / currentHeight;
        int outWidth = Math.round((float)outHeight * ratio);
        return Utils.getScaledBitmap(bitmap, outWidth, outHeight);
    }

    public static Bitmap getScaledBitmapForWidth(Bitmap bitmap, int outWidth) {
        float currentWidth = bitmap.getWidth();
        float currentHeight = bitmap.getHeight();
        float ratio = currentWidth / currentHeight;
        int outHeight = Math.round((float)outWidth / ratio);
        return Utils.getScaledBitmap(bitmap, outWidth, outHeight);
    }

    public static Bitmap getScaledBitmap(Bitmap bitmap, int outWidth, int outHeight) {
        int currentWidth = bitmap.getWidth();
        int currentHeight = bitmap.getHeight();
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.postScale((float)outWidth / (float)currentWidth, (float)outHeight / (float)currentHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)currentWidth, (int)currentHeight, (Matrix)scaleMatrix, (boolean)true);
    }

    public static int getMaxSize() {
        int maxSize = 2048;
        int[] arr = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])arr, (int)0);
        if (arr[0] > 0) {
            maxSize = Math.min(arr[0], 4096);
        }
        return maxSize;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

