/*
 * Decompiled with CFR 0.152.
 */
package com.isseiaoki.simplecropview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import com.isseiaoki.simplecropview.R;
import java.io.Serializable;

public class CropImageView
extends ImageView {
    private static final String TAG = CropImageView.class.getSimpleName();
    private static final int HANDLE_SIZE_IN_DP = 16;
    private static final int MIN_FRAME_SIZE_IN_DP = 50;
    private static final int FRAME_STROKE_WEIGHT_IN_DP = 1;
    private static final int GUIDE_STROKE_WEIGHT_IN_DP = 1;
    private static final float DEFAULT_INITIAL_FRAME_SCALE = 0.75f;
    private final int TRANSPARENT;
    private final int TRANSLUCENT_WHITE = -1140850689;
    private final int WHITE = -1;
    private final int TRANSLUCENT_BLACK = -1157627904;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private float mScale = 1.0f;
    private float mAngle = 0.0f;
    private float mImgWidth = 0.0f;
    private float mImgHeight = 0.0f;
    private boolean mIsInitialized = false;
    private Matrix mMatrix = null;
    private Paint mPaintTransparent;
    private Paint mPaintFrame;
    private Paint mPaintBitmap;
    private RectF mFrameRect;
    private RectF mImageRect;
    private PointF mCenter = new PointF();
    private float mLastX;
    private float mLastY;
    private TouchArea mTouchArea = TouchArea.OUT_OF_BOUNDS;
    private CropMode mCropMode = CropMode.RATIO_1_1;
    private ShowMode mGuideShowMode = ShowMode.SHOW_ALWAYS;
    private ShowMode mHandleShowMode = ShowMode.SHOW_ALWAYS;
    private float mMinFrameSize;
    private int mHandleSize;
    private int mTouchPadding = 0;
    private boolean mShowGuide = true;
    private boolean mShowHandle = true;
    private boolean mIsCropEnabled = true;
    private boolean mIsEnabled = true;
    private PointF mCustomRatio = new PointF(1.0f, 1.0f);
    private float mFrameStrokeWeight = 3.0f;
    private float mGuideStrokeWeight = 3.0f;
    private int mBackgroundColor;
    private int mOverlayColor;
    private int mFrameColor;
    private int mHandleColor;
    private int mGuideColor;
    private float mInitialFrameScale;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.TRANSPARENT = this.getResources().getColor(17170445);
        float mDensity = this.getDensity();
        this.mHandleSize = (int)(mDensity * 16.0f);
        this.mMinFrameSize = mDensity * 50.0f;
        this.mFrameStrokeWeight = mDensity * 1.0f;
        this.mGuideStrokeWeight = mDensity * 1.0f;
        this.mPaintFrame = new Paint();
        this.mPaintTransparent = new Paint();
        this.mPaintBitmap = new Paint();
        this.mPaintBitmap.setFilterBitmap(true);
        this.mMatrix = new Matrix();
        this.mScale = 1.0f;
        this.mBackgroundColor = this.TRANSPARENT;
        this.mFrameColor = -1;
        this.mOverlayColor = -1157627904;
        this.mHandleColor = -1;
        this.mGuideColor = -1140850689;
        this.handleStyleable(context, attrs, defStyle, mDensity);
    }

    public Parcelable onSaveInstanceState() {
        Bitmap bm;
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.image = bm = this.getBitmap();
        ss.mode = this.mCropMode;
        ss.backgroundColor = this.mBackgroundColor;
        ss.overlayColor = this.mOverlayColor;
        ss.frameColor = this.mFrameColor;
        ss.guideShowMode = this.mGuideShowMode;
        ss.handleShowMode = this.mHandleShowMode;
        ss.showGuide = this.mShowGuide;
        ss.showHandle = this.mShowHandle;
        ss.handleSize = this.mHandleSize;
        ss.touchPadding = this.mTouchPadding;
        ss.minFrameSize = this.mMinFrameSize;
        ss.customRatioX = this.mCustomRatio.x;
        ss.customRatioY = this.mCustomRatio.y;
        ss.frameStrokeWeight = this.mFrameStrokeWeight;
        ss.guideStrokeWeight = this.mGuideStrokeWeight;
        ss.isCropEnabled = this.mIsCropEnabled;
        ss.handleColor = this.mHandleColor;
        ss.guideColor = this.mGuideColor;
        ss.initialFrameScale = this.mInitialFrameScale;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mCropMode = ss.mode;
        this.mBackgroundColor = ss.backgroundColor;
        this.mOverlayColor = ss.overlayColor;
        this.mFrameColor = ss.frameColor;
        this.mGuideShowMode = ss.guideShowMode;
        this.mHandleShowMode = ss.handleShowMode;
        this.mShowGuide = ss.showGuide;
        this.mShowHandle = ss.showHandle;
        this.mHandleSize = ss.handleSize;
        this.mTouchPadding = ss.touchPadding;
        this.mMinFrameSize = ss.minFrameSize;
        this.mCustomRatio = new PointF(ss.customRatioX, ss.customRatioY);
        this.mFrameStrokeWeight = ss.frameStrokeWeight;
        this.mGuideStrokeWeight = ss.guideStrokeWeight;
        this.mIsCropEnabled = ss.isCropEnabled;
        this.mHandleColor = ss.handleColor;
        this.mGuideColor = ss.guideColor;
        this.mInitialFrameScale = ss.initialFrameScale;
        this.setImageBitmap(ss.image);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mViewWidth = r - l - this.getPaddingLeft() - this.getPaddingRight();
        this.mViewHeight = b - t - this.getPaddingTop() - this.getPaddingBottom();
        if (this.getDrawable() != null) {
            this.initLayout(this.mViewWidth, this.mViewHeight);
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIsInitialized) {
            this.setMatrix();
            Matrix localMatrix1 = new Matrix();
            localMatrix1.postConcat(this.mMatrix);
            Bitmap bm = this.getBitmap();
            if (bm != null) {
                canvas.drawBitmap(bm, localMatrix1, this.mPaintBitmap);
                this.drawEditFrame(canvas);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStyleable(Context context, AttributeSet attrs, int defStyle, float mDensity) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, defStyle, 0);
        this.mCropMode = CropMode.RATIO_1_1;
        try {
            Drawable drawable = ta.getDrawable(R.styleable.CropImageView_imgSrc);
            if (drawable != null) {
                this.setImageDrawable(drawable);
            }
            for (CropMode cropMode : CropMode.values()) {
                if (ta.getInt(R.styleable.CropImageView_cropMode, 3) != cropMode.getId()) continue;
                this.mCropMode = cropMode;
                break;
            }
            this.mBackgroundColor = ta.getColor(R.styleable.CropImageView_backgroundColor, this.TRANSPARENT);
            super.setBackgroundColor(this.mBackgroundColor);
            this.mOverlayColor = ta.getColor(R.styleable.CropImageView_overlayColor, -1157627904);
            this.mFrameColor = ta.getColor(R.styleable.CropImageView_frameColor, -1);
            this.mHandleColor = ta.getColor(R.styleable.CropImageView_handleColor, -1);
            this.mGuideColor = ta.getColor(R.styleable.CropImageView_guideColor, -1140850689);
            for (Enum enum_ : ShowMode.values()) {
                if (ta.getInt(R.styleable.CropImageView_guideShowMode, 1) != ((ShowMode)enum_).getId()) continue;
                this.mGuideShowMode = enum_;
                break;
            }
            for (Enum enum_ : ShowMode.values()) {
                if (ta.getInt(R.styleable.CropImageView_handleShowMode, 1) != ((ShowMode)enum_).getId()) continue;
                this.mHandleShowMode = enum_;
                break;
            }
            this.setGuideShowMode(this.mGuideShowMode);
            this.setHandleShowMode(this.mHandleShowMode);
            this.mHandleSize = ta.getDimensionPixelSize(R.styleable.CropImageView_handleSize, (int)(16.0f * mDensity));
            this.mTouchPadding = ta.getDimensionPixelSize(R.styleable.CropImageView_touchPadding, 0);
            this.mMinFrameSize = ta.getDimensionPixelSize(R.styleable.CropImageView_minFrameSize, (int)(50.0f * mDensity));
            this.mFrameStrokeWeight = ta.getDimensionPixelSize(R.styleable.CropImageView_frameStrokeWeight, (int)(1.0f * mDensity));
            this.mGuideStrokeWeight = ta.getDimensionPixelSize(R.styleable.CropImageView_guideStrokeWeight, (int)(1.0f * mDensity));
            this.mIsCropEnabled = ta.getBoolean(R.styleable.CropImageView_cropEnabled, true);
            this.mInitialFrameScale = this.constrain(ta.getFloat(R.styleable.CropImageView_initialFrameScale, 0.75f), 0.01f, 1.0f, 0.75f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ta.recycle();
        }
    }

    private void drawEditFrame(Canvas canvas) {
        if (!this.mIsCropEnabled) {
            return;
        }
        if (this.mCropMode == CropMode.CIRCLE) {
            this.mPaintTransparent.setFilterBitmap(true);
            this.mPaintTransparent.setColor(this.mOverlayColor);
            this.mPaintTransparent.setStyle(Paint.Style.FILL);
            Path path = new Path();
            path.addRect(this.mImageRect.left, this.mImageRect.top, this.mImageRect.right, this.mImageRect.bottom, Path.Direction.CW);
            path.addCircle((this.mFrameRect.left + this.mFrameRect.right) / 2.0f, (this.mFrameRect.top + this.mFrameRect.bottom) / 2.0f, (this.mFrameRect.right - this.mFrameRect.left) / 2.0f, Path.Direction.CCW);
            canvas.drawPath(path, this.mPaintTransparent);
        } else {
            this.mPaintTransparent.setFilterBitmap(true);
            this.mPaintTransparent.setColor(this.mOverlayColor);
            this.mPaintTransparent.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.mImageRect.left, this.mImageRect.top, this.mImageRect.right, this.mFrameRect.top, this.mPaintTransparent);
            canvas.drawRect(this.mImageRect.left, this.mFrameRect.bottom, this.mImageRect.right, this.mImageRect.bottom, this.mPaintTransparent);
            canvas.drawRect(this.mImageRect.left, this.mFrameRect.top, this.mFrameRect.left, this.mFrameRect.bottom, this.mPaintTransparent);
            canvas.drawRect(this.mFrameRect.right, this.mFrameRect.top, this.mImageRect.right, this.mFrameRect.bottom, this.mPaintTransparent);
        }
        this.mPaintFrame.setAntiAlias(true);
        this.mPaintFrame.setFilterBitmap(true);
        this.mPaintFrame.setStyle(Paint.Style.STROKE);
        this.mPaintFrame.setColor(this.mFrameColor);
        this.mPaintFrame.setStrokeWidth(this.mFrameStrokeWeight);
        canvas.drawRect(this.mFrameRect.left, this.mFrameRect.top, this.mFrameRect.right, this.mFrameRect.bottom, this.mPaintFrame);
        if (this.mShowGuide) {
            this.mPaintFrame.setColor(this.mGuideColor);
            this.mPaintFrame.setStrokeWidth(this.mGuideStrokeWeight);
            float h1 = this.mFrameRect.left + (this.mFrameRect.right - this.mFrameRect.left) / 3.0f;
            float h2 = this.mFrameRect.right - (this.mFrameRect.right - this.mFrameRect.left) / 3.0f;
            float v1 = this.mFrameRect.top + (this.mFrameRect.bottom - this.mFrameRect.top) / 3.0f;
            float v2 = this.mFrameRect.bottom - (this.mFrameRect.bottom - this.mFrameRect.top) / 3.0f;
            canvas.drawLine(h1, this.mFrameRect.top, h1, this.mFrameRect.bottom, this.mPaintFrame);
            canvas.drawLine(h2, this.mFrameRect.top, h2, this.mFrameRect.bottom, this.mPaintFrame);
            canvas.drawLine(this.mFrameRect.left, v1, this.mFrameRect.right, v1, this.mPaintFrame);
            canvas.drawLine(this.mFrameRect.left, v2, this.mFrameRect.right, v2, this.mPaintFrame);
        }
        if (this.mShowHandle) {
            this.mPaintFrame.setStyle(Paint.Style.FILL);
            this.mPaintFrame.setColor(this.mHandleColor);
            canvas.drawCircle(this.mFrameRect.left, this.mFrameRect.top, (float)this.mHandleSize, this.mPaintFrame);
            canvas.drawCircle(this.mFrameRect.right, this.mFrameRect.top, (float)this.mHandleSize, this.mPaintFrame);
            canvas.drawCircle(this.mFrameRect.left, this.mFrameRect.bottom, (float)this.mHandleSize, this.mPaintFrame);
            canvas.drawCircle(this.mFrameRect.right, this.mFrameRect.bottom, (float)this.mHandleSize, this.mPaintFrame);
        }
    }

    private void setMatrix() {
        this.mMatrix.reset();
        this.mMatrix.setTranslate(this.mCenter.x - this.mImgWidth * 0.5f, this.mCenter.y - this.mImgHeight * 0.5f);
        this.mMatrix.postScale(this.mScale, this.mScale, this.mCenter.x, this.mCenter.y);
        this.mMatrix.postRotate(this.mAngle, this.mCenter.x, this.mCenter.y);
    }

    private void initLayout(int viewW, int viewH) {
        this.mImgWidth = this.getDrawable().getIntrinsicWidth();
        this.mImgHeight = this.getDrawable().getIntrinsicHeight();
        if (this.mImgWidth <= 0.0f) {
            this.mImgWidth = viewW;
        }
        if (this.mImgHeight <= 0.0f) {
            this.mImgHeight = viewH;
        }
        float w = viewW;
        float h = viewH;
        float viewRatio = w / h;
        float imgRatio = this.mImgWidth / this.mImgHeight;
        float scale = 1.0f;
        if (imgRatio >= viewRatio) {
            scale = w / this.mImgWidth;
        } else if (imgRatio < viewRatio) {
            scale = h / this.mImgHeight;
        }
        this.setCenter(new PointF((float)this.getPaddingLeft() + w * 0.5f, (float)this.getPaddingTop() + h * 0.5f));
        this.setScale(scale);
        this.initCropFrame();
        this.adjustRatio();
        this.mIsInitialized = true;
    }

    private void initCropFrame() {
        this.setMatrix();
        float[] arrayOfFloat = new float[]{0.0f, 0.0f, 0.0f, this.mImgHeight, this.mImgWidth, 0.0f, this.mImgWidth, this.mImgHeight};
        this.mMatrix.mapPoints(arrayOfFloat);
        float l = arrayOfFloat[0];
        float t = arrayOfFloat[1];
        float r = arrayOfFloat[6];
        float b = arrayOfFloat[7];
        this.mFrameRect = new RectF(l, t, r, b);
        this.mImageRect = new RectF(l, t, r, b);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsInitialized) {
            return false;
        }
        if (!this.mIsCropEnabled) {
            return false;
        }
        if (!this.mIsEnabled) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onDown(event);
                return true;
            }
            case 2: {
                this.onMove(event);
                if (this.mTouchArea != TouchArea.OUT_OF_BOUNDS) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return true;
            }
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onCancel();
                return true;
            }
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onUp(event);
                return true;
            }
        }
        return false;
    }

    private void onDown(MotionEvent e) {
        this.invalidate();
        this.mLastX = e.getX();
        this.mLastY = e.getY();
        this.checkTouchArea(e.getX(), e.getY());
    }

    private void onMove(MotionEvent e) {
        float diffX = e.getX() - this.mLastX;
        float diffY = e.getY() - this.mLastY;
        switch (this.mTouchArea) {
            case CENTER: {
                this.moveFrame(diffX, diffY);
                break;
            }
            case LEFT_TOP: {
                this.moveHandleLT(diffX, diffY);
                break;
            }
            case RIGHT_TOP: {
                this.moveHandleRT(diffX, diffY);
                break;
            }
            case LEFT_BOTTOM: {
                this.moveHandleLB(diffX, diffY);
                break;
            }
            case RIGHT_BOTTOM: {
                this.moveHandleRB(diffX, diffY);
                break;
            }
        }
        this.invalidate();
        this.mLastX = e.getX();
        this.mLastY = e.getY();
    }

    private void onUp(MotionEvent e) {
        if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
            this.mShowGuide = false;
        }
        if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
            this.mShowHandle = false;
        }
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
        this.invalidate();
    }

    private void onCancel() {
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
        this.invalidate();
    }

    private void checkTouchArea(float x, float y) {
        if (this.isInsideCornerLeftTop(x, y)) {
            this.mTouchArea = TouchArea.LEFT_TOP;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerRightTop(x, y)) {
            this.mTouchArea = TouchArea.RIGHT_TOP;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerLeftBottom(x, y)) {
            this.mTouchArea = TouchArea.LEFT_BOTTOM;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideCornerRightBottom(x, y)) {
            this.mTouchArea = TouchArea.RIGHT_BOTTOM;
            if (this.mHandleShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowHandle = true;
            }
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            return;
        }
        if (this.isInsideFrame(x, y)) {
            if (this.mGuideShowMode == ShowMode.SHOW_ON_TOUCH) {
                this.mShowGuide = true;
            }
            this.mTouchArea = TouchArea.CENTER;
            return;
        }
        this.mTouchArea = TouchArea.OUT_OF_BOUNDS;
    }

    private boolean isInsideFrame(float x, float y) {
        if (this.mFrameRect.left <= x && this.mFrameRect.right >= x && this.mFrameRect.top <= y && this.mFrameRect.bottom >= y) {
            this.mTouchArea = TouchArea.CENTER;
            return true;
        }
        return false;
    }

    private boolean isInsideCornerLeftTop(float x, float y) {
        float dx = x - this.mFrameRect.left;
        float dy = y - this.mFrameRect.top;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerRightTop(float x, float y) {
        float dx = x - this.mFrameRect.right;
        float dy = y - this.mFrameRect.top;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerLeftBottom(float x, float y) {
        float dx = x - this.mFrameRect.left;
        float dy = y - this.mFrameRect.bottom;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private boolean isInsideCornerRightBottom(float x, float y) {
        float dx = x - this.mFrameRect.right;
        float dy = y - this.mFrameRect.bottom;
        float d = dx * dx + dy * dy;
        return this.sq(this.mHandleSize + this.mTouchPadding) >= d;
    }

    private void moveFrame(float x, float y) {
        this.mFrameRect.left += x;
        this.mFrameRect.right += x;
        this.mFrameRect.top += y;
        this.mFrameRect.bottom += y;
        this.checkMoveBounds();
    }

    private void moveHandleLT(float diffX, float diffY) {
        if (this.mCropMode == CropMode.RATIO_FREE) {
            this.mFrameRect.left += diffX;
            this.mFrameRect.top += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.left += dx;
            this.mFrameRect.top += dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top -= offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left -= offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.left)) {
                ox = this.mImageRect.left - this.mFrameRect.left;
                this.mFrameRect.left += ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top += oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.top)) {
                oy = this.mImageRect.top - this.mFrameRect.top;
                this.mFrameRect.top += oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left += ox;
            }
        }
    }

    private void moveHandleRT(float diffX, float diffY) {
        if (this.mCropMode == CropMode.RATIO_FREE) {
            this.mFrameRect.right += diffX;
            this.mFrameRect.top += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.right += dx;
            this.mFrameRect.top -= dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top -= offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.top -= offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right += offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.right)) {
                ox = this.mFrameRect.right - this.mImageRect.right;
                this.mFrameRect.right -= ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.top += oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.top)) {
                oy = this.mImageRect.top - this.mFrameRect.top;
                this.mFrameRect.top += oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right -= ox;
            }
        }
    }

    private void moveHandleLB(float diffX, float diffY) {
        if (this.mCropMode == CropMode.RATIO_FREE) {
            this.mFrameRect.left += diffX;
            this.mFrameRect.bottom += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.left += dx;
            this.mFrameRect.bottom -= dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.left -= offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom += offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left -= offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.left)) {
                ox = this.mImageRect.left - this.mFrameRect.left;
                this.mFrameRect.left += ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom -= oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.bottom)) {
                oy = this.mFrameRect.bottom - this.mImageRect.bottom;
                this.mFrameRect.bottom -= oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.left += ox;
            }
        }
    }

    private void moveHandleRB(float diffX, float diffY) {
        if (this.mCropMode == CropMode.RATIO_FREE) {
            this.mFrameRect.right += diffX;
            this.mFrameRect.bottom += diffY;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
            }
            this.checkScaleBounds();
        } else {
            float oy;
            float ox;
            float dx = diffX;
            float dy = diffX * this.getRatioY() / this.getRatioX();
            this.mFrameRect.right += dx;
            this.mFrameRect.bottom += dy;
            if (this.isWidthTooSmall()) {
                float offsetX = this.mMinFrameSize - this.getFrameW();
                this.mFrameRect.right += offsetX;
                float offsetY = offsetX * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom += offsetY;
            }
            if (this.isHeightTooSmall()) {
                float offsetY = this.mMinFrameSize - this.getFrameH();
                this.mFrameRect.bottom += offsetY;
                float offsetX = offsetY * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right += offsetX;
            }
            if (!this.isInsideHorizontal(this.mFrameRect.right)) {
                ox = this.mFrameRect.right - this.mImageRect.right;
                this.mFrameRect.right -= ox;
                oy = ox * this.getRatioY() / this.getRatioX();
                this.mFrameRect.bottom -= oy;
            }
            if (!this.isInsideVertical(this.mFrameRect.bottom)) {
                oy = this.mFrameRect.bottom - this.mImageRect.bottom;
                this.mFrameRect.bottom -= oy;
                ox = oy * this.getRatioX() / this.getRatioY();
                this.mFrameRect.right -= ox;
            }
        }
    }

    private void checkScaleBounds() {
        float lDiff = this.mFrameRect.left - this.mImageRect.left;
        float rDiff = this.mFrameRect.right - this.mImageRect.right;
        float tDiff = this.mFrameRect.top - this.mImageRect.top;
        float bDiff = this.mFrameRect.bottom - this.mImageRect.bottom;
        if (lDiff < 0.0f) {
            this.mFrameRect.left -= lDiff;
        }
        if (rDiff > 0.0f) {
            this.mFrameRect.right -= rDiff;
        }
        if (tDiff < 0.0f) {
            this.mFrameRect.top -= tDiff;
        }
        if (bDiff > 0.0f) {
            this.mFrameRect.bottom -= bDiff;
        }
    }

    private void checkMoveBounds() {
        float diff = this.mFrameRect.left - this.mImageRect.left;
        if (diff < 0.0f) {
            this.mFrameRect.left -= diff;
            this.mFrameRect.right -= diff;
        }
        if ((diff = this.mFrameRect.right - this.mImageRect.right) > 0.0f) {
            this.mFrameRect.left -= diff;
            this.mFrameRect.right -= diff;
        }
        if ((diff = this.mFrameRect.top - this.mImageRect.top) < 0.0f) {
            this.mFrameRect.top -= diff;
            this.mFrameRect.bottom -= diff;
        }
        if ((diff = this.mFrameRect.bottom - this.mImageRect.bottom) > 0.0f) {
            this.mFrameRect.top -= diff;
            this.mFrameRect.bottom -= diff;
        }
    }

    private boolean isInsideHorizontal(float x) {
        return this.mImageRect.left <= x && this.mImageRect.right >= x;
    }

    private boolean isInsideVertical(float y) {
        return this.mImageRect.top <= y && this.mImageRect.bottom >= y;
    }

    private boolean isWidthTooSmall() {
        return this.getFrameW() < this.mMinFrameSize;
    }

    private boolean isHeightTooSmall() {
        return this.getFrameH() < this.mMinFrameSize;
    }

    private void adjustRatio() {
        if (this.mImageRect == null) {
            return;
        }
        float imgW = this.mImageRect.right - this.mImageRect.left;
        float imgH = this.mImageRect.bottom - this.mImageRect.top;
        float frameW = this.getRatioX(imgW);
        float frameH = this.getRatioY(imgH);
        float imgRatio = imgW / imgH;
        float frameRatio = frameW / frameH;
        float l = this.mImageRect.left;
        float t = this.mImageRect.top;
        float r = this.mImageRect.right;
        float b = this.mImageRect.bottom;
        if (frameRatio >= imgRatio) {
            l = this.mImageRect.left;
            r = this.mImageRect.right;
            float hy = (this.mImageRect.top + this.mImageRect.bottom) * 0.5f;
            float hh = imgW / frameRatio * 0.5f;
            t = hy - hh;
            b = hy + hh;
        } else if (frameRatio < imgRatio) {
            t = this.mImageRect.top;
            b = this.mImageRect.bottom;
            float hx = (this.mImageRect.left + this.mImageRect.right) * 0.5f;
            float hw = imgH * frameRatio * 0.5f;
            l = hx - hw;
            r = hx + hw;
        }
        float w = r - l;
        float h = b - t;
        float cx = l + w / 2.0f;
        float cy = t + h / 2.0f;
        float sw = w * this.mInitialFrameScale;
        float sh = h * this.mInitialFrameScale;
        this.mFrameRect = new RectF(cx - sw / 2.0f, cy - sh / 2.0f, cx + sw / 2.0f, cy + sh / 2.0f);
        this.invalidate();
    }

    private float getRatioX(float w) {
        switch (this.mCropMode) {
            case RATIO_FIT_IMAGE: {
                return this.mImgWidth;
            }
            case RATIO_FREE: {
                return w;
            }
            case RATIO_4_3: {
                return 4.0f;
            }
            case RATIO_3_4: {
                return 3.0f;
            }
            case RATIO_16_9: {
                return 16.0f;
            }
            case RATIO_9_16: {
                return 9.0f;
            }
            case RATIO_1_1: 
            case CIRCLE: {
                return 1.0f;
            }
            case RATIO_CUSTOM: {
                return this.mCustomRatio.x;
            }
        }
        return w;
    }

    private float getRatioY(float h) {
        switch (this.mCropMode) {
            case RATIO_FIT_IMAGE: {
                return this.mImgHeight;
            }
            case RATIO_FREE: {
                return h;
            }
            case RATIO_4_3: {
                return 3.0f;
            }
            case RATIO_3_4: {
                return 4.0f;
            }
            case RATIO_16_9: {
                return 9.0f;
            }
            case RATIO_9_16: {
                return 16.0f;
            }
            case RATIO_1_1: 
            case CIRCLE: {
                return 1.0f;
            }
            case RATIO_CUSTOM: {
                return this.mCustomRatio.y;
            }
        }
        return h;
    }

    private float getRatioX() {
        switch (this.mCropMode) {
            case RATIO_FIT_IMAGE: {
                return this.mImgWidth;
            }
            case RATIO_4_3: {
                return 4.0f;
            }
            case RATIO_3_4: {
                return 3.0f;
            }
            case RATIO_16_9: {
                return 16.0f;
            }
            case RATIO_9_16: {
                return 9.0f;
            }
            case RATIO_1_1: 
            case CIRCLE: {
                return 1.0f;
            }
            case RATIO_CUSTOM: {
                return this.mCustomRatio.x;
            }
        }
        return 1.0f;
    }

    private float getRatioY() {
        switch (this.mCropMode) {
            case RATIO_FIT_IMAGE: {
                return this.mImgHeight;
            }
            case RATIO_4_3: {
                return 3.0f;
            }
            case RATIO_3_4: {
                return 4.0f;
            }
            case RATIO_16_9: {
                return 9.0f;
            }
            case RATIO_9_16: {
                return 16.0f;
            }
            case RATIO_1_1: 
            case CIRCLE: {
                return 1.0f;
            }
            case RATIO_CUSTOM: {
                return this.mCustomRatio.y;
            }
        }
        return 1.0f;
    }

    private float getDensity() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    private float sq(float value) {
        return value * value;
    }

    private float constrain(float val, float min, float max, float defaultVal) {
        if (val < min || val > max) {
            return defaultVal;
        }
        return val;
    }

    public Bitmap getImageBitmap() {
        return this.getBitmap();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mIsInitialized = false;
        super.setImageBitmap(bitmap);
        this.updateDrawableInfo();
    }

    public void setImageResource(int resId) {
        this.mIsInitialized = false;
        super.setImageResource(resId);
        this.updateDrawableInfo();
    }

    public void setImageDrawable(Drawable drawable) {
        this.mIsInitialized = false;
        super.setImageDrawable(drawable);
        this.updateDrawableInfo();
    }

    public void setImageURI(Uri uri) {
        this.mIsInitialized = false;
        super.setImageURI(uri);
        this.updateDrawableInfo();
    }

    private void updateDrawableInfo() {
        Drawable d = this.getDrawable();
        if (d != null) {
            this.initLayout(this.mViewWidth, this.mViewHeight);
        }
    }

    public void rotateImage(RotateDegrees degrees) {
        Bitmap source = this.getBitmap();
        if (source == null) {
            return;
        }
        int angle = degrees.getValue();
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap rotated = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        this.setImageBitmap(rotated);
    }

    public Bitmap getCroppedBitmap() {
        Bitmap source = this.getBitmap();
        if (source == null) {
            return null;
        }
        float l = this.mFrameRect.left / this.mScale;
        float t = this.mFrameRect.top / this.mScale;
        float r = this.mFrameRect.right / this.mScale;
        float b = this.mFrameRect.bottom / this.mScale;
        int x = Math.round(l - this.mImageRect.left / this.mScale);
        int y = Math.round(t - this.mImageRect.top / this.mScale);
        int w = Math.round(r - l);
        int h = Math.round(b - t);
        if (w > source.getWidth()) {
            w = source.getWidth();
            x = 0;
        }
        if (h > source.getHeight()) {
            h = source.getHeight();
            y = 0;
        }
        Bitmap cropped = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)w, (int)h, null, (boolean)false);
        if (this.mCropMode != CropMode.CIRCLE) {
            return cropped;
        }
        return this.getCircularBitmap(cropped);
    }

    public Bitmap getRectBitmap() {
        Bitmap source = this.getBitmap();
        if (source == null) {
            return null;
        }
        float l = this.mFrameRect.left / this.mScale;
        float t = this.mFrameRect.top / this.mScale;
        float r = this.mFrameRect.right / this.mScale;
        float b = this.mFrameRect.bottom / this.mScale;
        int x = Math.round(l - this.mImageRect.left / this.mScale);
        int y = Math.round(t - this.mImageRect.top / this.mScale);
        int w = Math.round(r - l);
        int h = Math.round(b - t);
        if (w > source.getWidth()) {
            w = source.getWidth();
            x = 0;
        }
        if (h > source.getHeight()) {
            h = source.getHeight();
            y = 0;
        }
        return Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)w, (int)h, null, (boolean)false);
    }

    public Bitmap getCircularBitmap(Bitmap square) {
        if (square == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)square.getWidth(), (int)square.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Rect rect = new Rect(0, 0, square.getWidth(), square.getHeight());
        Canvas canvas = new Canvas(output);
        int halfWidth = square.getWidth() / 2;
        int halfHeight = square.getHeight() / 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        canvas.drawCircle((float)halfWidth, (float)halfHeight, (float)Math.min(halfWidth, halfHeight), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(square, rect, rect, paint);
        return output;
    }

    private Bitmap getBitmap() {
        Bitmap bm = null;
        Drawable d = this.getDrawable();
        if (d != null && d instanceof BitmapDrawable) {
            bm = ((BitmapDrawable)d).getBitmap();
        }
        return bm;
    }

    public RectF getActualCropRect() {
        float offsetX = this.mImageRect.left / this.mScale;
        float offsetY = this.mImageRect.top / this.mScale;
        float l = this.mFrameRect.left / this.mScale - offsetX;
        float t = this.mFrameRect.top / this.mScale - offsetY;
        float r = this.mFrameRect.right / this.mScale - offsetX;
        float b = this.mFrameRect.bottom / this.mScale - offsetY;
        return new RectF(l, t, r, b);
    }

    public void setCropMode(CropMode mode) {
        if (mode == CropMode.RATIO_CUSTOM) {
            this.setCustomRatio(1, 1);
        } else {
            this.mCropMode = mode;
            this.adjustRatio();
        }
    }

    public void setCustomRatio(int ratioX, int ratioY) {
        if (ratioX == 0 || ratioY == 0) {
            return;
        }
        this.mCropMode = CropMode.RATIO_CUSTOM;
        this.mCustomRatio = new PointF((float)ratioX, (float)ratioY);
        this.adjustRatio();
    }

    public void setOverlayColor(int overlayColor) {
        this.mOverlayColor = overlayColor;
        this.invalidate();
    }

    public void setFrameColor(int frameColor) {
        this.mFrameColor = frameColor;
        this.invalidate();
    }

    public void setHandleColor(int handleColor) {
        this.mHandleColor = handleColor;
        this.invalidate();
    }

    public void setGuideColor(int guideColor) {
        this.mGuideColor = guideColor;
        this.invalidate();
    }

    public void setBackgroundColor(int bgColor) {
        this.mBackgroundColor = bgColor;
        super.setBackgroundColor(this.mBackgroundColor);
        this.invalidate();
    }

    public void setMinFrameSizeInDp(int minDp) {
        this.mMinFrameSize = (float)minDp * this.getDensity();
    }

    public void setMinFrameSizeInPx(int minPx) {
        this.mMinFrameSize = minPx;
    }

    public void setHandleSizeInDp(int handleDp) {
        this.mHandleSize = (int)((float)handleDp * this.getDensity());
    }

    public void setTouchPaddingInDp(int paddingDp) {
        this.mTouchPadding = (int)((float)paddingDp * this.getDensity());
    }

    public void setGuideShowMode(ShowMode mode) {
        this.mGuideShowMode = mode;
        switch (mode) {
            case SHOW_ALWAYS: {
                this.mShowGuide = true;
                break;
            }
            case NOT_SHOW: 
            case SHOW_ON_TOUCH: {
                this.mShowGuide = false;
            }
        }
        this.invalidate();
    }

    public void setHandleShowMode(ShowMode mode) {
        this.mHandleShowMode = mode;
        switch (mode) {
            case SHOW_ALWAYS: {
                this.mShowHandle = true;
                break;
            }
            case NOT_SHOW: 
            case SHOW_ON_TOUCH: {
                this.mShowHandle = false;
            }
        }
        this.invalidate();
    }

    public void setFrameStrokeWeightInDp(int weightDp) {
        this.mFrameStrokeWeight = (float)weightDp * this.getDensity();
        this.invalidate();
    }

    public void setGuideStrokeWeightInDp(int weightDp) {
        this.mGuideStrokeWeight = (float)weightDp * this.getDensity();
        this.invalidate();
    }

    public void setCropEnabled(boolean enabled) {
        this.mIsCropEnabled = enabled;
        this.invalidate();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    public void setInitialFrameScale(float initialScale) {
        this.mInitialFrameScale = this.constrain(initialScale, 0.01f, 1.0f, 0.75f);
    }

    private void setScale(float mScale) {
        this.mScale = mScale;
    }

    private void setCenter(PointF mCenter) {
        this.mCenter = mCenter;
    }

    private float getFrameW() {
        return this.mFrameRect.right - this.mFrameRect.left;
    }

    private float getFrameH() {
        return this.mFrameRect.bottom - this.mFrameRect.top;
    }

    public static class SavedState
    extends View.BaseSavedState {
        Bitmap image;
        CropMode mode;
        int backgroundColor;
        int overlayColor;
        int frameColor;
        ShowMode guideShowMode;
        ShowMode handleShowMode;
        boolean showGuide;
        boolean showHandle;
        int handleSize;
        int touchPadding;
        float minFrameSize;
        float customRatioX;
        float customRatioY;
        float frameStrokeWeight;
        float guideStrokeWeight;
        boolean isCropEnabled;
        int handleColor;
        int guideColor;
        float initialFrameScale;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

            public SavedState createFromParcel(Parcel inParcel) {
                return new SavedState(inParcel);
            }

            public SavedState[] newArray(int inSize) {
                return new SavedState[inSize];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.image = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
            this.mode = (CropMode)((Object)in.readSerializable());
            this.backgroundColor = in.readInt();
            this.overlayColor = in.readInt();
            this.frameColor = in.readInt();
            this.guideShowMode = (ShowMode)((Object)in.readSerializable());
            this.handleShowMode = (ShowMode)((Object)in.readSerializable());
            this.showGuide = in.readInt() != 0;
            this.showHandle = in.readInt() != 0;
            this.handleSize = in.readInt();
            this.touchPadding = in.readInt();
            this.minFrameSize = in.readFloat();
            this.customRatioX = in.readFloat();
            this.customRatioY = in.readFloat();
            this.frameStrokeWeight = in.readFloat();
            this.guideStrokeWeight = in.readFloat();
            this.isCropEnabled = in.readInt() != 0;
            this.handleColor = in.readInt();
            this.guideColor = in.readInt();
            this.initialFrameScale = in.readFloat();
        }

        public void writeToParcel(Parcel out, int flag) {
            super.writeToParcel(out, flag);
            out.writeParcelable((Parcelable)this.image, flag);
            out.writeSerializable((Serializable)((Object)this.mode));
            out.writeInt(this.backgroundColor);
            out.writeInt(this.overlayColor);
            out.writeInt(this.frameColor);
            out.writeSerializable((Serializable)((Object)this.guideShowMode));
            out.writeSerializable((Serializable)((Object)this.handleShowMode));
            out.writeInt(this.showGuide ? 1 : 0);
            out.writeInt(this.showHandle ? 1 : 0);
            out.writeInt(this.handleSize);
            out.writeInt(this.touchPadding);
            out.writeFloat(this.minFrameSize);
            out.writeFloat(this.customRatioX);
            out.writeFloat(this.customRatioY);
            out.writeFloat(this.frameStrokeWeight);
            out.writeFloat(this.guideStrokeWeight);
            out.writeInt(this.isCropEnabled ? 1 : 0);
            out.writeInt(this.handleColor);
            out.writeInt(this.guideColor);
            out.writeFloat(this.initialFrameScale);
        }
    }

    public static enum RotateDegrees {
        ROTATE_90D(90),
        ROTATE_180D(180),
        ROTATE_270D(270);

        private final int VALUE;

        private RotateDegrees(int value) {
            this.VALUE = value;
        }

        public int getValue() {
            return this.VALUE;
        }
    }

    public static enum ShowMode {
        SHOW_ALWAYS(1),
        SHOW_ON_TOUCH(2),
        NOT_SHOW(3);

        private final int ID;

        private ShowMode(int id) {
            this.ID = id;
        }

        public int getId() {
            return this.ID;
        }
    }

    public static enum CropMode {
        RATIO_FIT_IMAGE(0),
        RATIO_4_3(1),
        RATIO_3_4(2),
        RATIO_1_1(3),
        RATIO_16_9(4),
        RATIO_9_16(5),
        RATIO_FREE(6),
        RATIO_CUSTOM(7),
        CIRCLE(8);

        private final int ID;

        private CropMode(int id) {
            this.ID = id;
        }

        public int getId() {
            return this.ID;
        }
    }

    private static enum TouchArea {
        OUT_OF_BOUNDS,
        CENTER,
        LEFT_TOP,
        RIGHT_TOP,
        LEFT_BOTTOM,
        RIGHT_BOTTOM;

    }
}

