/*
 * Decompiled with CFR 0.152.
 */
package core.reports.extent;

import com.relevantcodes.extentreports.LogStatus;
import core.reports.TestReporter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.testng.ITestContext;
import org.testng.annotations.Test;

public class BuildReportActions {
    protected static void addInfo(String infoString) {
        if (TestReporter.logger == null) {
            TestReporter.testLogger.log(LogStatus.INFO, infoString);
        } else {
            TestReporter.logger.log(LogStatus.INFO, infoString);
        }
    }

    protected static void addPass(String passString, String screenShotName) {
        if (TestReporter.logger == null) {
            TestReporter.testLogger.log(LogStatus.PASS, passString);
        } else {
            String image = screenShotName;
            if (image != null) {
                passString = passString + TestReporter.logger.addScreenCapture(image);
            }
            TestReporter.logger.log(LogStatus.PASS, passString);
        }
    }

    protected static void addError(String errorString) {
        if (TestReporter.logger == null) {
            TestReporter.testLogger.log(LogStatus.ERROR, errorString);
        } else {
            TestReporter.logger.log(LogStatus.ERROR, errorString);
        }
    }

    protected static void addFail(String failString) {
        if (TestReporter.logger == null) {
            TestReporter.testLogger.log(LogStatus.FAIL, failString);
        } else {
            TestReporter.logger.log(LogStatus.FAIL, failString);
        }
    }

    protected static void addDescription(String testDescription) {
        TestReporter.logger.setDescription(testDescription);
    }

    protected static void addMethodGroups(ITestContext testContext, Method method) {
        block4: {
            TestReporter.logger.assignCategory(new String[]{TestReporter.testLogger.getDescription()});
            List includedGroups = testContext.getCurrentXmlTest().getIncludedGroups();
            List<String> methodGroups = Arrays.asList(method.getAnnotation(Test.class).groups());
            if (TestReporter.logger == null) break block4;
            if (includedGroups.size() != 0) {
                for (String groupName : includedGroups) {
                    TestReporter.logger.assignCategory(new String[]{groupName});
                }
            } else {
                for (String groupName : methodGroups) {
                    TestReporter.logger.assignCategory(new String[]{groupName});
                }
            }
        }
    }
}

