/*
 * Decompiled with CFR 0.152.
 */
package core.reports;

import com.relevantcodes.extentreports.ExtentReports;
import com.relevantcodes.extentreports.ExtentTest;
import core.internal.EnvironmentInterface;
import core.reports.extent.BuildReportActions;
import java.lang.reflect.Method;
import org.testng.Assert;
import org.testng.ITestContext;

public class TestReporter
extends BuildReportActions {
    public static ExtentReports report;
    public static ExtentTest testLogger;
    public static ExtentTest logger;

    public static void prepareReport(ITestContext testContext) {
        String reportTime = EnvironmentInterface.CURRENT_TIME;
        String suiteName = testContext.getSuite().getName().replace(" ", "-");
        report = new ExtentReports(EnvironmentInterface.REPORT_PATH + suiteName + reportTime + ".html", Boolean.valueOf(true));
    }

    public static void prepareTestReport(ITestContext testContext) {
        testLogger = report.startTest(testContext.getName());
        testLogger.setDescription("Test of: " + testContext.getName());
    }

    public static void prepareMethodReport(Method method) {
        logger = report.startTest(method.getName());
        logger.assignCategory(new String[]{method.getDeclaringClass().getName()});
    }

    public static void addMethodCategories(ITestContext testContext, Method method) {
        TestReporter.addMethodGroups(testContext, method);
    }

    public static void generateMethodReport() {
        report.endTest(logger);
        logger = null;
    }

    public static void generateTestReport() {
        report.endTest(testLogger);
        testLogger = null;
    }

    public static void generateFinalReport() {
        report.flush();
        report.close();
    }

    public static void info(String infoString) {
        TestReporter.addInfo(infoString);
    }

    public static void pass(String passString, String screenShotName) {
        TestReporter.addPass(passString, screenShotName);
    }

    public static void error(String errorString, Boolean failStatus) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
        TestReporter.addError("Something went wrong while running method " + methodName + " in class " + className + " Line " + lineNumber + "</br>Error as below.</br>" + errorString);
        if (failStatus.booleanValue()) {
            Assert.fail((String)errorString);
        }
    }

    public static void error(String errorString, Throwable exceptionError, Boolean failStatus) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
        TestReporter.addError("Something went wrong while running method " + methodName + " in class " + className + " Line " + lineNumber + "</br>Error as below.</br>" + errorString + "</br>Please check message: " + exceptionError.getMessage());
        if (failStatus.booleanValue()) {
            Assert.fail((String)errorString);
        }
    }

    public static void fail(String failString, Boolean failStatus) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
        TestReporter.addFail("Test case fail due to error in running method " + methodName + " in class " + className + " Line " + lineNumber + "</br>Fail reason as below.</br>" + failString);
        if (failStatus.booleanValue()) {
            Assert.fail((String)failString);
        }
    }

    public static void fail(String failString, Throwable exceptionError, Boolean failStatus) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
        TestReporter.addFail("Test case fail due to error in running method " + methodName + " in class " + className + " Line " + lineNumber + "</br>Fail reason as below.</br>" + failString + "</br>Please check message: " + exceptionError.getMessage());
        if (failStatus.booleanValue()) {
            Assert.fail((String)failString);
        }
    }

    public static void testCaseDescription(String testDescription) {
        TestReporter.addDescription(testDescription);
    }
}

