/*
 * Decompiled with CFR 0.152.
 */
package core.os_ops;

import core.reports.TestReporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;

public class Services {
    public static Boolean checkPortInUse(int portNo) {
        Boolean isServerRunning = false;
        try {
            ServerSocket serverSocket = new ServerSocket(portNo);
        }
        catch (IOException e) {
            isServerRunning = true;
        }
        return isServerRunning;
    }

    public static Boolean checkProgramExists(String programCommand) {
        Boolean isProgramExists = false;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(programCommand);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isProgramExists;
    }

    public static Process getProcess(String processCommand) {
        Process process = null;
        StringBuffer output = new StringBuffer();
        String os = System.getProperty("os.name").toLowerCase();
        try {
            String[] command = os.contains("win") ? new String[]{"CMD", "/C", processCommand} : (os.contains("mac") ? new String[]{"/bin/bash", "-c", processCommand} : new String[]{"/bin/bash", "-c", processCommand});
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            process.waitFor(5L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            Assert.fail((String)("Something went wrong, please check: " + e.getMessage()));
        }
        return process;
    }

    public static Process getProcess(String ... processCommands) {
        Process process = Services.getProcess(processCommands[0]);
        OutputStream outputStream = process.getOutputStream();
        for (String command : processCommands) {
            if (command.equals(processCommands[0]) || command.isEmpty()) continue;
            try {
                outputStream.write(command.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return process;
    }

    public static String getProcessOutput(String processCommand) {
        StringBuffer output = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Services.getProcess(processCommand).getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Something went wrong, please check: " + e.getMessage()));
        }
        return output.toString() != null ? output.toString() : "";
    }

    public static String getProcessOutput(String ... processCommands) {
        StringBuffer output = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Services.getProcess(processCommands).getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Something went wrong, please check: " + e.getMessage()));
        }
        return output.toString() != null ? output.toString() : "";
    }

    public static String[] getProcessOutputLines(String processCommand) {
        return Services.getProcessOutput(processCommand).split("\\n");
    }

    public static String getProcessOutput(String processCommand, int resultIndex) {
        String fullResult = Services.getProcessOutput(processCommand);
        return fullResult.split("\\n")[resultIndex] != null ? fullResult.split("\\n")[resultIndex] : "";
    }

    public static String getProcessOutput(String processCommand, String resultContainsString) {
        Object[] fullResult = Services.getProcessOutput(processCommand).split("\\n");
        String resultString = "";
        for (int counter = 0; counter < fullResult.length; ++counter) {
            if (!fullResult[counter].contains(resultContainsString)) continue;
            resultString = fullResult[counter];
            break;
        }
        if (resultString.isEmpty()) {
            TestReporter.error("There is no String in terminal result.\n</br>Command String : " + processCommand + "\n</br>resultContainsString Param: " + resultContainsString + "\n</br>Terminal result:</br>\n" + StringUtils.join((Object[])fullResult, (String)" "), false);
        }
        return resultString;
    }
}

