/*
 * Decompiled with CFR 0.152.
 */
package core.handlers.scripting;

import core.files.FileHelper;
import core.files.validator.FileStatusValidator;
import core.os_ops.Services;
import core.reports.TestReporter;

public class JSHandler {
    private static String jsExecutor(String jsFile) {
        if (!JSHandler.isNodeInstalled() && !JSHandler.isNPMInstalled()) {
            TestReporter.error("NodeJS or NPM isn't installed on your computer, for info about installation visit this site: https://nodejs.org/en/download/", true);
        }
        return Services.getProcessOutput("node " + jsFile);
    }

    public static String runJScriptCommand(String jsInput) {
        String jsFile = FileHelper.createTempFile("run.js", jsInput);
        return JSHandler.jsExecutor(jsFile);
    }

    public static String runJScriptFile(String jsFileName) {
        if (!FileStatusValidator.isFileExist(jsFileName).booleanValue()) {
            jsFileName = FileHelper.getFileAbsolutePath(jsFileName);
        }
        return JSHandler.jsExecutor(jsFileName);
    }

    private static boolean isNodeInstalled() {
        return !Services.getProcessOutput("node -v").contains("not recognized");
    }

    private static boolean isNPMInstalled() {
        return !Services.getProcessOutput("npm -v").contains("not recognized");
    }

    public static boolean isNodeLibraryInstalled(String libraryName) {
        return Services.getProcessOutput("npm ls --depth=0").contains(libraryName);
    }

    public static void setNodeLibraries(String ... libraries) {
        for (String library : libraries) {
            Services.getProcessOutput("npm i " + library);
        }
    }
}

