/*
 * Decompiled with CFR 0.152.
 */
package core.handlers;

import java.security.SecureRandom;
import java.util.HashMap;
import org.apache.commons.validator.routines.UrlValidator;

public class StringHandler {
    public static String[] getStringAsArray(String string, String expressions) {
        return string.split(expressions) != null ? string.split(expressions) : null;
    }

    public static boolean validateURL(String url) {
        while (url.contains("//")) {
            url = url.replace("//", "/");
        }
        if (!(url = url.replaceFirst(":/", "://")).contains("localhost")) {
            return UrlValidator.getInstance().isValid(url);
        }
        return url.contains("localhost");
    }

    public static String cleanStringFromReturn(String string) {
        return string.replaceAll("[\\n \\t ]", "");
    }

    public static String getRandomString(int noOfChars) {
        String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lower = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
        String digits = "0123456789";
        String alphaNum = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + lower + "0123456789";
        StringBuilder stringBuilder = new StringBuilder(noOfChars);
        for (int counter = 0; counter < noOfChars; ++counter) {
            stringBuilder.append(alphaNum.charAt(new SecureRandom().nextInt(alphaNum.length())));
        }
        return stringBuilder.toString();
    }

    public static int getIntegerFromString(String string) {
        return Integer.parseInt(string.replaceAll("[\\D]", ""));
    }

    public static HashMap<String, String> getHashMapFromString(String expression, String string) {
        string = string.substring(1, string.length() - 1);
        String[] keyValuePairs = string.split(",");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String pair : keyValuePairs) {
            if (pair.split(expression).length != 2) continue;
            String key = pair.split(expression)[0];
            String value = pair.split(expression)[1];
            hashMap.put(key, value);
        }
        return hashMap;
    }

    public static String convertUpperCaseToUnderScore(String string) {
        String convertedString = "";
        for (char character : string.toCharArray()) {
            String newChar = Character.isUpperCase(character) ? "_" + Character.toLowerCase(character) : String.valueOf(character);
            convertedString = convertedString + newChar;
        }
        return convertedString.startsWith("_") ? convertedString.replaceFirst("_", "") : convertedString;
    }

    public static boolean isStringBlank(String string) {
        return string == null || string.trim().isEmpty();
    }
}

