/*
 * Decompiled with CFR 0.152.
 */
package core.files.writer;

import core.files.reader.ReadExcelFile;
import core.reports.TestReporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WriteExcelFile {
    private static String excelFileName = "";
    private static String sheetName = "";
    private static Workbook workbook = null;
    private static Sheet sheet = null;
    private static Row row = null;

    private static void getExcelWorkbook(String excelFile) {
        try {
            excelFileName = excelFile;
            new File(excelFile).getParentFile().mkdirs();
            workbook = new File(excelFile).exists() ? WorkbookFactory.create((InputStream)new FileInputStream(new File(excelFileName))) : new XSSFWorkbook();
        }
        catch (Throwable throwable) {
            TestReporter.error("Something went wrong", throwable, false);
        }
    }

    private static void writeExcelWorkbook() {
        try {
            if (!excelFileName.isEmpty()) {
                FileOutputStream fileOut = new FileOutputStream(excelFileName);
                workbook.write((OutputStream)fileOut);
                fileOut.flush();
                fileOut.close();
                workbook.close();
            } else {
                TestReporter.error("Please provide excel file name to write.", true);
            }
        }
        catch (Throwable throwable) {
            TestReporter.error("Something went wrong while writing to excel file.", throwable, true);
        }
    }

    private static void getExcelSheet(String excelFile, String sheetName) {
        try {
            WriteExcelFile.sheetName = sheetName;
            WriteExcelFile.getExcelWorkbook(excelFile);
            sheet = workbook.getSheet(sheetName) != null ? workbook.getSheet(sheetName) : workbook.createSheet(sheetName);
        }
        catch (Throwable throwable) {
            TestReporter.error("Something went wrong while read excel sheet " + sheetName, throwable, true);
        }
    }

    private static void getSheetRow(String excelFile, String sheetName, int rowNo) {
        WriteExcelFile.getExcelSheet(excelFile, sheetName);
        rowNo = rowNo - 1 > 0 ? rowNo - 1 : 0;
        row = workbook.getSheet(sheet.getSheetName()).getRow(rowNo) != null ? workbook.getSheet(sheet.getSheetName()).getRow(rowNo) : workbook.getSheet(sheet.getSheetName()).createRow(rowNo);
    }

    private static void getLastSheetRow(String excelFile, String sheetName) {
        WriteExcelFile.getExcelSheet(excelFile, sheetName);
        WriteExcelFile.getSheetRow(excelFile, sheetName, WriteExcelFile.getLastRowIndex());
    }

    private static Row addRowCell(Row row, int cellNo, String cellData) {
        if (row.getCell(cellNo) != null) {
            row.getCell(cellNo).setCellValue(cellData);
        } else {
            row.createCell(cellNo).setCellValue(cellData);
        }
        return row;
    }

    private static int getLastRowIndex() {
        if (sheet != null) {
            return sheet.getLastRowNum() + 2;
        }
        return 0;
    }

    private static void writeDataToExcelRow(Row row, ArrayList<String> rowData) {
        int counter = 0;
        for (String cellData : rowData) {
            WriteExcelFile.addRowCell(row, counter, cellData);
            ++counter;
        }
        WriteExcelFile.writeExcelWorkbook();
    }

    public static void writeRowToExcelSheet(String excelFile, String sheetName, int rowNo, ArrayList<String> rowData) {
        WriteExcelFile.getSheetRow(excelFile, sheetName, rowNo);
        WriteExcelFile.writeDataToExcelRow(row, rowData);
    }

    public static void writeRowToExcelSheet(String excelFile, int sheetNo, int rowNo, ArrayList<String> rowData) {
        WriteExcelFile.writeRowToExcelSheet(excelFile, ReadExcelFile.getSheetName(excelFile, sheetNo), rowNo, rowData);
    }

    public static void writeRowToExcelSheet(String excelFile, String sheetName, ArrayList<String> rowData) {
        WriteExcelFile.getLastSheetRow(excelFile, sheetName);
        WriteExcelFile.writeDataToExcelRow(row, rowData);
    }

    public static void writeRowToExcelSheet(String excelFile, int sheetNo, ArrayList<String> rowData) {
        WriteExcelFile.writeRowToExcelSheet(excelFile, ReadExcelFile.getSheetName(excelFile, sheetNo), rowData);
    }

    public static void writeHeaderToExcelSheet(String excelFile, String sheetName, ArrayList<String> rowData) {
        WriteExcelFile.getSheetRow(excelFile, sheetName, 0);
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setColor(IndexedColors.RED.getIndex());
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        int counter = 0;
        for (String cellData : rowData) {
            Cell cell = row.createCell(counter);
            cell.setCellValue(cellData);
            cell.setCellStyle(headerCellStyle);
            ++counter;
        }
        WriteExcelFile.writeDataToExcelRow(row, rowData);
    }

    public static void writeHeaderToExcelSheet(String excelFile, String sheetName, String[] rowData) {
        WriteExcelFile.getSheetRow(excelFile, sheetName, 0);
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setColor(IndexedColors.RED.getIndex());
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        int counter = 0;
        for (String cellData : rowData) {
            Cell cell = row.createCell(counter);
            cell.setCellValue(cellData);
            cell.setCellStyle(headerCellStyle);
            ++counter;
        }
        ArrayList<String> rowDataList = new ArrayList<String>(Arrays.asList(rowData));
        WriteExcelFile.writeDataToExcelRow(row, rowDataList);
    }

    public static void writeToExcelRow(String excelFile, String sheetName, int rowNo, ArrayList<String> rowData) {
        if (ReadExcelFile.isRowExist(excelFile, sheetName, rowNo)) {
            ArrayList<String> currentData = ReadExcelFile.getRowData(excelFile, sheetName, rowNo);
            currentData.addAll(rowData);
            WriteExcelFile.writeRowToExcelSheet(excelFile, sheetName, rowNo, currentData);
        } else {
            WriteExcelFile.writeRowToExcelSheet(excelFile, sheetName, rowNo, rowData);
        }
    }

    public static void writeToExcelRow(String excelFile, int sheetNo, int rowNo, ArrayList<String> rowData) {
        WriteExcelFile.writeToExcelRow(excelFile, ReadExcelFile.getSheetName(excelFile, sheetNo), rowNo, rowData);
    }

    public static void writeToExcelHeader(String excelFile, String sheetName, ArrayList<String> rowData) {
        WriteExcelFile.writeToExcelRow(excelFile, sheetName, 1, rowData);
    }

    public static void writeToExcelHeader(String excelFile, int sheetNo, ArrayList<String> rowData) {
        WriteExcelFile.writeToExcelRow(excelFile, ReadExcelFile.getSheetName(excelFile, sheetNo), 1, rowData);
    }

    public static void mergeTwoExcelSheets(String firstExcel, String secondExcel, int firstSheet, int secondSheet, String outputExcel, int outputSheet) {
        ArrayList<ArrayList<String>> firstDataSheet = ReadExcelFile.getSheetData(firstExcel, firstSheet);
        ArrayList<ArrayList<String>> secondDataSheet = ReadExcelFile.getSheetData(secondExcel, secondSheet);
        int dataSize = firstDataSheet.size() > secondDataSheet.size() ? firstDataSheet.size() : secondDataSheet.size();
        for (int counter = 0; counter < dataSize; ++counter) {
            ArrayList<String> firstRow = firstDataSheet.size() < counter ? firstDataSheet.get(counter) : null;
            ArrayList<String> secondRow = secondDataSheet.size() < counter ? secondDataSheet.get(counter) : null;
            ArrayList<String> newRow = new ArrayList<String>();
            if (firstRow != null) {
                newRow.addAll(firstRow);
            }
            if (secondRow != null) {
                newRow.addAll(secondRow);
            }
            if (newRow.size() <= 0) continue;
            WriteExcelFile.writeRowToExcelSheet(outputExcel, outputSheet, newRow);
        }
    }
}

