/*
 * Decompiled with CFR 0.152.
 */
package core.files.validator;

import core.reports.TestReporter;
import java.io.File;

public class FileStatusValidator {
    public static Boolean isFileExist(String filePath) {
        return new File(filePath).exists();
    }

    public static Boolean verifyFileIsFolder(String filePath) {
        return new File(filePath).isDirectory();
    }

    public static Boolean verifyFileContainsData(String filePath) {
        return new File(filePath).length() != 0L;
    }

    public static void verifyFileStatus(String filePath) {
        if (!FileStatusValidator.isFileExist(filePath).booleanValue()) {
            TestReporter.error("File isn't exist, Please check File Path: " + filePath, true);
        }
        if (FileStatusValidator.verifyFileIsFolder(filePath).booleanValue()) {
            TestReporter.error("The Provided a folder not a file, Please check Folder Path: " + filePath, true);
        }
        if (!FileStatusValidator.verifyFileContainsData(filePath).booleanValue()) {
            TestReporter.error("The Provided an Empty File, Please check file Path: " + filePath, true);
        }
    }
}

