/*
 * Decompiled with CFR 0.152.
 */
package core.files.validator;

import core.reports.TestReporter;
import java.io.File;
import java.io.IOException;
import org.apache.tika.Tika;

public class FileExtensionValidator {
    private static final Tika tika = new Tika();

    private static String fileTypeDetector(String filePath) {
        File file = new File(filePath);
        String fileType = null;
        try {
            fileType = tika.detect(file);
        }
        catch (IOException e) {
            TestReporter.error("Unable to read the file due to:\n " + e.getMessage(), true);
        }
        return fileType;
    }

    public static void verifyPropertiesFileType(String filePath) {
        String fileType = "text/x-java-properties";
        if (!FileExtensionValidator.fileTypeDetector(filePath).equalsIgnoreCase(fileType)) {
            TestReporter.error("The Provided File isn't Properties fileType, please check the file: " + filePath, true);
        }
    }

    public static void verifyExcelFileType(String filePath) {
        String fileType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        if (!FileExtensionValidator.fileTypeDetector(filePath).equalsIgnoreCase(fileType)) {
            TestReporter.error("The Provided File isn't Excel Sheet fileType, please check the file: " + filePath, true);
        }
    }

    public static void verifyJSONFileType(String filePath) {
        String fileType = "application/json";
        if (!FileExtensionValidator.fileTypeDetector(filePath).equalsIgnoreCase(fileType)) {
            TestReporter.error("The Provided File isn't json fileType, please check the file: " + filePath, true);
        }
    }
}

