/*
 * Decompiled with CFR 0.152.
 */
package core.files.reader;

import core.files.FileHelper;
import core.files.validator.FileStatusValidator;
import core.handlers.StringHandler;
import core.reports.TestReporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.testng.annotations.Test;

public class ReadTXTFile {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readTxtFile(String txtFile) {
        if (!FileStatusValidator.isFileExist(txtFile).booleanValue()) {
            txtFile = FileHelper.getFileAbsolutePath(txtFile);
        }
        FileStatusValidator.verifyFileStatus(txtFile);
        try (Stream<String> lines = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(txtFile), "utf-8")).lines();){
            List<String> list = ReadTXTFile.removeListNullEmptyValues(lines.collect(Collectors.toList()));
            return list;
        }
        catch (Throwable throwable6) {
            TestReporter.error("Something went wrong Read TXT File, Please check log: " + throwable6.getMessage(), true);
            return null;
        }
    }

    public static String readTxtFileAsString(String txtFile) {
        return StringUtils.join((Object[])new List[]{ReadTXTFile.readTxtFile(txtFile)});
    }

    public static String getRowOfTxtFile(String fileName, int rowNumber) {
        List<String> textContent = ReadTXTFile.readTxtFile(new File(fileName).getName());
        int n = rowNumber = rowNumber >= 0 ? rowNumber : 0;
        if (textContent.size() > 0 && textContent.size() > rowNumber && !StringHandler.isStringBlank(textContent.get(rowNumber))) {
            return textContent.get(rowNumber);
        }
        TestReporter.error("Something went wrong while reading Txt File.\nFile name: " + fileName + ".\nRow Number: " + (rowNumber + 1), true);
        return "";
    }

    public static List<String> removeListNullEmptyValues(List<String> listContent) {
        listContent.removeAll(Arrays.asList("", null));
        return listContent;
    }

    @Test
    public void test() {
        ReadTXTFile.readTxtFile("C:\\Users\\Ismail\\IdeaProjects\\core-automation\\src\\test\\resources\\testing_json\\input_hamza.txt");
    }
}

