/*
 * Decompiled with CFR 0.152.
 */
package core.files.reader;

import core.files.FileHelper;
import core.files.validator.FileStatusValidator;
import core.reports.TestReporter;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Set;

public class ReadPropFile {
    private static Properties readPropFile(String propFile) {
        if (!FileStatusValidator.isFileExist(propFile).booleanValue()) {
            propFile = FileHelper.getFileAbsolutePath(propFile);
        }
        FileStatusValidator.verifyFileStatus(propFile);
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(propFile);
            properties.load(inputStream);
            Set<Object> keys = properties.keySet();
            Properties newProperties = new Properties();
            for (Object key : keys) {
                String propKey = (String)key;
                String propValue = properties.getProperty(propKey);
                newProperties.setProperty(propKey.toLowerCase(), propValue);
            }
            properties = newProperties;
            return properties;
        }
        catch (Throwable throwable) {
            TestReporter.error("Something went wrong in reading Properties file: " + propFile, throwable, true);
            return null;
        }
    }

    public static String getProperty(String propFile, String propertyName) {
        if (ReadPropFile.readPropFile(propFile).containsKey(propertyName.toLowerCase())) {
            return ReadPropFile.readPropFile(propFile).getProperty(propertyName.toLowerCase());
        }
        return "";
    }
}

