/*
 * Decompiled with CFR 0.152.
 */
package core.files.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import core.files.FileHelper;
import core.files.validator.FileExtensionValidator;
import core.files.validator.FileStatusValidator;
import core.reports.TestReporter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class ReadJSONFile {
    public static JsonNode readJsonFile(String jsonFileName) {
        if (!FileStatusValidator.isFileExist(jsonFileName).booleanValue()) {
            jsonFileName = FileHelper.getFileAbsolutePath(jsonFileName);
        }
        FileStatusValidator.verifyFileStatus(jsonFileName);
        FileExtensionValidator.verifyJSONFileType(jsonFileName);
        JsonNode jsonNode = null;
        try {
            byte[] jsonData = Files.readAllBytes(Paths.get(jsonFileName, new String[0]));
            ObjectMapper objectMapper = new ObjectMapper();
            jsonNode = objectMapper.readTree(jsonData);
            return jsonNode;
        }
        catch (Throwable throwable) {
            TestReporter.error("Something went wrong while Reading JSON File, Please check log: " + throwable.getMessage(), true);
            return null;
        }
    }

    public static JsonNode getJsonValue(String jsonFileName, String fieldName) {
        return ReadJSONFile.readJsonFile(jsonFileName).findValue(fieldName);
    }

    public static List<JsonNode> getJsonValues(String jsonFileName, String fieldName) {
        return ReadJSONFile.readJsonFile(jsonFileName).findValues(fieldName);
    }

    public static String getJsonValueAsString(String jsonFileName, String fieldName) {
        if (ReadJSONFile.getJsonValue(jsonFileName, fieldName) != null) {
            return ReadJSONFile.getJsonValue(jsonFileName, fieldName).asText();
        }
        return "";
    }

    public static List<String> getJsonValuesAsString(String jsonFileName, String fieldName) {
        ArrayList<String> values = new ArrayList<String>();
        ReadJSONFile.getJsonValues(jsonFileName, fieldName).listIterator().forEachRemaining(node -> values.add(node.asText()));
        return values;
    }
}

